/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.ConsoleInputHandler;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.InputHandler;
import edu.udo.cs.yale.Version;
import edu.udo.cs.yale.gui.SplashScreen;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;

public class Yale {
    private static final Set PROPERTY_TYPES = new TreeSet();
    public static final String LICENSE;
    private static Experiment experiment;
    private static InputHandler inputHandler;
    private static SplashScreen splashScreen;

    public static String getVersion() {
        return Version.getVersion();
    }

    public static void readExperimentFile(File experimentfile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        try {
            LogService.logMessage("Reading experiment file '" + experimentfile + "'.", 2);
            if (!experimentfile.exists() || !experimentfile.canRead()) {
                LogService.logMessage("Cannot read config file '" + experimentfile + "'!", 7);
            }
            experiment = new Experiment(experimentfile);
        }
        catch (XMLException e) {
            throw new XMLException(experimentfile.getName() + ":" + e.getMessage());
        }
    }

    public static Experiment getExperiment() {
        return experiment;
    }

    public static void setExperiment(Experiment experiment) {
        Yale.experiment = experiment;
    }

    public static void init() throws IOException {
        ParameterService.init();
        Plugin.registerAllPlugins();
    }

    public static SplashScreen showLogo() {
        try {
            splashScreen = new SplashScreen("YALE", Yale.getVersion(), ImageIO.read(Tools.getResource("yale_logo_java.gif")));
            splashScreen.showSplashScreen();
            return splashScreen;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void hideLogo() {
        try {
            splashScreen.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void splashMessage(String message) {
        if (splashScreen != null) {
            splashScreen.setMessage(message);
        }
    }

    public static void setInputHandler(InputHandler inputHandler) {
        Yale.inputHandler = inputHandler;
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static Set getYaleProperties() {
        return PROPERTY_TYPES;
    }

    public static void registerYaleProperty(ParameterType type) {
        PROPERTY_TYPES.add(type);
    }

    public static void quit(int errorcode) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.runFinalization();
        System.exit(errorcode);
    }

    static {
        System.setProperty("yale.version", Yale.getVersion());
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.editor", "Path to external Java editor. %f is replaced by filename and %l by the linenumber.", true));
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.sendmail.command", "Path to sendmail. Used for email notifications.", true));
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.gnuplot.command", "Path to gnuplot. Used to display results.", "/usr/bin/gnuplot"));
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.gnuplot.command", "Path to gnuplot. Used to display results.", "/usr/bin/gnuplot"));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.general.logfile.format", "Use unix special characters for logfile highlighting (requires new Yale instance).", false));
        LICENSE = "Yale version " + Yale.getVersion() + ", Copyright (C) 2001-2005\n" + "Yale comes with ABSOLUTELY NO WARRANTY; This is free software,\n" + "and you are welcome to redistribute it under certain conditions;\n" + "see license information in the file named LICENSE.";
        inputHandler = new ConsoleInputHandler();
    }
}

