/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.gui.DummyObjectVisualizer;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.ResultService;
import edu.udo.cs.yale.tools.TempFileService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Experiment {
    private ExperimentOperator rootOperator;
    private Operator currentOperator;
    private Map operatorNameMap = new HashMap();
    private File experimentFile;
    private List breakpointListeners = new LinkedList();
    private boolean stopExperiment = false;
    private List objectVisualizers = new LinkedList();
    private Map statisticsMap = new HashMap();
    private static final DummyObjectVisualizer DUMMY_VISUALIZER = new DummyObjectVisualizer();

    public Experiment() {
        try {
            this.rootOperator = (ExperimentOperator)OperatorService.createOperator("Experiment");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize root operator of the experiment: " + e.getMessage());
        }
        this.rootOperator.register(this, "Root");
    }

    public Experiment(URL url) throws IOException, XMLException {
        InputStream in = url.openStream();
        this.readExperiment(in);
        in.close();
    }

    public Experiment(File file) throws IOException, XMLException {
        FileInputStream in = new FileInputStream(file);
        this.readExperiment(in);
        ((InputStream)in).close();
        this.experimentFile = file;
    }

    public Experiment(String xmlString) throws IOException, XMLException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        this.readExperiment(in);
        in.close();
    }

    public Experiment(InputStream in) throws IOException, XMLException {
        this.readExperiment(in);
    }

    public boolean statisticsExist(String name) {
        return this.statisticsMap.get(name) != null;
    }

    public Statistics getStatistics(String name) {
        Statistics stats = (Statistics)this.statisticsMap.get(name);
        if (stats == null) {
            stats = new Statistics(name);
            this.statisticsMap.put(name, stats);
        }
        return stats;
    }

    public Collection getStatistics() {
        return this.statisticsMap.values();
    }

    public void clearStatistics() {
        this.statisticsMap.clear();
    }

    public ExperimentOperator getRootOperator() {
        return this.rootOperator;
    }

    public void setupFromXML(String xmlString) throws IOException, XMLException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        this.readExperiment(in);
        in.close();
    }

    public File getExperimentFile() {
        return this.experimentFile;
    }

    public String getFirstFreeName(String name) {
        if (this.operatorNameMap.get(name) != null) {
            int i = 2;
            while (this.operatorNameMap.get(name + " (" + i + ")") != null) {
                ++i;
            }
            name = name + " (" + i + ")";
        }
        return name;
    }

    public void registerOperator(String name, Operator operator) {
        this.operatorNameMap.put(name, operator);
    }

    public void unRegisterOperator(String name) {
        this.operatorNameMap.remove(name);
    }

    public Operator getOperator(String name) {
        return (Operator)this.operatorNameMap.get(name);
    }

    public Operator getCurrentOperator() {
        return this.currentOperator;
    }

    public Collection getAllOperators() {
        return this.operatorNameMap.values();
    }

    public Collection getAllOperatorNames() {
        return this.operatorNameMap.keySet();
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
    }

    public void addBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public void removeBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    public void fireBreakpointEvent(Operator operator, IOContainer ioContainer, int location) {
        Iterator i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            ((BreakpointListener)i.next()).breakpointReached(operator, ioContainer, location);
        }
    }

    public void fireResumeEvent() {
        Iterator i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            ((BreakpointListener)i.next()).resume();
        }
    }

    public void addObjectVisualizer(ObjectVisualizer visualizer) {
        this.objectVisualizers.add(visualizer);
    }

    public void removeObjectVisualizer(ObjectVisualizer visualizer) {
        this.objectVisualizers.remove(visualizer);
    }

    public ObjectVisualizer getVisualizerForObject(String id) {
        Iterator i = this.objectVisualizers.iterator();
        ObjectVisualizer capableVisualizer = DUMMY_VISUALIZER;
        while (i.hasNext()) {
            ObjectVisualizer visualizer = (ObjectVisualizer)i.next();
            if (!visualizer.isCapableToVisualize(id)) continue;
            capableVisualizer = visualizer;
        }
        return capableVisualizer;
    }

    private int checkIO() {
        Class[] nullClass = new Class[]{};
        LogService.logMessage("Checking i/o classes...", 3);
        try {
            Class[] output = this.rootOperator.checkIO(nullClass);
            if (output.length == 0) {
                LogService.logMessage("i/o classes are ok", 3);
            } else {
                String left = "";
                for (int i = 0; i < output.length; ++i) {
                    left = left + output[i].getName();
                    if (i >= output.length - 1) continue;
                    left = left + ", ";
                }
                LogService.logMessage("i/o classes are ok, but there is surplus output (" + left + ")", 3);
            }
            return 0;
        }
        catch (IllegalInputException e) {
            if (e.getOperator() != null) {
                e.getOperator().addError(e.getMessage());
            }
            return 1;
        }
    }

    private int checkNumberOfInnerOperators() {
        LogService.logMessage("Checking experimental setup...", 3);
        int errorCount = this.rootOperator.checkNumberOfInnerOperators();
        if (errorCount == 0) {
            LogService.logMessage("Inner operators are ok", 3);
        } else {
            LogService.logMessage("Experimental setup not ok", 6);
        }
        return errorCount;
    }

    private int checkProperties() {
        LogService.logMessage("Checking properties...", 3);
        int errorCount = this.rootOperator.checkProperties();
        if (errorCount == 0) {
            LogService.logMessage("Properties are ok", 3);
        } else {
            LogService.logMessage("Properties are not ok", 6);
        }
        return errorCount;
    }

    public boolean checkExperiment() {
        boolean ok = true;
        this.rootOperator.clearErrorList();
        int errorCount = this.checkProperties();
        if ((errorCount += this.checkNumberOfInnerOperators()) == 0) {
            errorCount += this.checkIO();
        }
        if (errorCount == 0) {
            LogService.logMessage("Experiment ok.", 3);
        } else {
            LogService.logMessage("There were " + errorCount + " errors.", 6);
            ok = false;
        }
        int deprecationCount = this.rootOperator.checkDeprecations();
        if (deprecationCount > 0) {
            LogService.logMessage("Deprecations: " + deprecationCount + (deprecationCount == 1 ? " usage" : " usages") + " of deprecated operators.", 4);
        }
        return ok;
    }

    public void prepareRun() throws OperatorException {
        this.stopExperiment = false;
        LogService.logMessage("Initialising experiment", 3);
        RandomGenerator.init(this);
        ResultService.init(this);
        TempFileService.init(this);
        this.checkExperiment();
        this.clearStatistics();
        AttributeFactory.resetNameCounter();
        this.rootOperator.experimentStarts();
        LogService.logMessage("Experiment initialised", 3);
    }

    public IOContainer run() throws OperatorException {
        IOObject[] nullIO = new IOObject[]{};
        IOContainer nullInput = new IOContainer(nullIO);
        return this.run(nullInput);
    }

    public IOContainer run(IOContainer input) throws OperatorException {
        long start = System.currentTimeMillis();
        LogService.logMessage("Experiment starts", 8);
        LogService.logMessage("Experiment:\n" + this.getRootOperator().createExperimentTree(3), 3);
        try {
            IOContainer result = this.rootOperator.apply(input);
            long end = System.currentTimeMillis();
            LogService.logMessage("Experiment finished after " + (end - start) / 1000L + " seconds", 8);
            LogService.logMessage("Experiment:\n" + this.getRootOperator().createExperimentTree(3), 3);
            LogService.logMessage("Produced output:\n" + result, 3);
            LogService.logMessage("Experiment finished successfully", 8);
            IOContainer iOContainer = result;
            return iOContainer;
        }
        catch (OperatorException e) {
            throw e;
        }
        finally {
            this.rootOperator.experimentFinished();
        }
    }

    public void tearDown() {
    }

    public void fatal() {
        this.rootOperator.experimentFinished();
    }

    public void save() throws IOException {
        this.save(this.experimentFile);
    }

    public void save(File file) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        this.rootOperator.writeXML(writer, "");
        writer.close();
        LogService.logMessage("Wrote experiment file '" + file + "'.", 2);
    }

    public void setExperimentFile(File file) {
        this.experimentFile = file;
    }

    public void stop() {
        this.stopExperiment = true;
    }

    public boolean shouldStop() {
        return this.stopExperiment;
    }

    public File resolveFileName(String name) {
        File workingDir = new File(System.getProperty("user.dir"));
        return Tools.getFile(this.experimentFile != null ? this.experimentFile.getParentFile() : workingDir, name);
    }

    public File createFile(String name) {
        File file = this.resolveFileName(name);
        Tools.mkdir(file.getParentFile());
        return file;
    }

    public void readExperiment(InputStream in) throws XMLException, IOException {
        Map nameMapBackup = this.operatorNameMap;
        this.operatorNameMap = new HashMap();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            Operator root = Operator.createFromXML(document.getDocumentElement(), this);
            if (!(root instanceof ExperimentOperator)) {
                throw new XMLException("Outermost operator must be Experiment!");
            }
            this.rootOperator = (ExperimentOperator)root;
            nameMapBackup = this.operatorNameMap;
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e.toString(), e);
        }
        catch (SAXException e) {
            throw new XMLException("Cannot parse document: " + e, e);
        }
        finally {
            this.operatorNameMap = nameMapBackup;
        }
    }
}

