/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.SVM;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVM;
import edu.udo.cs.yale.operator.Operator;

public class SVMregression
extends SVM {
    public SVMregression() {
    }

    public SVMregression(Operator paramOperator, Kernel kernel, ExampleSet exampleSet, edu.udo.cs.yale.example.ExampleSet yaleExamples) {
        super(paramOperator, kernel, exampleSet, yaleExamples);
    }

    protected void optimize() {
        int j;
        double target_tmp;
        int i;
        double[] my_primal = this.primal;
        this.qp.b[0] = 0.0;
        for (i = 0; i < this.working_set_size; ++i) {
            this.qp.b[0] = this.qp.b[0] + this.alphas[this.working_set[i]];
        }
        double new_target = 0.0;
        double old_target = 0.0;
        for (i = 0; i < this.working_set_size; ++i) {
            target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
            for (j = 0; j < i; ++j) {
                target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
            }
            old_target += (target_tmp += this.qp.c[i]) * my_primal[i];
        }
        double new_constraint_sum = 0.0;
        double my_is_zero = this.is_zero;
        int sv_count = this.working_set_size;
        boolean KKTerror = true;
        boolean convError = false;
        this.qp.max_allowed_error = this.convergence_epsilon;
        this.qp.x = this.primal;
        this.qp.solve();
        this.primal = this.qp.x;
        this.lambda_WS = this.qp.lambda_eq;
        my_primal = this.primal;
        int it = 3;
        while (KKTerror && it > 0) {
            KKTerror = false;
            --it;
            for (i = 0; i < this.working_set_size; ++i) {
                if (!(my_primal[i] < this.is_zero)) continue;
                double lambda_lo = this.epsilon_neg + this.epsilon_pos - this.qp.c[i];
                for (j = 0; j < this.working_set_size; ++j) {
                    lambda_lo -= my_primal[j] * this.qp.H[i * this.working_set_size + j];
                }
                lambda_lo = this.qp.A[i] > 0.0 ? (lambda_lo -= this.lambda_WS) : (lambda_lo += this.lambda_WS);
                if (!(lambda_lo < -this.convergence_epsilon)) continue;
                KKTerror = true;
                this.qp.A[i] = -this.qp.A[i];
                this.which_alpha[i] = !this.which_alpha[i];
                my_primal[i] = -my_primal[i];
                this.qp.c[i] = this.epsilon_neg + this.epsilon_pos - this.qp.c[i];
                this.qp.u[i] = this.qp.A[i] > 0.0 ? this.Cneg[this.working_set[i]] : this.Cpos[this.working_set[i]];
                for (j = 0; j < this.working_set_size; ++j) {
                    this.qp.H[i * this.working_set_size + j] = -this.qp.H[i * this.working_set_size + j];
                    this.qp.H[j * this.working_set_size + i] = -this.qp.H[j * this.working_set_size + i];
                }
                if (this.quadraticLossNeg) {
                    if (this.which_alpha[i]) {
                        int n = i * (this.working_set_size + 1);
                        this.qp.H[n] = this.qp.H[n] + 1.0 / this.Cneg[this.working_set[i]];
                        this.qp.u[i] = Double.MAX_VALUE;
                    } else {
                        int n = i * (this.working_set_size + 1);
                        this.qp.H[n] = this.qp.H[n] - 1.0 / this.Cneg[this.working_set[i]];
                    }
                }
                if (!this.quadraticLossPos) continue;
                if (!this.which_alpha[i]) {
                    int n = i * (this.working_set_size + 1);
                    this.qp.H[n] = this.qp.H[n] + 1.0 / this.Cpos[this.working_set[i]];
                    this.qp.u[i] = Double.MAX_VALUE;
                    continue;
                }
                int n = i * (this.working_set_size + 1);
                this.qp.H[n] = this.qp.H[n] - 1.0 / this.Cpos[this.working_set[i]];
            }
            this.qp.x = my_primal;
            this.qp.solve();
            my_primal = this.qp.x;
            this.lambda_WS = this.qp.lambda_eq;
        }
        KKTerror = true;
        while (KKTerror) {
            sv_count = this.working_set_size;
            new_constraint_sum = this.qp.b[0];
            for (i = 0; i < this.working_set_size; ++i) {
                if (my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.l[i];
                    --sv_count;
                } else if (this.qp.u[i] - my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.u[i];
                    --sv_count;
                }
                new_constraint_sum -= this.qp.A[i] * my_primal[i];
            }
            if (sv_count > 0) {
                this.logln(5, "adjusting " + sv_count + " alphas by " + (new_constraint_sum /= (double)sv_count));
                for (i = 0; i < this.working_set_size; ++i) {
                    if (!(my_primal[i] > this.qp.l[i]) || !(my_primal[i] < this.qp.u[i])) continue;
                    int n = i;
                    my_primal[n] = my_primal[n] + this.qp.A[i] * new_constraint_sum;
                }
            } else if (Math.abs(new_constraint_sum) > (double)this.working_set_size * this.is_zero) {
                this.logln(5, "WARNING: No SVs, constraint_sum = " + new_constraint_sum);
                old_target = -4.9E-324;
                convError = true;
            }
            new_target = 0.0;
            for (i = 0; i < this.working_set_size; ++i) {
                target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
                for (j = 0; j < i; ++j) {
                    target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                }
                new_target += (target_tmp += this.qp.c[i]) * my_primal[i];
            }
            if (new_target < old_target) {
                KKTerror = false;
                if (this.descend < old_target - new_target) {
                    this.target_count = 0;
                } else {
                    convError = true;
                }
                this.logln(5, "descend = " + (old_target - new_target));
                continue;
            }
            if (sv_count > 0) {
                my_is_zero = Double.MAX_VALUE;
                for (i = 0; i < this.working_set_size; ++i) {
                    if (!(my_primal[i] > this.qp.l[i]) || !(my_primal[i] < this.qp.u[i])) continue;
                    if (my_primal[i] - this.qp.l[i] < my_is_zero) {
                        my_is_zero = my_primal[i] - this.qp.l[i];
                    }
                    if (!(this.qp.u[i] - my_primal[i] < my_is_zero)) continue;
                    my_is_zero = this.qp.u[i] - my_primal[i];
                }
                if (this.target_count == 0) {
                    my_is_zero *= 2.0;
                }
                this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), adjusting is_zero to " + my_is_zero);
                this.logln(5, "new_target = " + new_target);
                continue;
            }
            this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), stopping.");
            KKTerror = false;
            convError = true;
        }
        if (convError) {
            ++this.target_count;
            if (old_target < new_target) {
                for (i = 0; i < this.working_set_size; ++i) {
                    my_primal[i] = this.qp.A[i] * this.alphas[this.working_set[i]];
                }
                this.logln(5, "WARNING: Convergence error, restoring old primals");
            }
        }
        if (this.target_count > 50) {
            this.convergence_epsilon *= 2.0;
            this.feasible_epsilon = this.convergence_epsilon;
            this.logln(1, "WARNING: reducing KKT precision to " + this.convergence_epsilon);
            this.target_count = 0;
        }
    }

    protected final boolean is_alpha_neg(int i) {
        double alpha = this.alphas[i];
        boolean result = alpha > 0.0 ? true : (alpha == 0.0 ? !(this.sum[i] - this.ys[i] + this.lambda_eq > 0.0) : false);
        return result;
    }

    protected final double nabla(int i) {
        double alpha = this.alphas[i];
        double y = this.ys[i];
        double result = alpha > 0.0 ? this.sum[i] - y + this.epsilon_neg : (alpha == 0.0 ? (this.is_alpha_neg(i) ? this.sum[i] - y + this.epsilon_neg : -this.sum[i] + y + this.epsilon_pos) : -this.sum[i] + y + this.epsilon_pos);
        return result;
    }
}

