/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.mySVM.Kernel;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Util.Cache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Kernel {
    protected ExampleSet the_examples;
    protected int dim;
    protected Cache kernel_cache;
    protected int kernel_cache_size;
    protected int cache_MB;
    protected int examples_total;

    public String toString() {
        return "abstract kernel class";
    }

    public void init(ExampleSet examples, int cacheSizeMB) {
        this.the_examples = examples;
        this.examples_total = this.the_examples.count_examples();
        this.dim = this.the_examples.get_dim();
        this.init_kernel_cache(cacheSizeMB);
    }

    public abstract double calculate_K(int[] var1, double[] var2, int[] var3, double[] var4);

    public double innerproduct(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double result = 0.0;
        int xpos = x_index.length - 1;
        int ypos = y_index.length - 1;
        while (xpos >= 0 && ypos >= 0) {
            if (x_index[xpos] == y_index[ypos]) {
                result += x_att[xpos] * y_att[ypos];
                --xpos;
                --ypos;
                continue;
            }
            if (x_index[xpos] > y_index[ypos]) {
                --xpos;
                continue;
            }
            --ypos;
        }
        return result;
    }

    public double norm2(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double tmp;
        double result = 0.0;
        int xpos = x_index.length - 1;
        int ypos = y_index.length - 1;
        while (xpos >= 0 && ypos >= 0) {
            if (x_index[xpos] == y_index[ypos]) {
                tmp = x_att[xpos] - y_att[ypos];
                result += tmp * tmp;
                --xpos;
                --ypos;
                continue;
            }
            if (x_index[xpos] > y_index[ypos]) {
                tmp = x_att[xpos];
                result += tmp * tmp;
                --xpos;
                continue;
            }
            tmp = y_att[ypos];
            result += tmp * tmp;
            --ypos;
        }
        while (xpos >= 0) {
            tmp = x_att[xpos];
            result += tmp * tmp;
            --xpos;
        }
        while (ypos >= 0) {
            tmp = y_att[ypos];
            result += tmp * tmp;
            --ypos;
        }
        return result;
    }

    public double[] get_row(int i) {
        double[] result = null;
        result = (double[])this.kernel_cache.get_element(i);
        if (result == null) {
            result = (double[])this.kernel_cache.get_lru_element();
            if (result == null) {
                result = new double[this.examples_total];
            }
            this.calculate_K_row(result, i);
            this.kernel_cache.put_element(i, result);
        }
        return result;
    }

    public void init_kernel_cache(int size) {
        this.cache_MB = size;
        this.kernel_cache_size = size * 0x100000 / 4 / this.examples_total;
        if (this.kernel_cache_size < 1) {
            this.kernel_cache_size = 1;
        }
        if (this.kernel_cache_size > this.the_examples.count_examples()) {
            this.kernel_cache_size = this.the_examples.count_examples();
        }
        this.kernel_cache = new Cache(this.kernel_cache_size, this.examples_total);
    }

    public int getCacheSize() {
        return this.cache_MB;
    }

    public void set_examples_size(int new_examples_total) {
        int new_kernel_cache_size = this.cache_MB * 0x100000 / 4 / new_examples_total;
        if (new_kernel_cache_size < 1) {
            new_kernel_cache_size = 1;
        }
        if (new_kernel_cache_size > new_examples_total) {
            new_kernel_cache_size = new_examples_total;
        }
        if (new_examples_total < this.examples_total) {
            this.kernel_cache.shrink(new_kernel_cache_size, new_examples_total);
        } else if (new_examples_total > this.examples_total) {
            this.kernel_cache.init(new_kernel_cache_size);
        }
        this.kernel_cache_size = new_kernel_cache_size;
        this.examples_total = new_examples_total;
    }

    public double calculate_K(int i, int j) {
        int[] x_index = this.the_examples.index[i];
        double[] x_att = this.the_examples.atts[i];
        int[] y_index = this.the_examples.index[j];
        double[] y_att = this.the_examples.atts[j];
        return this.calculate_K(x_index, x_att, y_index, y_att);
    }

    public double calculate_K(Example x, Example y) {
        return this.calculate_K(x.index, x.att, y.index, y.att);
    }

    public double[] calculate_K_row(double[] result, int i) {
        int[] x_index = this.the_examples.index[i];
        double[] x_att = this.the_examples.atts[i];
        for (int k = 0; k < this.examples_total; ++k) {
            int[] y_index = this.the_examples.index[k];
            double[] y_att = this.the_examples.atts[k];
            result[k] = this.calculate_K(x_index, x_att, y_index, y_att);
        }
        return result;
    }

    public void swap(int pos1, int pos2) {
        this.kernel_cache.swap(pos1, pos2);
    }

    public abstract void writeKernelParameters(ObjectOutputStream var1) throws IOException;

    public abstract void readKernelParameters(ObjectInputStream var1) throws IOException;
}

