/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.util;

import edu.udo.cs.jvito.exception.KeyException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Preference;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Preferences {
    public static final int INT = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;
    public static final int LIST = 4;
    public static final String[] TYPES = new String[]{"Integer", "Double", "String", "Boolean", "List"};
    private HashMap map;
    private String filename;

    public Preferences(String file) {
        this.filename = file;
        this.map = new HashMap();
    }

    public String getFileName() {
        return this.filename;
    }

    public int getInt(String key) throws KeyException {
        if (!this.map.containsKey(key)) {
            throw new KeyException("The key " + (key == null ? "" : key) + " is not in the Preferences-Map");
        }
        Preference pref = (Preference)this.map.get(key);
        if (pref.getType() != 0) {
            throw new KeyException("You want to load an integer-value with that key,\n but for that key the Preference-Map contains a " + TYPES[pref.getType()] + "-value!");
        }
        return (Integer)pref.getObject();
    }

    public void setInt(String key, int value) {
        this.map.put(key, new Preference(0, new Integer(value)));
    }

    public double getDouble(String key) throws KeyException {
        if (!this.map.containsKey(key)) {
            throw new KeyException("The key " + (key == null ? "" : key) + " is not in the Preferences-Map");
        }
        Preference pref = (Preference)this.map.get(key);
        if (pref.getType() != 1) {
            throw new KeyException("You want to load a double-value with that key,\n but for that key the Preference-Map contains a " + TYPES[pref.getType()] + "-value!");
        }
        return (Double)pref.getObject();
    }

    public void setDouble(String key, double value) {
        this.map.put(key, new Preference(1, new Double(value)));
    }

    public String getString(String key) throws KeyException {
        if (!this.map.containsKey(key)) {
            throw new KeyException("The key " + (key == null ? "" : key) + " is not in the Preferences-Map");
        }
        Preference pref = (Preference)this.map.get(key);
        if (pref.getType() != 2) {
            throw new KeyException("You want to load a String-value with that key,\n but for that key the Preference-Map contains a " + TYPES[pref.getType()] + "-value!");
        }
        return (String)pref.getObject();
    }

    public void setString(String key, String value) {
        this.map.put(key, new Preference(2, value));
    }

    public boolean getBoolean(String key) throws KeyException {
        if (!this.map.containsKey(key)) {
            throw new KeyException("The key " + (key == null ? "" : key) + " is not in the Preferences-Map");
        }
        Preference pref = (Preference)this.map.get(key);
        if (pref.getType() != 3) {
            throw new KeyException("You want to load a boolean-value with that key,\n but for that key the Preference-Map contains a " + TYPES[pref.getType()] + "-value!");
        }
        return (Boolean)pref.getObject();
    }

    public void setBoolean(String key, boolean value) {
        this.map.put(key, new Preference(3, new Boolean(value)));
    }

    public List getList(String key) throws KeyException {
        if (!this.map.containsKey(key)) {
            throw new KeyException("The key " + (key == null ? "" : key) + " is not in the Preferences-Map");
        }
        Preference pref = (Preference)this.map.get(key);
        if (pref.getType() != 4) {
            throw new KeyException("You want to load a List with that key,\n but for that key the Preference-Map contains a " + TYPES[pref.getType()] + "-value!");
        }
        LinkedList<Object> list = new LinkedList<Object>();
        LinkedList maplist = (LinkedList)pref.getObject();
        Iterator iter = maplist.iterator();
        while (iter.hasNext()) {
            Preference listelem = (Preference)iter.next();
            list.add(listelem.getObject());
        }
        return list;
    }

    public void setList(String key, List value, int type) {
        LinkedList<Preference> maplist = new LinkedList<Preference>();
        Iterator list = value.iterator();
        while (list.hasNext()) {
            Preference pref = new Preference(type, list.next());
            maplist.add(pref);
        }
        this.map.put(key, new Preference(4, maplist));
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.filename);
        this.writePreferencesAsXML(out);
        out.close();
        Logger.logMessage("Preferences saved to: " + this.filename.toString(), 1);
    }

    public void save(String filename) throws IOException {
        this.filename = filename;
        this.save();
    }

    private void writePreferencesAsXML(OutputStream out) throws IOException {
        Set keys = this.map.keySet();
        Iterator iter = keys.iterator();
        out.write("".getBytes());
        out.write("<preferences>\n".getBytes());
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Preference pref = (Preference)this.map.get(key);
            this.writePreferenceAsXML(key, pref, out, "\t");
        }
        out.write("</preferences>\n".getBytes());
    }

    private void writePreferenceAsXML(String key, Preference pref, OutputStream out, String indent) throws IOException {
        if (pref.getType() == 0) {
            int value = (Integer)pref.getObject();
            out.write((indent + "<preference key=\"" + key + "\" type=\"" + TYPES[pref.getType()] + "\" value=\"" + value + "\"/>\n").getBytes());
        } else if (pref.getType() == 1) {
            double value = (Double)pref.getObject();
            out.write((indent + "<preference key=\"" + key + "\" type=\"" + TYPES[pref.getType()] + "\" value=\"" + value + "\"/>\n").getBytes());
        } else if (pref.getType() == 2) {
            String value = (String)pref.getObject();
            out.write((indent + "<preference key=\"" + key + "\" type=\"" + TYPES[pref.getType()] + "\" value=\"" + value + "\"/>\n").getBytes());
        } else if (pref.getType() == 3) {
            boolean value = (Boolean)pref.getObject();
            out.write((indent + "<preference key=\"" + key + "\" type=\"" + TYPES[pref.getType()] + "\" value=\"" + value + "\"/>\n").getBytes());
        } else if (pref.getType() == 4) {
            List list = (List)pref.getObject();
            out.write((indent + "<preference key=\"" + key + "\" type=\"" + TYPES[pref.getType()] + "\"/>\n").getBytes());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                pref = (Preference)iter.next();
                this.writePreferenceAsXML(key, pref, out, indent + "\t");
            }
            out.write((indent + "</preferences>").getBytes());
        }
    }

    public void load() throws XMLException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.filename);
            this.loadXMLDocument(document.getDocumentElement());
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e.toString(), e);
        }
        catch (SAXException e) {
            throw new XMLException("Cannot parse document: " + e, e);
        }
    }

    public void load(String filename) throws XMLException {
        this.filename = filename;
        this.load();
    }

    private void loadXMLDocument(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("preferences")) {
            throw new XMLException("<preferences> expected!");
        }
        NodeList innerTags = element.getChildNodes();
        for (int i = 0; i < innerTags.getLength(); ++i) {
            Element inner;
            Node node = innerTags.item(i);
            if (!(node instanceof Element) || !(inner = (Element)node).getTagName().toLowerCase().equals("preference")) continue;
            int type = this.getType(inner.getAttributeNode("type").getValue());
            String key = inner.getAttributeNode("key").getValue();
            Object obj = this.getObjectForType(inner, type);
            Preference pref = new Preference(type, obj);
            this.map.put(key, pref);
        }
    }

    private Object getObjectForType(Element inner, int type) throws XMLException {
        String value = inner.getAttributeNode("value").getValue();
        try {
            if (type == 0) {
                Integer i = new Integer(Integer.parseInt(value));
                return i;
            }
            if (type == 1) {
                Double d = new Double(Double.parseDouble(value));
                return d;
            }
            if (type == 2) {
                return value;
            }
            if (type == 3) {
                Boolean b = value.equals("true") ? new Boolean(true) : new Boolean(false);
                return b;
            }
            if (type == 4) {
                LinkedList<Preference> list = new LinkedList<Preference>();
                NodeList innerTags = inner.getChildNodes();
                for (int i = 0; i < innerTags.getLength(); ++i) {
                    Node node = innerTags.item(i);
                    if (!(node instanceof Element)) continue;
                    Element inner2 = (Element)node;
                    if (inner2.getTagName().toLowerCase().equals("preference")) {
                        int typeinner = this.getType(inner2.getAttributeNode("type").getValue());
                        String keyinner = inner.getAttributeNode("key").getValue();
                        Object objinner = this.getObjectForType(inner2, typeinner);
                        Preference prefinner = new Preference(typeinner, objinner);
                        list.add(prefinner);
                        continue;
                    }
                    throw new XMLException("Ilegal inner tag for <preference>: " + inner.getTagName());
                }
                return list;
            }
        }
        catch (NumberFormatException error) {
            throw new XMLException("Illegal numbner format", error);
        }
        throw new XMLException("Ilegal type for <preference>: " + type);
    }

    public int getType(String stringType) {
        for (int i = 0; i < TYPES.length; ++i) {
            if (!TYPES[i].equals(stringType)) continue;
            return i;
        }
        return 2;
    }

    public String toString() {
        try {
            this.writePreferencesAsXML(System.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

