/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.plot.svm.AttributeFunctionValuePanel;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;

public class AttributeFunctionValuePlot
extends SimplePlot {
    private int number_atts = 0;
    private int number_of_samples = 0;
    private int x_attr = 0;
    private int y_attr = 0;
    private int c_attr;
    private Attribute x_attribute;
    private Attribute y_attribute;
    private Attribute colorattribute;
    private double[] x_samples;
    private double[] y_samples;
    private float[] labelvalues;
    private float[] colorsamples;
    private JPanel mainpane;

    public JPanel getPlotPanel() {
        return this.mainpane;
    }

    public AttributeFunctionValuePlot() {
    }

    public AttributeFunctionValuePlot(String name) {
        this.setName(name);
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout());
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.mainpane.add((Component)this.plotpanel, "Center");
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            this.mainpane.add((Component)colorpanel, "East");
        }
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new AttributeFunctionValuePanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.x_attribute, this.y_attribute, this.x_samples, this.y_samples, this.getParameterAsDouble("point_size"));
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(set.getLabel().getName())) {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfLabel(this.colorattribute));
                this.plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.colorsamples.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.colorsamples[i];
                }
                this.plotpanel.colorByAttribute(this.colorattribute, pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNumerical()) {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
                this.plotpanel.initColorTable();
            } else {
                this.plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.colorattribute));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.colorattribute));
                this.plotpanel.initColorTable();
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDynamicCategory("attribute", "Attribute for the x-axis.", this.getAttributes(), 0);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        type = new ParameterTypeDouble("point_size", "Size of the points.", 0.0, 100.0, 5.0);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("Cannot compile ScatterPlot2D. This operator must be achild of a data-operator.");
        }
        ExampleSet set = this.source.getExampleSet();
        if (set.getPredictedLabel() == null) {
            throw new CompilerException("The ExampleSet must have a numerical predicted label.");
        }
        if (set.getPredictedLabel().isNominal()) {
            throw new CompilerException("The ExampleSet must have a numerical predicted label.");
        }
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.x_samples = new double[this.number_of_samples];
        this.y_samples = new double[this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        if (this.getParameterAsInt("color_attribute") != 0) {
            this.colorsamples = new float[this.number_of_samples];
        }
        this.x_attr = this.getParameterAsInt("attribute");
        this.c_attr = this.getParameterAsInt("color_attribute") - 1;
        this.x_attribute = this.x_attr < this.number_atts ? set.getAttribute(this.x_attr) : (this.x_attr == this.number_atts && set.getLabel() != null ? set.getLabel() : set.getPredictedLabel());
        this.y_attribute = set.getPredictedLabel();
        if (this.c_attr >= 0) {
            this.colorattribute = this.c_attr < this.number_atts ? set.getAttribute(this.c_attr) : (this.c_attr == this.number_atts && set.getLabel() != null ? set.getLabel() : set.getPredictedLabel());
        }
        boolean haslabel = set.getLabel() != null;
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            this.x_samples[sample] = this.x_attr < this.number_atts ? example.getValue(this.x_attribute) : (this.x_attr == this.number_atts && set.getLabel() != null ? example.getLabel() : example.getPredictedLabel());
            this.y_samples[sample] = example.getPredictedLabel();
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (this.c_attr < 0) continue;
            this.colorsamples[sample] = this.c_attr < this.number_atts ? (float)example.getValue(this.colorattribute) : (this.c_attr == this.number_atts && set.getLabel() != null ? (float)example.getLabel() : (float)example.getPredictedLabel());
        }
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("attribute")).setValues(this.getAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
        ((ParameterTypeDynamicCategory)this.getParameterType("attribute")).setValues(this.getAttributes());
    }

    public String[] getAttributes() {
        if (this.source == null) {
            return new String[]{""};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{""};
        }
        int count = 0;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i).getName();
        }
        int index = set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
        }
        return categories;
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

