/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot.svm;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.jvito.util.GraphicsUtils;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;

public class AttributeFunctionValuePanel
extends PlotPanel
implements MouseListener {
    private Attribute x_attribute;
    private Attribute y_attribute;
    private double[] x_samples;
    private double[] y_samples;
    private int width;
    private int height;
    private int pixelgesamt;
    private boolean mousepressed = false;
    private ExampleSet set;
    private ExampleColoring coloring;
    private double point_size;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private boolean drawValue;
    private double value;
    private boolean drawBounds;

    public AttributeFunctionValuePanel(ExampleSet set, ExampleColoring coloring, Attribute x_attribute, Attribute y_attribute, double[] x_samples, double[] y_samples, double point_size) {
        this.set = set;
        this.coloring = coloring;
        this.x_attribute = x_attribute;
        this.y_attribute = y_attribute;
        if (x_attribute.isNominal()) {
            this.x_min = 0.0;
            this.x_max = (double)x_attribute.getNumberOfValues() - 1.0;
        } else {
            this.x_min = x_attribute.getMinimum();
            this.x_max = x_attribute.getMaximum();
        }
        if (y_attribute.isNominal()) {
            this.y_min = 0.0;
            this.y_max = (double)y_attribute.getNumberOfValues() - 1.0;
        } else {
            this.y_min = y_attribute.getMinimum();
            this.y_max = y_attribute.getMaximum();
        }
        this.x_samples = x_samples;
        this.y_samples = y_samples;
        this.drawValue = false;
        this.drawBounds = true;
        this.point_size = point_size;
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void setXAttribute(Attribute attribute) {
        this.x_attribute = attribute;
    }

    public void setYAttribute(Attribute attribute) {
        this.y_attribute = attribute;
    }

    public void setValues(double[] x, double[] y) {
        this.x_samples = x;
        this.y_samples = y;
        this.x_min = Double.POSITIVE_INFINITY;
        this.x_max = Double.NEGATIVE_INFINITY;
        this.y_min = Double.POSITIVE_INFINITY;
        this.y_max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < x.length; ++i) {
            this.x_min = Math.min(this.x_min, x[i]);
            this.x_max = Math.max(this.x_max, x[i]);
            this.y_min = Math.min(this.y_min, y[i]);
            this.y_max = Math.max(this.y_max, y[i]);
        }
    }

    public void setDrawBounds(boolean draw) {
        this.drawBounds = draw;
    }

    public void setDrawLineForValue(double value) {
        this.drawValue = true;
        this.value = value;
    }

    public void paint(Graphics g) {
        double x;
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.pixelgesamt = Math.min(this.width, this.height) - 120;
        g.drawRect(this.getX(70), this.getY(70), this.width - 140, this.height - 140);
        g.drawLine(this.getX(60), this.getY(70), this.getX(60), this.getY(this.height - 70));
        g.drawLine(this.getX(70), this.getY(this.height - 60), this.getX(this.width - 70), this.getY(this.height - 60));
        g.drawLine(this.getX(53), this.getY(70), this.getX(67), this.getY(70));
        g.drawLine(this.getX(53), this.getY(this.height - 70), this.getX(67), this.getY(this.height - 70));
        g.drawLine(this.getX(70), this.getY(this.height - 53), this.getX(70), this.getY(this.height - 67));
        g.drawLine(this.getX(this.width - 70), this.getY(this.height - 53), this.getX(this.width - 70), this.getY(this.height - 67));
        Font font = new Font("SansSerif", 0, 20);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int slen = fm.stringWidth(this.x_attribute.getName() + " vs " + this.y_attribute.getName());
        g.drawString(this.x_attribute.getName() + " vs " + this.y_attribute.getName(), this.getX((this.width - slen) / 2), this.getY(this.height - 7));
        font = new Font("SansSerif", 0, 15);
        g.setFont(font);
        slen = fm.stringWidth(Float.toString((float)this.x_max));
        g.drawString(Float.toString((float)this.x_max), this.getX(this.width - 70 - slen / 2), this.getY(this.height - 40));
        slen = fm.stringWidth(Float.toString((float)this.x_min));
        g.drawString(Float.toString((float)this.x_min), this.getX(70), this.getY(this.height - 40));
        slen = fm.stringWidth(Float.toString((float)this.y_max));
        g.drawString(Float.toString((float)this.y_max), this.getX(60 - slen / 2), this.getY(65));
        slen = fm.stringWidth(Float.toString((float)this.y_min));
        g.drawString(Float.toString((float)this.y_min), this.getX(60 - slen / 2), this.getY(this.height - 25));
        if (this.drawBounds) {
            x = (double)(this.height - 140) / (this.y_max - this.y_min) * (0.0 - this.y_min);
            g.drawLine(this.getX(70), this.getY((int)((double)(this.height - 70) - x)), this.getX(this.width - 70), this.getY((int)((double)(this.height - 70) - x)));
            x = (double)(this.height - 140) / (this.y_max - this.y_min) * (1.0 - this.y_min);
            GraphicsUtils.drawScatteredLine(g, 10, this.getX(70), this.getX(this.width - 70), this.getY((int)((double)(this.height - 70) - x)));
            x = (double)(this.height - 140) / (this.y_max - this.y_min) * (-1.0 - this.y_min);
            GraphicsUtils.drawScatteredLine(g, 10, this.getX(70), this.getX(this.width - 70), this.getY((int)((double)(this.height - 70) - x)));
        }
        if (this.drawValue) {
            x = (double)(this.height - 140) / (this.y_max - this.y_min) * (this.value - this.y_min);
            g.drawLine(this.getX(70), this.getY((int)((double)(this.height - 70) - x)), this.getX(this.width - 70), this.getY((int)((double)(this.height - 70) - x)));
        }
        for (int sample = 0; sample < this.x_samples.length; ++sample) {
            this.drawSample(g, sample);
        }
        this.paintMouseInfo(null);
    }

    public void drawSample(Graphics g, int sample) {
        if (this.colorbyattribute) {
            int index;
            if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
            } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                } else {
                    index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            } else {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                }
                if (this.colorattr.isNumerical()) {
                    index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            }
        }
        double x_breite = this.x_max - this.x_min;
        double y_breite = this.y_max - this.y_min;
        double x = 70.0 + (double)(this.width - 140) * ((this.x_samples[sample] - this.x_min) / x_breite) - (double)((int)(this.point_size / 2.0));
        double y = (double)(this.height - 70) - (double)(this.height - 140) * ((this.y_samples[sample] - this.y_min) / y_breite) - (double)((int)(this.point_size / 2.0));
        g.fillRect(this.getX((int)x), this.getY((int)y), (int)this.point_size, (int)this.point_size);
    }

    public void paintMouseInfo(MouseEvent event) {
        if (this.mousepressed && event != null) {
            int x = event.getX();
            int y = event.getY();
            Graphics g = this.getGraphics();
            g.setColor(this.background);
            g.fillRect(0, 0, this.width, 30);
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            g.drawString(this.x_attribute.getName() + ": " + this.getValueX(this.getOrigin().x * -1 + x), 5, 11);
            g.drawString(this.y_attribute.getName() + ": " + this.getValueY(this.getOrigin().y * -1 + y), 5, 26);
        }
    }

    public double getValueX(int x) {
        if (x < 70) {
            return this.x_min;
        }
        if (x > this.width - 70) {
            return this.x_max;
        }
        double breite = this.x_max - this.x_min;
        double value = this.x_min + breite / (double)(this.width - 140) * (double)(x -= 70);
        return value;
    }

    public double getValueY(int y) {
        if (y < 70) {
            return this.y_max;
        }
        if (y > this.height - 70) {
            return this.y_min;
        }
        y -= 70;
        y = this.height - 140 - y;
        double breite = this.y_max - this.y_min;
        double value = this.y_min + breite / (double)(this.height - 140) * (double)y;
        return value;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 2) {
            this.mousepressed = true;
            this.paintMouseInfo(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mousepressed = false;
        this.repaint();
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            AttributeFunctionValuePanel.this.paintMouseInfo(event);
        }
    }
}

