/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.MatrixLayout;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.plot.RectangularGridLayout;
import edu.udo.cs.jvito.plot.ScatterPlot2DPanel;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class ScatterPlot_2DMatrix
extends Plot
implements AdjustmentListener,
MouseListener,
MouseMotionListener {
    protected int CurX = 0;
    protected int CurY = 0;
    private int oldX;
    private int oldY;
    protected int NumVisX;
    protected int NumVisY;
    protected int LABEL_WIDTH = 30;
    protected int LABEL_HEIGHT = 20;
    protected static final int MIN_VIS_WIDTH = 50;
    protected static final int MIN_VIS_HEIGHT = 50;
    protected int DEFAULT_VIS_WIDTH = 150;
    protected int DEFAULT_VIS_HEIGHT = 150;
    protected Panel DisplayPanel;
    protected JPanel ScrollPanel;
    protected ScrollPane SCPane;
    protected JViewport HorizLabels;
    protected JViewport VertLabels;
    protected JPanel[] HorizLabel;
    protected JPanel[] VertLabel;
    protected JComponent[] HorizDrag;
    protected JComponent[] VertDrag;
    protected JPanel HorizPanel;
    protected JPanel VertPanel;
    private JPanel plotpanel;
    private JPanel display;
    private JPanel widgets;
    private JPanel mainpane;
    private Attribute[] attributes;
    private int number_atts = 0;
    private int number_of_samples = 0;
    private double[][] samples;
    private int c_attr = 0;
    private ScatterPlot2DPanel[][] displaypanel;
    private Attribute colorattribute;
    private float[] colorsamples;

    public Component getSaveableComponent() {
        return this.DisplayPanel;
    }

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void init() {
        JViewport vl;
        JViewport hl;
        if (!this.source.isCompiled()) {
            return;
        }
        ExampleSet set = this.source.getExampleSet();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.plotpanel = new JPanel();
        this.plotpanel.setBackground(Color.white);
        this.plotpanel.setLayout(new BoxLayout(this.plotpanel, 1));
        this.mainpane.add((Component)this.plotpanel, "Center");
        JPanel horizShell = new JPanel();
        horizShell.setBackground(Color.white);
        horizShell.setLayout(new BoxLayout(horizShell, 0));
        horizShell.add(Box.createRigidArea(new Dimension(this.LABEL_WIDTH + 6, 0)));
        this.plotpanel.add(horizShell);
        this.HorizPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, ScatterPlot_2DMatrix.this.LABEL_HEIGHT);
            }
        };
        this.HorizPanel.setBackground(Color.white);
        this.constructHorizontalLabels();
        this.HorizLabels = hl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(0, ScatterPlot_2DMatrix.this.LABEL_HEIGHT);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, ScatterPlot_2DMatrix.this.LABEL_HEIGHT);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, ScatterPlot_2DMatrix.this.LABEL_HEIGHT);
            }
        };
        this.HorizLabels.setView(this.HorizPanel);
        horizShell.add(this.HorizLabels);
        horizShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(6 + ScatterPlot_2DMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(6 + ScatterPlot_2DMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(6 + ScatterPlot_2DMatrix.this.SCPane.getVScrollbarWidth(), 0);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.white);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        this.plotpanel.add(mainPanel);
        this.plotpanel.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel vertShell = new JPanel();
        vertShell.setBackground(Color.white);
        vertShell.setLayout(new BoxLayout(vertShell, 1));
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        mainPanel.add(vertShell);
        this.VertPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(ScatterPlot_2DMatrix.this.LABEL_WIDTH, d.height);
            }
        };
        this.VertPanel.setBackground(Color.white);
        this.constructVerticalLabels();
        this.VertLabels = vl = new JViewport(){

            public Dimension getMinimumSize() {
                return new Dimension(ScatterPlot_2DMatrix.this.LABEL_WIDTH, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(ScatterPlot_2DMatrix.this.LABEL_WIDTH, 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(ScatterPlot_2DMatrix.this.LABEL_WIDTH, Integer.MAX_VALUE);
            }
        };
        this.VertLabels.setView(this.VertPanel);
        vertShell.add(this.VertLabels);
        vertShell.add(new JComponent(){

            public Dimension getMinimumSize() {
                return new Dimension(0, ScatterPlot_2DMatrix.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, ScatterPlot_2DMatrix.this.SCPane.getHScrollbarHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(0, ScatterPlot_2DMatrix.this.SCPane.getHScrollbarHeight());
            }
        });
        this.ScrollPanel = new JPanel();
        this.ScrollPanel.setBackground(Color.white);
        this.ScrollPanel.setLayout(new BoxLayout(this.ScrollPanel, 0));
        mainPanel.add(this.ScrollPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.SCPane = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        Adjustable hadj = this.SCPane.getHAdjustable();
        Adjustable vadj = this.SCPane.getVAdjustable();
        hadj.setBlockIncrement(50);
        hadj.setUnitIncrement(12);
        hadj.addAdjustmentListener(this);
        vadj.setBlockIncrement(50);
        vadj.setUnitIncrement(12);
        vadj.addAdjustmentListener(this);
        this.ScrollPanel.add(this.SCPane);
        this.DisplayPanel = new Panel();
        this.DisplayPanel.setBackground(Color.darkGray);
        this.SCPane.add(this.DisplayPanel);
        this.constructMatrix();
        JPanel settings = new JPanel();
        settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)settings, "East");
        this.widgets = new JPanel();
        settings.add((Component)this.widgets, "East");
        if (this.c_attr >= 0) {
            settings.add(this.displaypanel[0][0].getColorPanel());
            settings.setPreferredSize(new Dimension(125, settings.getHeight()));
        }
    }

    protected void refreshCells() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < ScatterPlot_2DMatrix.this.NumVisX; ++i) {
                    for (int j = 0; j < ScatterPlot_2DMatrix.this.NumVisY; ++j) {
                        ScatterPlot_2DMatrix.this.displaypanel[i][j].repaint();
                    }
                }
            }
        };
        thread.start();
    }

    private void synchLabelAndCellSizes() {
        for (int j = 0; j < this.NumVisY; ++j) {
            int h = this.VertLabel[j].getSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int w = this.HorizLabel[i].getSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(w, h));
                this.displaypanel[i][j].setDimension(null);
            }
        }
        this.HorizLabels.validate();
        this.VertLabels.validate();
        this.DisplayPanel.doLayout();
        this.SCPane.validate();
        this.refreshCells();
    }

    private void constructMatrix() {
        this.createScatterPlot2DMatrix();
        this.DisplayPanel.setLayout(new MatrixLayout(this.number_atts, 5, 5));
        for (int j = 0; j < this.NumVisY; ++j) {
            int ph = this.VertLabel[j].getPreferredSize().height;
            for (int i = 0; i < this.NumVisX; ++i) {
                int pw = this.HorizLabel[i].getPreferredSize().width;
                this.displaypanel[i][j].setPreferredSize(new Dimension(pw, ph));
                this.DisplayPanel.add(this.displaypanel[i][j]);
            }
        }
        this.selectCell(0, 0);
    }

    private void constructHorizontalLabels() {
        this.constructHorizontalLabels(null, null);
    }

    private void constructHorizontalLabels(String[] l, int[] widths) {
        int i;
        if (l == null) {
            l = new String[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                l[i] = this.attributes[i].getName();
            }
        }
        if (widths == null) {
            widths = new int[this.NumVisX];
            for (i = 0; i < this.NumVisX; ++i) {
                widths[i] = this.DEFAULT_VIS_WIDTH;
            }
        }
        this.HorizPanel.setLayout(new RectangularGridLayout(2 * this.NumVisX, 1, 0, 0));
        this.HorizLabel = new JPanel[this.NumVisX];
        this.HorizDrag = new JComponent[this.NumVisX];
        for (i = 0; i < this.NumVisX; ++i) {
            this.HorizLabel[i] = new JPanel();
            this.HorizLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.HorizLabel[i].setLayout(new BorderLayout());
            this.HorizLabel[i].setPreferredSize(new Dimension(widths[i], this.LABEL_HEIGHT));
            this.HorizLabel[i].add("Center", new JLabel(l[i], 0));
            this.HorizPanel.add(this.HorizLabel[i]);
            this.HorizDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(5, ScatterPlot_2DMatrix.this.LABEL_HEIGHT);
                }
            };
            this.HorizDrag[i].setPreferredSize(new Dimension(5, 0));
            this.HorizDrag[i].addMouseListener(this);
            this.HorizDrag[i].addMouseMotionListener(this);
            this.HorizPanel.add(this.HorizDrag[i]);
        }
    }

    private void constructVerticalLabels() {
        this.constructVerticalLabels(null, null);
    }

    private void constructVerticalLabels(String[] l, int[] heights) {
        int i;
        if (l == null) {
            l = new String[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                l[i] = this.attributes[i].getName();
            }
        }
        if (heights == null) {
            heights = new int[this.NumVisY];
            for (i = 0; i < this.NumVisY; ++i) {
                heights[i] = this.DEFAULT_VIS_HEIGHT;
            }
        }
        this.VertPanel.setLayout(new RectangularGridLayout(1, 2 * this.NumVisY, 0, 0));
        this.VertLabel = new JPanel[this.NumVisY];
        this.VertDrag = new JComponent[this.NumVisY];
        for (i = 0; i < this.NumVisY; ++i) {
            this.VertLabel[i] = new JPanel();
            this.VertLabel[i].setBorder(new LineBorder(Color.black, 1));
            this.VertLabel[i].setLayout(new BorderLayout());
            this.VertLabel[i].setPreferredSize(new Dimension(this.LABEL_WIDTH, heights[i]));
            this.VertLabel[i].add("Center", new JLabel(l[i], 0));
            this.VertPanel.add(this.VertLabel[i]);
            this.VertDrag[i] = new JComponent(){

                public void paint(Graphics g) {
                    Dimension d = this.getSize();
                    g.setColor(Color.black);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setColor(Color.yellow);
                    g.fillRect(1, 1, d.width - 2, d.height - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(ScatterPlot_2DMatrix.this.LABEL_WIDTH, 5);
                }
            };
            this.VertDrag[i].setBackground(Color.white);
            this.VertDrag[i].setPreferredSize(new Dimension(0, 5));
            this.VertDrag[i].addMouseListener(this);
            this.VertDrag[i].addMouseMotionListener(this);
            this.VertPanel.add(this.VertDrag[i]);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable a = e.getAdjustable();
        int value = a.getValue();
        if (a.getOrientation() == 0) {
            this.HorizLabels.setViewPosition(new Point(value, 0));
        } else {
            this.VertLabels.setViewPosition(new Point(0, value));
        }
    }

    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                if (c != this.displaypanel[i][j]) continue;
                this.selectCell(i, j);
                return;
            }
        }
        this.oldX = e.getX();
        this.oldY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        int j;
        int x = e.getX();
        int y = e.getY();
        Component c = e.getComponent();
        boolean change = false;
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            change = true;
            break;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            change = true;
            break;
        }
        if (change) {
            this.synchLabelAndCellSizes();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int j;
        Component c = e.getComponent();
        int x = e.getX();
        int y = e.getY();
        for (j = 0; j < this.NumVisX; ++j) {
            if (c != this.HorizDrag[j]) continue;
            Dimension s = this.HorizLabel[j].getSize();
            int oldW = s.width;
            s.width += x - this.oldX;
            if (s.width < 50) {
                s.width = 50;
            }
            this.HorizLabel[j].setSize(s);
            this.HorizLabel[j].setPreferredSize(s);
            this.HorizLabels.validate();
            return;
        }
        for (j = 0; j < this.NumVisY; ++j) {
            if (c != this.VertDrag[j]) continue;
            Dimension s = this.VertLabel[j].getSize();
            int oldH = s.height;
            s.height += y - this.oldY;
            if (s.height < 50) {
                s.height = 50;
            }
            this.VertLabel[j].setSize(s);
            this.VertLabel[j].setPreferredSize(s);
            this.VertLabels.validate();
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void selectCell(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.NumVisX) {
            x = this.NumVisX - 1;
        }
        if (y >= this.NumVisY) {
            y = this.NumVisY - 1;
        }
        for (int j = 0; j < this.NumVisY; ++j) {
            for (int i = 0; i < this.NumVisX; ++i) {
                boolean selected = x == i && y == j;
            }
        }
        this.CurX = x;
        this.CurY = y;
    }

    private void createScatterPlot2DMatrix() {
        this.displaypanel = new ScatterPlot2DPanel[this.number_atts][this.number_atts];
        for (int i = 0; i < this.number_atts; ++i) {
            for (int j = 0; j < this.number_atts; ++j) {
                this.displaypanel[i][j] = this.createScatterPlot2DPanel(i, j);
            }
        }
    }

    private ScatterPlot2DPanel createScatterPlot2DPanel(int horiz, int vert) {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        ScatterPlot2DPanel plotpanel = new ScatterPlot2DPanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.attributes[horiz], this.attributes[vert], this.samples[horiz], this.samples[vert], this.getParameterAsDouble("point_size"));
        plotpanel.setTitle("");
        plotpanel.setDrawTitle(false);
        plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        MovingListener movinglistener = new MovingListener(plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(plotpanel);
        plotpanel.addMouseListener(movinglistener);
        plotpanel.addMouseMotionListener(movinglistener);
        plotpanel.addMouseListener(zoominlistener);
        plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(this.source.getExampleSet().getLabel().getName())) {
                plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfLabel(this.colorattribute));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfLabel(this.colorattribute));
                plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.colorsamples.length; ++i) {
                    pvalues[i] = (float)this.samples[this.number_atts][i] * (float)valuesstr.length + this.colorsamples[i];
                }
                plotpanel.colorByAttribute(this.colorattribute, pvalues, colors);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.colorattribute.isNumerical()) {
                plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.colorattribute));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.colorattribute));
                plotpanel.initColorTable();
            } else {
                plotpanel.colorByAttribute(this.colorattribute, this.colorsamples);
                plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.colorattribute));
                plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.colorattribute));
                plotpanel.initColorTable();
            }
        }
        return plotpanel;
    }

    public List getParameterTypes() {
        LinkedList<ParameterTypeColor> types = new LinkedList<ParameterTypeColor>();
        ParameterTypeSingle type = new ParameterTypeColor("background", "The background-color.", Color.WHITE);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeColor("foreground", "The foreground-color.", Color.DARK_GRAY);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("plot_height", "The height of each 2D-Scatterplot.", 50, 1000, 300);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("plot_width", "The width of each 2D-Scatterplot.", 50, 1000, 300);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("label_height", "Hotizontal cell label's height.", 20, 100, 20);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeInt("label_width", "Vertical cell label's width.", 25, 100, 30);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add((ParameterTypeColor)type);
        type = new ParameterTypeDouble("point_size", "Size of the points.", 0.0, 100.0, 5.0);
        types.add((ParameterTypeColor)type);
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        if (this.source == null) {
            throw new CompilerException("The operator " + this.getName() + " must be child of a data-operator!");
        }
        if (this.source.getExampleSet() == null) {
            throw new CompilerException("The source is not compiled!");
        }
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        if (haslabel) {
            ++this.number_atts;
        }
        if (haspredlabel) {
            ++this.number_atts;
        }
        this.NumVisX = this.number_atts;
        this.NumVisY = this.number_atts;
        this.attributes = new Attribute[this.number_atts];
        for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
            this.attributes[i] = set.getAttribute(i);
        }
        if (haslabel) {
            this.attributes[set.getNumberOfAttributes()] = set.getLabel();
        }
        if (haspredlabel) {
            this.attributes[this.number_atts - 1] = set.getPredictedLabel();
        }
        this.samples = new double[this.number_atts][this.number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < set.getNumberOfAttributes(); ++d) {
                this.samples[d][sample] = example.getValue(d);
            }
            if (haslabel) {
                this.samples[set.getNumberOfAttributes()][sample] = example.getLabel();
            }
            if (!haspredlabel) continue;
            this.samples[this.number_atts - 1][sample] = example.getPredictedLabel();
        }
        this.c_attr = this.getParameterAsInt("color_attribute") - 1;
        if (this.c_attr >= 0) {
            this.colorattribute = this.attributes[this.c_attr];
            this.colorsamples = new float[this.number_of_samples];
            for (int i = 0; i < this.number_of_samples; ++i) {
                this.colorsamples[i] = (float)this.samples[this.c_attr][i];
            }
        }
        this.LABEL_HEIGHT = this.getParameterAsInt("label_height");
        this.LABEL_WIDTH = this.getParameterAsInt("label_width");
        this.DEFAULT_VIS_WIDTH = this.getParameterAsInt("plot_width");
        this.DEFAULT_VIS_HEIGHT = this.getParameterAsInt("plot_height");
        this.init();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

