/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.NeuroNet.exception.LearningException;
import edu.udo.cs.NeuroNet.exception.XMLException;
import edu.udo.cs.NeuroNet.learning.SOMLearning;
import edu.udo.cs.NeuroNet.nets.SOM;
import edu.udo.cs.NeuroNet.util.Neighbourhood;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.SOMPanel;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SOMVisualization
extends SimplePlot {
    private JPanel mainpane;
    private JPanel settings;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] minima;
    private float[] maxima;
    private float[] labelvalues;
    private float[] predvalues;
    private String[] classes;
    private String labelname;
    private int c_attr = 0;
    private JComboBox c_cbox;
    private JList attlist;
    private SOM som;

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)this.settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        this.settings.add((Component)settings2, "Center");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsBoolean("color_distance")) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            settings2.add(colorpanel);
        } else if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    Color[] colors = new Color[set.getLabel().getValues().size()];
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            if (set.getPredictedLabel() != null) {
                colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            }
            settings2.add(colorpanel);
        }
        this.mainpane.add((Component)this.plotpanel, "Center");
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new SOMPanel(this.som, this.samples);
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        ((SOMPanel)this.plotpanel).setShowNumberOfSamples(this.getParameterAsBoolean("show_number_samples"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        this.plotpanel.setStartColor(this.getParameterAsColor("start_color"));
        this.plotpanel.setEndColor(this.getParameterAsColor("end_color"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        Attribute label = set.getLabel();
        Attribute prediction = set.getPredictedLabel();
        if (this.getParameterAsBoolean("color_distance")) {
            ((SOMPanel)this.plotpanel).setColorDistance(true);
            this.plotpanel.initColorTable();
            if (this.getParameterAsBoolean("show_number_samples")) {
                ((SOMPanel)this.plotpanel).calculateSampleToCell();
            }
        } else {
            if (!color_attribute.equals("<None>")) {
                if (haslabel && color_attribute.equals(this.source.getExampleSet().getLabel().getName()) && label.isNominal()) {
                    Collection values = set.getLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getLabel().getNumberOfValues()];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    this.plotpanel.colorByAttribute(this.source.getExampleSet().getLabel(), this.labelvalues, colors);
                } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && prediction.isNominal()) {
                    Collection values = set.getPredictedLabel().getValues();
                    Object[] valuesstr = values.toArray();
                    Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    float[] pvalues = new float[this.number_of_samples];
                    for (int i = 0; i < this.predvalues.length; ++i) {
                        pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                    }
                    this.plotpanel.colorByAttribute(this.source.getExampleSet().getPredictedLabel(), pvalues, colors);
                    this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                    this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && prediction.isNumerical()) {
                    this.plotpanel.colorByAttribute(prediction, this.predvalues);
                    this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                    this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.source.getExampleSet().getPredictedLabel()));
                    this.plotpanel.initColorTable();
                } else {
                    float[] values = new float[this.samples.length];
                    for (int s = 0; s < values.length; ++s) {
                        values[s] = this.samples[s][this.c_attr];
                    }
                    this.plotpanel.colorByAttribute(this.source.getExampleSet().getAttribute(color_attribute), values);
                    this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                    this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                    this.plotpanel.initColorTable();
                }
            }
            ((SOMPanel)this.plotpanel).calculateSampleToCell();
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeFile("som_file", "The SOM is saved to this file.", "");
        types.add(type);
        type = new ParameterTypeInt("horizontal", "Number of horizontal KohonenNeurons.", 0, Integer.MAX_VALUE, 10);
        types.add(type);
        type = new ParameterTypeInt("vertical", "Number of vertical KohonenNeurons.", 0, Integer.MAX_VALUE, 10);
        types.add(type);
        type = new ParameterTypeBoolean("train_som", "Train the SOM.", true);
        types.add(type);
        type = new ParameterTypeBoolean("init_random", "Random init of the prototypes.", false);
        types.add(type);
        type = new ParameterTypeDouble("learning_rate", "The initial learning rate.", 0.0, Double.POSITIVE_INFINITY, 0.6);
        types.add(type);
        type = new ParameterTypeDouble("learning_rate_decay", "The learning rate decay exponent.", 0.0, Double.POSITIVE_INFINITY, 0.1);
        types.add(type);
        type = new ParameterTypeDouble("radius", "The initial neighbourhood radius.", 0.0, Double.POSITIVE_INFINITY, 2.5);
        types.add(type);
        type = new ParameterTypeDouble("radius_decay", "The initial neighbourhood radius.", 0.0, Double.POSITIVE_INFINITY, 0.1);
        types.add(type);
        type = new ParameterTypeStringCategory("neighbourhood", "The naighbourhood types.", Neighbourhood.NEIGHBOURHOODS, Neighbourhood.NEIGHBOURHOODS[0]);
        types.add(type);
        type = new ParameterTypeInt("iterations", "Number of iterations to train the som.", 0, Integer.MAX_VALUE, 100);
        types.add(type);
        type = new ParameterTypeBoolean("show_number_samples", "In each cell the number of samples belonging to this cell is displayed.", false);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "The histogram is colored with this attribute.", new String[]{"<None>"}, 0);
        types.add(type);
        type = new ParameterTypeBoolean("color_distance", "Color the cells by the distance to the cells around'.", false);
        types.add(type);
        type = new ParameterTypeColor("start_color", "The start color for the color-table.", Color.BLUE);
        types.add(type);
        type = new ParameterTypeColor("end_color", "The end color for the color-table.", Color.RED);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        if (!this.source.isCompiled()) {
            return;
        }
        this.iscompiling = true;
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        this.c_attr = Math.max(0, this.getParameterAsInt("color_attribute") - 1);
        for (int att = 0; att < this.number_atts; ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        if (haslabel || haspredlabel) {
            this.initClassNames();
        }
        this.samples = new float[this.number_of_samples][this.number_atts];
        this.minima = new float[this.number_atts];
        this.maxima = new float[this.number_atts];
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < this.number_atts; ++d) {
                this.samples[sample][d] = (float)example.getValue(d);
                if (sample == 0) {
                    this.minima[d] = this.samples[sample][d];
                    this.maxima[d] = this.samples[sample][d];
                    continue;
                }
                this.minima[d] = Math.min(this.minima[d], this.samples[sample][d]);
                this.maxima[d] = Math.max(this.maxima[d], this.samples[sample][d]);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (!haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
        }
        File somfile = new File(this.getParameterAsString("som_file"));
        if (this.som == null || !somfile.exists()) {
            if (somfile.exists()) {
                if (this.som == null) {
                    this.readSOM(somfile);
                }
            } else {
                this.createSOM();
                try {
                    this.writeSOM(somfile);
                }
                catch (IOException e) {
                    throw new CompilerException(e.getMessage(), e);
                }
            }
        }
        if (this.getParameterAsBoolean("train_som")) {
            this.trainSOM();
            try {
                this.writeSOM(somfile);
            }
            catch (IOException e) {
                throw new CompilerException(e.getMessage(), e);
            }
        }
        Logger.logMessage("Initializing the display...", 3);
        this.initComponents();
        Logger.logMessage("Ready.", 3);
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void trainSOM() throws CompilerException {
        SOMLearning somlearner = new SOMLearning(this.som, this.samples, this.minima, this.maxima, this.getParameterAsBoolean("init_random"));
        somlearner.setLearningRate((float)this.getParameterAsDouble("learning_rate"));
        somlearner.setLearningRateDecayExponent((float)this.getParameterAsDouble("learning_rate_decay"));
        somlearner.setRadius((float)this.getParameterAsDouble("radius"));
        somlearner.setRadiusDecayExponent((float)this.getParameterAsDouble("radius_decay"));
        somlearner.setMaxIterations(this.getParameterAsInt("iterations"));
        somlearner.setDistanceType(Neighbourhood.getTypeByName((String)this.getParameterAsString("neighbourhood")));
        Logger.logMessage("Training the SOM...", 3);
        try {
            somlearner.learn();
        }
        catch (LearningException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CompilerException(e.getMessage(), e);
        }
        Logger.logMessage("Ready training the SOM.", 3);
    }

    private void readSOM(File somfile) throws CompilerException {
        Logger.logMessage("Reading the som_file: " + somfile.toString() + " ...", 3);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(somfile);
            Element element = document.getDocumentElement();
            Attr classAttr = element.getAttributeNode("class");
            if (classAttr == null) {
                throw new CompilerException("Attribute 'class' of <connection> tag is not defined! ");
            }
            String className = classAttr.getValue();
            try {
                Class<?> c = Class.forName(className);
                this.som = (SOM)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new CompilerException("Can't find class " + className, e);
            }
            catch (InstantiationException e) {
                throw new CompilerException("Can not instantiate the class for className: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new CompilerException("Illegal Access for the class: " + className, e);
            }
            catch (ClassCastException e) {
                throw new CompilerException("Can not cast from " + className + " to SOM!");
            }
            this.som.loadXMLDocument(element);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new CompilerException(e.toString(), e);
        }
        catch (SAXException e) {
            throw new CompilerException("Cannot parse document: " + e, e);
        }
        catch (XMLException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        this.setParameter("horizontal", (Object)Integer.toString(this.som.getNumberOfHorizontalNeurons()));
        this.setParameter("vertical", (Object)Integer.toString(this.som.getNumberOfVerticalNeurons()));
        this.setParameter("neighbourhood", (Object)Neighbourhood.getTypeName((short)this.som.getNeighbourhoodType()));
        if (this.som.getNumberOfInputNeurons() != this.number_atts) {
            throw new CompilerException("The number of InputNeuron: " + this.som.getNumberOfInputNeurons() + " isn't equal to the dimension of the ExampleSet: " + this.number_atts + "!");
        }
        Logger.logMessage("Ready.", 3);
    }

    private void writeSOM(File somfile) throws IOException {
        Logger.logMessage("Writing the som to: " + somfile.toString() + ".", 3);
        FileOutputStream out = new FileOutputStream(somfile);
        out.write(this.som.getXML("").getBytes());
        out.close();
        Logger.logMessage("Ready.", 3);
    }

    private void createSOM() throws CompilerException {
        Logger.logMessage("Creating new SOM", 3);
        try {
            this.som = new SOM(this.getParameterAsString("title"), this.number_atts, this.getParameterAsInt("horizontal"), this.getParameterAsInt("vertical"));
        }
        catch (Exception e) {
            throw new CompilerException(e.getMessage(), e);
        }
        Logger.logMessage("Ready.", 3);
    }

    private void initClassNames() {
        Attribute att = null;
        if (this.source.getExampleSet().getPredictedLabel() != null) {
            att = this.source.getExampleSet().getPredictedLabel();
        }
        if (this.source.getExampleSet().getLabel() != null) {
            att = this.source.getExampleSet().getLabel();
        }
        if (att == null) {
            return;
        }
        this.classes = new String[att.getNumberOfValues()];
        Collection col = att.getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    public void setParameter(String key, Object object) {
        super.setParameter(key, object);
        if (key.equals("title") && this.som != null) {
            this.som.setName((String)object);
        }
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
        }
        return categories;
    }
}

