/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.jvito.plot.ColorPanel;
import edu.udo.cs.jvito.plot.MovingListener;
import edu.udo.cs.jvito.plot.RadVizPanel;
import edu.udo.cs.jvito.plot.SimplePlot;
import edu.udo.cs.jvito.plot.ZoomingListener;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Utils;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RadViz
extends SimplePlot {
    private JPanel mainpane;
    private JPanel settings;
    private String[] attr_names = new String[0];
    private int number_atts = 0;
    private int number_of_samples = 0;
    private float[][] samples;
    private float[] labelvalues;
    private float[] predvalues;
    private String[] classes;
    private String labelname;
    private int c_attr = 0;
    private JList attlist;
    private static final String[] ATTRIBUTE_MODE = new String[]{"original", "random", "correlation_label", "correlation_prediction", "weights", "selection"};
    private Attribute[] attributes;
    private Attribute label;
    private Attribute prediction;
    private int[] attribute_index;
    private double[] weights;
    private boolean weights_read;

    public JPanel getPlotPanel() {
        if (!this.isCompiled()) {
            return null;
        }
        return this.mainpane;
    }

    private void initComponents() {
        this.initDisplay();
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(5, 5));
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout(5, 5));
        this.mainpane.add((Component)this.settings, "East");
        JPanel settings2 = new JPanel();
        settings2.setLayout(new GridLayout(2, 1, 5, 5));
        this.settings.add((Component)settings2, "Center");
        ExampleSet set = this.source.getExampleSet();
        if (this.getParameterAsInt("color_attribute") != 0) {
            JPanel colorpanel = this.plotpanel.getColorPanel();
            if (this.getParameterAsInt("color_attribute") > set.getNumberOfAttributes()) {
                Object[] valuesstr;
                Collection values;
                Color[] colors;
                if (set.getLabel() != null && set.getLabel().isNominal() && this.getParameterAsInt("color_attribute") == set.getNumberOfAttributes() + 1) {
                    colors = new Color[set.getLabel().getValues().size()];
                    values = set.getLabel().getValues();
                    valuesstr = values.toArray();
                    for (int i = 0; i < valuesstr.length; ++i) {
                        colors[i] = this.source.getExampleColoring().getColorOfLabelValue(set.getLabel(), (String)valuesstr[i]);
                    }
                    colorpanel = new ColorPanel(set.getLabel(), colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                } else if (set.getPredictedLabel() != null && set.getPredictedLabel().isNominal()) {
                    values = set.getPredictedLabel().getValues();
                    valuesstr = values.toArray();
                    colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                    String[] valuestring = new String[valuesstr.length * valuesstr.length];
                    for (int i = 0; i < valuesstr.length; ++i) {
                        for (int j = 0; j < valuesstr.length; ++j) {
                            valuestring[i * valuesstr.length + j] = new String((String)valuesstr[i] + " - " + (String)valuesstr[j]);
                            colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                        }
                    }
                    colorpanel = new ColorPanel(set.getPredictedLabel(), valuestring, colors, this.getParameterAsColor("foreground"), this.getParameterAsColor("background"));
                }
            }
            if (set.getPredictedLabel() != null) {
                colorpanel.setPreferredSize(new Dimension(125, colorpanel.getHeight()));
            }
            settings2.add(colorpanel);
        }
        if (this.getParameterAsBoolean("label_axis")) {
            int s = this.attr_names.length;
            String[] atts = new String[s];
            for (int i = 0; i < this.attr_names.length; ++i) {
                atts[i] = new String(Integer.toString(i + 1) + " " + this.attr_names[this.attribute_index[i]]);
            }
            this.attlist = new JList<String>(atts);
            JScrollPane attscpane = new JScrollPane(this.attlist);
            settings2.add(attscpane);
        }
        this.mainpane.add((Component)this.plotpanel, "Center");
    }

    private void initDisplay() {
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = this.source.getExampleSet().getLabel() != null;
        boolean haspredlabel = this.source.getExampleSet().getPredictedLabel() != null;
        this.plotpanel = new RadVizPanel(this.source.getExampleSet(), this.source.getExampleColoring(), this.getParameterAsBoolean("draw_axis"), this.samples, this.getParameterAsDouble("point_size"), this.getParameterAsBoolean("label_axis"), this.attribute_index, this.number_atts, this.getParameterAsDouble("scale"));
        this.plotpanel.setTitle(this.getParameterAsString("title"));
        this.plotpanel.setDrawTitle(this.getParameterAsBoolean("show title"));
        this.plotpanel.setForegroundColor(this.getParameterAsColor("foreground"));
        this.plotpanel.setBackgroundColor(this.getParameterAsColor("background"));
        MovingListener movinglistener = new MovingListener(this.plotpanel);
        ZoomingListener zoominlistener = new ZoomingListener(this.plotpanel);
        this.plotpanel.addMouseListener(movinglistener);
        this.plotpanel.addMouseMotionListener(movinglistener);
        this.plotpanel.addMouseListener(zoominlistener);
        this.plotpanel.addMouseMotionListener(zoominlistener);
        String color_attribute = ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).getValues()[this.getParameterAsInt("color_attribute")];
        if (!color_attribute.equals("<None>")) {
            if (haslabel && color_attribute.equals(this.source.getExampleSet().getLabel().getName())) {
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getLabel(), this.labelvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfLabel(this.source.getExampleSet().getLabel()));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfLabel(this.source.getExampleSet().getLabel()));
                this.plotpanel.initColorTable();
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.prediction.isNominal()) {
                Collection values = set.getPredictedLabel().getValues();
                Object[] valuesstr = values.toArray();
                Color[] colors = new Color[set.getPredictedLabel().getValues().size() * set.getPredictedLabel().getValues().size()];
                for (int i = 0; i < valuesstr.length; ++i) {
                    for (int j = 0; j < valuesstr.length; ++j) {
                        colors[i * valuesstr.length + j] = this.source.getExampleColoring().getColorOfLabelvsPred(set.getLabel(), set.getPredictedLabel(), (String)valuesstr[i], (String)valuesstr[j]);
                    }
                }
                float[] pvalues = new float[this.number_of_samples];
                for (int i = 0; i < this.predvalues.length; ++i) {
                    pvalues[i] = this.labelvalues[i] * (float)valuesstr.length + this.predvalues[i];
                }
                this.plotpanel.colorByAttribute(this.prediction, pvalues, colors);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.prediction));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.prediction));
            } else if (haspredlabel && color_attribute.equals(this.source.getExampleSet().getPredictedLabel().getName()) && this.prediction.isNumerical()) {
                this.plotpanel.colorByAttribute(this.prediction, this.predvalues);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfPredLabel(this.prediction));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfPredLabel(this.prediction));
                this.plotpanel.initColorTable();
            } else if (!color_attribute.equals("")) {
                this.plotpanel.colorByAttribute(this.source.getExampleSet().getAttribute(color_attribute), this.samples[this.getParameterAsInt("color_attribute") - 1]);
                this.plotpanel.setStartColor(this.source.getExampleColoring().getStartColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                this.plotpanel.setEndColor(this.source.getExampleColoring().getEndColorOfAttribute(this.source.getExampleSet().getAttribute(color_attribute)));
                this.plotpanel.initColorTable();
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean("local_normalization", "The data have to be local normalized, otherwise global normalized.", false);
        types.add(type);
        type = new ParameterTypeDynamicCategory("color_attribute", "This attribute is the color-dimension.", this.getColorAttributes(), 0);
        types.add(type);
        type = new ParameterTypeDouble("point_size", "Size of the points.", 0.0, 100.0, 3.0);
        types.add(type);
        type = new ParameterTypeBoolean("draw_axis", "Draw the radial axis.", true);
        types.add(type);
        type = new ParameterTypeBoolean("label_axis", "Label the axis.", true);
        types.add(type);
        type = new ParameterTypeStringCategory("attribute_mode", "Select the mode to display the attributes.", ATTRIBUTE_MODE, ATTRIBUTE_MODE[0]);
        types.add(type);
        type = new ParameterTypeInt("number_attributes", "This number of the first correlated Attributes with the function values are displayed.", -1, Integer.MAX_VALUE, -1);
        types.add(type);
        type = new ParameterTypeFile("attribute_weights_file", "The file-location of the weights.", true);
        types.add(type);
        type = new ParameterTypeBoolean("apply_weights", "The attributes are weighted with the specified attribute_weights.", false);
        types.add(type);
        type = new ParameterTypeString("attributes", "These attributes are displayed(comma-separated attribute-names).", "");
        types.add(type);
        type = new ParameterTypeDouble("scale", "Scale-Factor for the data-points (scales the distance from the center)", 0.0, Double.MAX_VALUE, 1.0);
        types.add(type);
        return types;
    }

    public void compile() throws CompilerException {
        String mode;
        if (!this.source.isCompiled()) {
            return;
        }
        this.iscompiling = true;
        this.weights_read = false;
        ExampleSet set = this.source.getExampleSet();
        boolean haslabel = set.getLabel() != null;
        boolean haspredlabel = set.getPredictedLabel() != null;
        this.number_of_samples = set.getSize();
        this.number_atts = set.getNumberOfAttributes();
        this.attr_names = new String[this.number_atts];
        this.c_attr = Math.max(0, this.getParameterAsInt("color_attribute") - 1);
        for (int att = 0; att < this.number_atts; ++att) {
            this.attr_names[att] = set.getAttribute(att).getName();
        }
        if (haslabel || haspredlabel) {
            this.initClassNames();
        }
        this.attributes = new Attribute[set.getNumberOfAttributes()];
        this.label = set.getLabel();
        this.prediction = set.getPredictedLabel();
        for (int a = 0; a < set.getNumberOfAttributes(); ++a) {
            this.attributes[a] = set.getAttribute(a);
        }
        this.samples = new float[this.number_atts][this.number_of_samples];
        this.labelvalues = new float[this.number_of_samples];
        this.predvalues = new float[this.number_of_samples];
        ExampleReader reader = set.getExampleReader();
        for (int sample = 0; sample < this.number_of_samples; ++sample) {
            Example example = reader.next();
            for (int d = 0; d < this.number_atts; ++d) {
                this.samples[d][sample] = (float)example.getValue(d);
            }
            if (haslabel) {
                this.labelvalues[sample] = (float)example.getLabel();
            }
            if (!haspredlabel) continue;
            this.predvalues[sample] = (float)example.getPredictedLabel();
        }
        this.attribute_index = new int[this.number_atts];
        for (int i = 0; i < this.attribute_index.length; ++i) {
            this.attribute_index[i] = i;
        }
        int number_attribute = this.getParameterAsInt("number_attributes");
        if (number_attribute == 0) {
            number_attribute = -1;
        }
        if (number_attribute == -1) {
            number_attribute = this.number_atts;
        }
        if ((mode = this.getParameterAsString("attribute_mode")).equals(ATTRIBUTE_MODE[0])) {
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[1])) {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
                vector.add(new Integer(this.attribute_index[i]));
                this.attribute_index[i] = -1;
            }
            for (int i = 0; i < set.getNumberOfAttributes(); ++i) {
                int vindex = (int)Math.floor(Math.random() * (double)vector.size());
                this.attribute_index[i] = (Integer)vector.remove(vindex);
            }
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "\n";
            for (int i = 0; i < 100 && i < this.attribute_index.length; ++i) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[2])) {
            int i;
            if (!haslabel) {
                throw new CompilerException("The ExampleSet must have a numeric label.");
            }
            if (this.label.isNominal()) {
                throw new CompilerException("The ExampleSet must have a numeric label.");
            }
            double[] mean = new double[set.getNumberOfAttributes() + 1];
            double[] st_deviation = new double[set.getNumberOfAttributes() + 1];
            double[] covariance = new double[set.getNumberOfAttributes()];
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                mean[i] = this.attributes[i].getAverage();
            }
            mean[mean.length - 1] = this.label.getAverage();
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                st_deviation[i] = Math.sqrt(this.attributes[i].getVariance());
            }
            st_deviation[st_deviation.length - 1] = Math.sqrt(this.label.getVariance());
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                covariance[i] = 0.0;
                for (int j = 0; j < this.number_of_samples; ++j) {
                    int n = i;
                    covariance[n] = covariance[n] + ((double)this.samples[i][j] - mean[i]) * ((double)this.labelvalues[j] - mean[mean.length - 1]);
                }
                covariance[i] = covariance[i] / (double)(this.number_of_samples - 1);
            }
            double[] correlation = new double[set.getNumberOfAttributes()];
            for (int i2 = 0; i2 < correlation.length; ++i2) {
                correlation[i2] = st_deviation[i2] * st_deviation[st_deviation.length - 1];
                correlation[i2] = correlation[i2] == 0.0 ? covariance[i2] : covariance[i2] / correlation[i2];
            }
            this.orderWeights(correlation);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Correlation with label", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i3 = 0; i3 < 100 && i3 < correlation.length; ++i3) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i3]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(correlation[i3]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[3])) {
            int i;
            if (!haspredlabel) {
                throw new CompilerException("The ExampleSet must have a numeric predicted label.");
            }
            if (this.prediction.isNominal()) {
                throw new CompilerException("The ExampleSet must have a numeric predictedlabel.");
            }
            double[] mean = new double[set.getNumberOfAttributes() + 1];
            double[] st_deviation = new double[set.getNumberOfAttributes() + 1];
            double[] covariance = new double[set.getNumberOfAttributes()];
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                mean[i] = this.attributes[i].getAverage();
            }
            mean[mean.length - 1] = this.prediction.getAverage();
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                st_deviation[i] = Math.sqrt(this.attributes[i].getVariance());
            }
            st_deviation[st_deviation.length - 1] = Math.sqrt(this.prediction.getVariance());
            for (i = 0; i < set.getNumberOfAttributes(); ++i) {
                covariance[i] = 0.0;
                for (int j = 0; j < this.number_of_samples; ++j) {
                    int n = i;
                    covariance[n] = covariance[n] + ((double)this.samples[i][j] - mean[i]) * ((double)this.predvalues[j] - mean[mean.length - 1]);
                }
                covariance[i] = covariance[i] / (double)(this.number_of_samples - 1);
            }
            double[] correlation = new double[set.getNumberOfAttributes()];
            for (int i4 = 0; i4 < correlation.length; ++i4) {
                correlation[i4] = st_deviation[i4] * st_deviation[st_deviation.length - 1];
                correlation[i4] = correlation[i4] == 0.0 ? covariance[i4] : covariance[i4] / correlation[i4];
            }
            this.orderWeights(correlation);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Correlation prediction", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i5 = 0; i5 < 100 && i5 < correlation.length; ++i5) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i5]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(correlation[i5]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[4])) {
            if (!this.weights_read) {
                this.readAttributeWeights(set.getNumberOfAttributes());
            }
            this.orderWeights(this.weights);
            String props = new String("\n");
            props = props + Utils.getString("Attribute", 25, 0) + "| " + Utils.getString("Weight", 25, 0) + "\n";
            props = props + Utils.duplicateString("-", 25) + "+ " + Utils.duplicateString("-", 25) + "\n";
            for (int i = 0; i < 100 && i < this.weights.length; ++i) {
                props = props + Utils.getString(this.attributes[this.attribute_index[i]].getName(), 25, 0) + "| " + Utils.getString(Double.toString(this.weights[i]), 25, 1) + "\n";
            }
            Logger.logMessage(props, 3);
            this.number_atts = number_attribute;
        } else if (mode.equals(ATTRIBUTE_MODE[5])) {
            int i;
            StringTokenizer st = new StringTokenizer(this.getParameterAsString("attributes"), ",");
            int index = 0;
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                this.attribute_index[index] = 0;
                for (i = 0; i < this.attributes.length; ++i) {
                    if (!this.attributes[i].getName().equals(a)) continue;
                    this.attribute_index[index] = i;
                    ++index;
                }
            }
            this.number_atts = index;
            if (this.number_atts == 0) {
                throw new CompilerException("No attribute selected!");
            }
            for (i = index; i < this.attribute_index.length; ++i) {
                this.attribute_index[i] = 0;
            }
        }
        if (this.getParameterAsBoolean("apply_weights")) {
            if (!this.weights_read) {
                this.readAttributeWeights(set.getNumberOfAttributes());
            }
            this.applyWeights();
        }
        this.normalizeSamples(set);
        this.initComponents();
        this.iscompiling = false;
        this.iscompiled = true;
    }

    private void applyWeights() {
        for (int d = 0; d < this.number_atts; ++d) {
            for (int sample = 0; sample < this.number_of_samples; ++sample) {
                this.samples[d][sample] = this.samples[d][sample] * (float)this.weights[d];
            }
        }
    }

    private void readAttributeWeights(int nr_atts) throws CompilerException {
        String weightFileName = this.getParameterAsString("attribute_weights_file");
        File weightFile = new File(weightFileName);
        AttributeWeights result = null;
        try {
            result = AttributeWeights.load(weightFile);
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        this.weights = new double[nr_atts];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = result.getWeight(this.attributes[i].getName());
        }
        this.weights_read = true;
    }

    public void orderWeights(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[(links + rechts) / 2];
        pivot = Math.abs(pivot);
        while (true) {
            if (Math.abs(array[left]) > pivot) {
                ++left;
                continue;
            }
            while (Math.abs(array[right]) < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.attribute_index[left];
                this.attribute_index[left] = this.attribute_index[right];
                this.attribute_index[right] = (int)temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.orderWeights(array, links, right);
        }
        if (left < rechts) {
            this.orderWeights(array, left, rechts);
        }
    }

    public void orderWeights(double[] weights) {
        this.orderWeights(weights, 0, weights.length - 1);
    }

    private void normalizeSamples(ExampleSet set) {
        int s;
        int d;
        boolean normlocal = this.getParameterAsBoolean("local_normalization");
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        if (!normlocal) {
            for (d = 0; d < this.number_atts; ++d) {
                for (s = 0; s < this.number_of_samples; ++s) {
                    max = Math.max(max, this.samples[d][s]);
                    min = Math.min(min, this.samples[d][s]);
                }
            }
        }
        for (d = 0; d < this.number_atts; ++d) {
            Attribute a = set.getAttribute(d);
            if (normlocal) {
                max = Float.NEGATIVE_INFINITY;
                min = Float.POSITIVE_INFINITY;
                for (s = 0; s < this.number_of_samples; ++s) {
                    max = Math.max(max, this.samples[d][s]);
                    min = Math.min(min, this.samples[d][s]);
                }
            }
            for (int sample = 0; sample < this.number_of_samples; ++sample) {
                this.samples[d][sample] = (this.samples[d][sample] - min) / (max - min);
            }
        }
    }

    private void initClassNames() {
        Attribute att = null;
        if (this.source.getExampleSet().getPredictedLabel() != null) {
            att = this.source.getExampleSet().getPredictedLabel();
        }
        if (this.source.getExampleSet().getLabel() != null) {
            att = this.source.getExampleSet().getLabel();
        }
        if (att == null) {
            return;
        }
        this.classes = new String[att.getNumberOfValues()];
        Collection col = att.getValues();
        Iterator iter = col.iterator();
        int index = 0;
        while (iter.hasNext()) {
            this.classes[index] = (String)iter.next();
            ++index;
        }
    }

    public void parentIsCompiled() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public void refreshParameter() {
        ((ParameterTypeDynamicCategory)this.getParameterType("color_attribute")).setValues(this.getColorAttributes());
    }

    public String[] getColorAttributes() {
        if (this.source == null) {
            return new String[]{"<None>"};
        }
        if (!this.source.isCompiled()) {
            return new String[]{"<None>"};
        }
        ExampleSet set = this.source.getExampleSet();
        if (set == null) {
            return new String[]{"<None>"};
        }
        int count = 1;
        count += set.getNumberOfAttributes();
        if (set.getLabel() != null) {
            ++count;
        }
        if (set.getPredictedLabel() != null) {
            ++count;
        }
        String[] categories = new String[count];
        categories[0] = "<None>";
        for (int i = 1; i <= set.getNumberOfAttributes(); ++i) {
            categories[i] = set.getAttribute(i - 1).getName();
        }
        int index = set.getNumberOfAttributes() + 1;
        if (set.getLabel() != null) {
            categories[index] = set.getLabel().getName();
            ++index;
        }
        if (set.getPredictedLabel() != null) {
            categories[index] = set.getPredictedLabel().getName();
            ++index;
        }
        return categories;
    }
}

