/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;

public class ParallelCoordinatesPanel
extends PlotPanel
implements MouseListener {
    private float[][] samples;
    private float[] min_sample;
    private float[] max_sample;
    private ExampleSet set;
    private ExampleColoring coloring;
    private int width;
    private int height;
    private int[] coord_x;
    private boolean mousepressed = false;
    private boolean drawCoordinates;
    private int[] attribute_index;
    private int number_atts;

    public ParallelCoordinatesPanel(ExampleSet set, ExampleColoring coloring, float[][] samples, float[] min_sample, float[] max_sample, int[] attribute_index, int number_atts) {
        this.set = set;
        this.coloring = coloring;
        this.samples = samples;
        this.min_sample = min_sample;
        this.max_sample = max_sample;
        this.drawCoordinates = true;
        this.attribute_index = attribute_index;
        this.number_atts = number_atts;
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public ParallelCoordinatesPanel(ExampleSet set, ExampleColoring coloring, float[][] samples, float min, float max, int[] attribute_index, int number_atts) {
        this.set = set;
        this.coloring = coloring;
        this.samples = samples;
        this.min_sample = new float[samples.length];
        this.max_sample = new float[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            this.min_sample[i] = min;
            this.max_sample[i] = max;
        }
        this.drawCoordinates = true;
        this.attribute_index = attribute_index;
        this.number_atts = number_atts;
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public ParallelCoordinatesPanel(ExampleSet set, ExampleColoring coloring, float[][] samples, float min, float max) {
        int i;
        this.set = set;
        this.coloring = coloring;
        this.samples = samples;
        this.min_sample = new float[samples.length];
        this.max_sample = new float[samples.length];
        for (i = 0; i < samples.length; ++i) {
            this.min_sample[i] = min;
            this.max_sample[i] = max;
        }
        this.drawCoordinates = true;
        this.number_atts = samples.length;
        this.attribute_index = new int[this.number_atts];
        for (i = 0; i < this.number_atts; ++i) {
            this.attribute_index[i] = i;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void setDrawCoordinates(boolean draw) {
        this.drawCoordinates = draw;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        g.drawRect(this.getX(60), this.getY(60), this.width - 120, this.height - 120);
        this.coord_x = new int[this.number_atts];
        this.coord_x[0] = 60;
        this.coord_x[this.coord_x.length - 1] = this.width - 60;
        float f = (float)(this.width - 120) / (float)(this.coord_x.length - 1);
        for (int i = 1; i < this.coord_x.length - 1; ++i) {
            this.coord_x[i] = 60 + (int)(f * (float)i);
            if (!this.drawCoordinates) continue;
            g.drawLine(this.getX(this.coord_x[i]), this.getY(60), this.getX(this.coord_x[i]), this.getY(this.height - 60));
        }
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            this.drawLine(g, sample);
        }
        this.paintMouseInfo(null);
    }

    private void drawLine(Graphics g, int sample) {
        g.setColor(this.foreground);
        if (this.colorbyattribute) {
            int index;
            if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
            } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                } else {
                    index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            } else {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                }
                if (this.colorattr.isNumerical()) {
                    index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            }
        }
        int y1 = (int)((this.samples[this.attribute_index[0]][sample] - this.min_sample[this.attribute_index[0]]) / (this.max_sample[this.attribute_index[0]] - this.min_sample[this.attribute_index[0]]) * (float)(this.height - 120));
        y1 = this.height - 60 - y1;
        for (int i = 1; i < this.number_atts; ++i) {
            int y2 = (int)((this.samples[this.attribute_index[i]][sample] - this.min_sample[this.attribute_index[i]]) / (this.max_sample[this.attribute_index[i]] - this.min_sample[this.attribute_index[i]]) * (float)(this.height - 120));
            y2 = this.height - 60 - y2;
            g.drawLine(this.getX(this.coord_x[i - 1]), this.getY(y1), this.getX(this.coord_x[i]), this.getY(y2));
            y1 = y2;
        }
    }

    public void paintMouseInfo(MouseEvent event) {
        if (this.mousepressed && event != null) {
            int x = event.getX();
            int y = event.getY();
            Graphics g = this.getGraphics();
            int coordinate = this.getCoordinate(x);
            double value = this.getValue(y, coordinate);
            g.setColor(this.background);
            g.fillRect(0, 0, this.width, 30);
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            g.drawString("coordinate: " + coordinate, 5, 11);
            g.drawString("value: " + value, 5, 26);
        }
    }

    public int getCoordinate(int x) {
        if (x < 60) {
            return 1;
        }
        if (x > this.width - 60) {
            return this.coord_x.length;
        }
        int abstand = Math.abs(this.coord_x[0] - x);
        for (int i = 1; i < this.coord_x.length; ++i) {
            int abstand2 = Math.abs(this.coord_x[i] - x);
            if (abstand2 > abstand) {
                return i;
            }
            abstand = abstand2;
        }
        return this.coord_x.length;
    }

    public double getValue(int y, int coordinate) {
        if (y < 60) {
            return this.max_sample[this.attribute_index[coordinate - 1]];
        }
        if (y > this.height - 60) {
            return this.min_sample[this.attribute_index[coordinate - 1]];
        }
        y -= 60;
        y = this.height - 120 - y;
        double breite = this.max_sample[this.attribute_index[coordinate - 1]] - this.min_sample[this.attribute_index[coordinate - 1]];
        double value = (double)this.min_sample[this.attribute_index[coordinate - 1]] + breite / (double)(this.height - 120) * (double)y;
        return value;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() == 2) {
            this.mousepressed = true;
            this.paintMouseInfo(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mousepressed = false;
        this.repaint();
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            ParallelCoordinatesPanel.this.paintMouseInfo(event);
        }
    }
}

