/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.Graphics;

public class GridVizPanel
extends PlotPanel {
    private String attrname;
    private float[][] samples;
    private float[] attributvektorx;
    private float[] attributvektory;
    private float[] samplex;
    private float[] sampley;
    private int width;
    private int height;
    private int pixelgesamt;
    private int midx;
    private int midy;
    private int pointsize = 1;
    private int gridsize;
    private int griddelta;
    private boolean mousepressed = false;
    private boolean labelaxis;
    private String[] attrnames;
    private ExampleSet set;
    private ExampleColoring coloring;
    private int[] attribute_index;
    private int number_atts;
    private double scale;

    public GridVizPanel(ExampleSet set, ExampleColoring coloring, String[] attrnames, float[][] samples, double pointsize, boolean labelaxis, int[] attribute_index, int number_atts, double scale) {
        this.set = set;
        this.coloring = coloring;
        this.attrnames = attrnames;
        this.samples = samples;
        this.pointsize = (int)pointsize;
        this.attribute_index = attribute_index;
        this.number_atts = number_atts;
        this.scale = scale;
        this.initcolortable = false;
        this.labelaxis = labelaxis;
    }

    public void calculateSamplePoints() {
        this.samplex = new float[this.samples[0].length];
        this.sampley = new float[this.samples[0].length];
        float dim = this.number_atts;
        float[] w = new float[this.number_atts];
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            int d;
            this.samplex[sample] = 0.0f;
            this.sampley[sample] = 0.0f;
            float sumx = 0.0f;
            float summex = 0.0f;
            float summey = 0.0f;
            for (d = 0; d < this.number_atts; ++d) {
                sumx += this.samples[this.attribute_index[d]][sample];
            }
            for (d = 0; d < this.number_atts; ++d) {
                w[d] = this.samples[this.attribute_index[d]][sample] / sumx;
            }
            for (d = 0; d < this.number_atts; ++d) {
                int n = sample;
                this.samplex[n] = this.samplex[n] + w[d] * this.attributvektorx[d];
                int n2 = sample;
                this.sampley[n2] = this.sampley[n2] + w[d] * this.attributvektory[d];
            }
            this.samplex[sample] = (float)((double)this.samplex[sample] * this.scale);
            this.sampley[sample] = (float)((double)this.sampley[sample] * this.scale);
        }
    }

    private void calculateAttributeVectors() {
        int dim = this.number_atts;
        this.attributvektorx = new float[dim];
        this.attributvektory = new float[dim];
        this.gridsize = (int)Math.sqrt(dim);
        if (this.gridsize * this.gridsize < dim) {
            ++this.gridsize;
        }
        this.griddelta = this.pixelgesamt / this.gridsize;
        float x = 0.0f;
        float y = 0.0f;
        int gridx = 0;
        int gridy = this.pixelgesamt;
        for (int dimindex = 0; dimindex < this.number_atts; ++dimindex) {
            if (dimindex % this.gridsize == 0) {
                gridx = 0;
                gridy -= this.griddelta;
            }
            this.attributvektorx[dimindex] = gridx;
            this.attributvektory[dimindex] = gridy;
            gridx += this.griddelta;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.pixelgesamt = Math.min(this.width, this.height) - 120;
        this.calculateAttributeVectors();
        this.midx = 60;
        this.midy = 60 + this.gridsize * this.griddelta;
        int x = this.midx;
        int y = this.midy;
        g.setColor(this.foreground);
        Font font = new Font("Monospaced", 0, 15);
        g.setFont(font);
        for (int i = 0; i < this.number_atts; ++i) {
            x = this.midx;
            y = this.midy;
            x = (int)((float)x + this.attributvektorx[i]);
            y = (int)((float)y - this.attributvektory[i]);
            g.drawLine(this.getX(x), this.getY(y), this.getX(x + this.griddelta), this.getY(y));
            g.drawLine(this.getX(x), this.getY(y), this.getX(x), this.getY(y - this.griddelta));
            if (!this.labelaxis) continue;
            g.drawString(this.attrnames[this.attribute_index[i]], this.getX(x + 5), this.getY(y - 5));
        }
        this.calculateSamplePoints();
        for (int sample = 0; sample < this.samplex.length; ++sample) {
            this.drawPoint(g, sample);
        }
    }

    public void drawPoint(Graphics g, int sample) {
        int x = this.midx;
        int y = this.midy;
        x += (int)this.samplex[sample];
        y -= (int)this.sampley[sample];
        if (this.colorbyattribute) {
            if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
            } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                if (this.colorattr.isNominal()) {
                    g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                } else {
                    int index = (int)(((double)this.colorvalues[sample] - this.colorattr.getMinimum()) / (this.colorattr.getMaximum() - this.colorattr.getMinimum()) * 99.0);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            } else {
                if (this.colorattr.isNominal()) {
                    float max = this.colorattr.getNumberOfValues() - 1;
                    int index = (int)(this.colorvalues[sample] * max);
                    g.setColor(this.colortable[index]);
                }
                if (this.colorattr.isNumerical()) {
                    int index = (int)(this.colorvalues[sample] * 99.0f);
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > 99) {
                        index = 99;
                    }
                    g.setColor(this.colortable[index]);
                }
            }
        }
        g.fillRect(this.getX(x - this.pointsize / 2), this.getY(y - this.pointsize / 2), this.pointsize, this.pointsize);
    }
}

