/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.plot.PlotPanel;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Font;
import java.awt.Graphics;

public class CircularCoordinatesPanel
extends PlotPanel {
    private String attrname;
    private float[][] samples;
    private float[] attributvektorx;
    private float[] attributvektory;
    private float[] angles;
    private int width;
    private int height;
    private int pixelgesamt;
    private int radius = 1;
    private int midx;
    private int midy;
    private boolean mousepressed = false;
    private boolean labelaxis;
    private ExampleSet set;
    private ExampleColoring coloring;

    public CircularCoordinatesPanel(ExampleSet set, ExampleColoring coloring, float[][] samples, boolean labelaxis) {
        this.set = set;
        this.coloring = coloring;
        this.samples = samples;
        this.calculateAngles();
        this.calculateAttributeVectors();
        this.labelaxis = labelaxis;
    }

    public void calculateAttributeVectors() {
        this.attributvektorx = new float[this.samples.length];
        this.attributvektory = new float[this.samples.length];
        float radius = 1.0f;
        float x = 0.0f;
        float y = 0.0f;
        for (int dimindex = 0; dimindex < this.samples.length; ++dimindex) {
            int winkel = (int)this.angles[dimindex];
            float angle = this.angles[dimindex];
            if (winkel / 90 == 0) {
                x = this.sin(angle) * radius;
                y = this.sin(90.0f - angle) * radius;
            } else if (winkel / 90 == 1) {
                x = this.sin(90.0f - (angle -= 90.0f)) * radius;
                y = this.sin(angle) * radius;
                y = -y;
            } else if (winkel / 90 == 2) {
                x = this.sin(angle -= 180.0f) * radius;
                y = this.sin(90.0f - angle) * radius;
                x = -x;
                y = -y;
            } else if (winkel / 90 == 3) {
                x = this.sin(90.0f - (angle -= 270.0f)) * radius;
                y = this.sin(angle) * radius;
                x = -x;
            }
            this.attributvektorx[dimindex] = x;
            this.attributvektory[dimindex] = y;
        }
    }

    public void calculateAngles() {
        float anglegesamt = 360.0f;
        float delta = anglegesamt / (float)this.samples.length;
        float angle = 0.0f;
        this.angles = new float[this.samples.length];
        for (int i = 0; i < this.samples.length; ++i) {
            this.angles[i] = angle;
            angle += delta;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.midx = this.width / 2;
        this.midy = this.height / 2;
        this.pixelgesamt = Math.min(this.width, this.height) - 120;
        this.radius = this.pixelgesamt / 2;
        g.drawOval(this.getX(this.midx - this.radius), this.getY(this.midy - this.radius), this.pixelgesamt, this.pixelgesamt);
        g.setColor(this.foreground);
        int x = this.midx;
        int y = this.midy;
        for (int i = 0; i < this.angles.length; ++i) {
            x = this.midx;
            y = this.midy;
            x = (int)((float)x + this.attributvektorx[i] * (float)this.radius);
            y = (int)((float)y - this.attributvektory[i] * (float)this.radius);
            g.drawLine(this.getX(this.midx), this.getY(this.midy), this.getX(x), this.getY(y));
        }
        if (this.labelaxis) {
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            for (int i = 0; i < this.angles.length; ++i) {
                x = this.midx;
                y = this.midy;
                x = (int)((float)x + this.attributvektorx[i] * (float)this.radius);
                y = (int)((float)y - this.attributvektory[i] * (float)this.radius);
                if (this.angles[i] >= 0.0f && this.angles[i] <= 90.0f) {
                    x = (int)((float)x + this.attributvektorx[i] * 5.0f);
                    y = (int)((float)y - this.attributvektory[i] * 5.0f);
                } else if (this.angles[i] >= 90.0f && this.angles[i] < 180.0f) {
                    x = (int)((float)x + this.attributvektorx[i] * 10.0f);
                    y = (int)((float)y - this.attributvektory[i] * 10.0f);
                } else if (this.angles[i] >= 180.0f && this.angles[i] < 270.0f) {
                    x = (int)((float)x + this.attributvektorx[i] * 15.0f);
                    y = (int)((float)y - this.attributvektory[i] * 15.0f);
                } else if (this.angles[i] >= 270.0f && this.angles[i] < 360.0f) {
                    x = (int)((float)x + this.attributvektorx[i] * 10.0f);
                    y = (int)((float)y - this.attributvektory[i] * 10.0f);
                }
                g.drawString(Integer.toString(i + 1), this.getX(x), this.getY(y));
            }
        }
        g.setColor(this.foreground);
        float colormin = 0.0f;
        float colormax = 0.0f;
        if (this.colorbyattribute) {
            for (int c = 0; c < this.colorvalues.length; ++c) {
                if (c == 0) {
                    colormin = this.colorvalues[0];
                    colormax = this.colorvalues[0];
                    continue;
                }
                colormin = Math.min(colormin, this.colorvalues[c]);
                colormax = Math.max(colormax, this.colorvalues[c]);
            }
        }
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            if (this.colorbyattribute) {
                if (this.set.getLabel() != null && this.set.getLabel().getName().equals(this.colorattr.getName())) {
                    g.setColor(this.coloring.getColorOfLabelValue(this.colorattr, this.colorvalues[sample]));
                } else if (this.set.getPredictedLabel() != null && this.set.getPredictedLabel().getName().equals(this.colorattr.getName())) {
                    if (this.colorattr.isNominal()) {
                        g.setColor(this.colortable[(int)this.colorvalues[sample]]);
                    } else {
                        int index = (int)((this.colorvalues[sample] - colormin) / (colormax - colormin) * 99.0f);
                        if (index < 0) {
                            index = 0;
                        }
                        if (index > 99) {
                            index = 99;
                        }
                        g.setColor(this.colortable[index]);
                    }
                } else {
                    if (this.colorattr.isNominal()) {
                        float max = this.colorattr.getNumberOfValues() - 1;
                        int index = (int)(this.colorvalues[sample] * max);
                        g.setColor(this.colortable[index]);
                    }
                    if (this.colorattr.isNumerical()) {
                        int index = (int)((this.colorvalues[sample] - colormin) / (colormax - colormin) * 99.0f);
                        if (index < 0) {
                            index = 0;
                        }
                        if (index > 99) {
                            index = 99;
                        }
                        g.setColor(this.colortable[index]);
                    }
                }
            }
            this.drawLines(g, sample);
        }
    }

    public void drawLines(Graphics g, int sample) {
        float x1 = this.attributvektorx[0] * (float)this.radius * this.samples[0][sample];
        float y1 = this.attributvektory[0] * (float)this.radius * this.samples[0][sample];
        y1 = (float)this.midy - y1;
        float xstart = x1 += (float)this.midx;
        float ystart = y1;
        for (int d = 1; d < this.samples.length; ++d) {
            float x2 = this.attributvektorx[d] * (float)this.radius;
            float y2 = this.attributvektory[d] * (float)this.radius;
            x2 *= this.samples[d][sample];
            y2 *= this.samples[d][sample];
            y2 = (float)this.midy - y2;
            g.drawLine(this.getX((int)x1), this.getY((int)y1), this.getX((int)(x2 += (float)this.midx)), this.getY((int)y2));
            x1 = x2;
            y1 = y2;
        }
        g.drawLine(this.getX((int)x1), this.getY((int)y1), this.getX((int)xstart), this.getY((int)ystart));
    }

    public float sin(float angle) {
        while (angle >= 180.0f) {
            angle = (float)((double)angle - 180.0);
        }
        double value = (double)(angle / 180.0f) * Math.PI;
        return (float)Math.sin(value);
    }
}

