/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.plot;

import edu.udo.cs.jvito.plot.PlotPanel;
import java.awt.Font;
import java.awt.Graphics;

public class CircularArcCoordinatesPanel
extends PlotPanel {
    private String attrname;
    private float[][] samples;
    private float[] attributvektorx;
    private float[] attributvektory;
    private float[] angles;
    private int width;
    private int height;
    private int pixelgesamt;
    private int radius = 1;
    private int midx;
    private int midy;
    private boolean mousepressed = false;
    private boolean labelaxis;

    public CircularArcCoordinatesPanel(float[][] samples, String labelname, float[] labelvalues, boolean labelaxis) {
        this.samples = samples;
        this.calculateAngles();
        this.labelaxis = labelaxis;
    }

    public void calculateAttributeVectors() {
        this.attributvektorx = new float[this.samples.length];
        this.attributvektory = new float[this.samples.length];
        float x = 0.0f;
        float y = 0.0f;
        for (int dimindex = 0; dimindex < this.samples.length; ++dimindex) {
            int winkel = (int)this.angles[dimindex];
            float angle = this.angles[dimindex];
            if (winkel / 90 == 0) {
                x = this.sin(angle) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
            } else if (winkel / 90 == 1) {
                x = this.sin(90.0f - (angle -= 90.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                y = -y;
            } else if (winkel / 90 == 2) {
                x = this.sin(angle -= 180.0f) * (float)this.radius;
                y = this.sin(90.0f - angle) * (float)this.radius;
                x = -x;
                y = -y;
            } else if (winkel / 90 == 3) {
                x = this.sin(90.0f - (angle -= 270.0f)) * (float)this.radius;
                y = this.sin(angle) * (float)this.radius;
                x = -x;
            }
            this.attributvektorx[dimindex] = x;
            this.attributvektory[dimindex] = y;
        }
    }

    public void calculateAngles() {
        float anglegesamt = 360.0f;
        float delta = anglegesamt / (float)this.samples.length;
        float angle = 0.0f;
        this.angles = new float[this.samples.length];
        for (int i = 0; i < this.samples.length; ++i) {
            this.angles[i] = angle;
            angle += delta;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.dimension.width;
        this.height = this.dimension.height;
        g.setColor(this.foreground);
        this.midx = this.width / 2;
        this.midy = this.height / 2;
        this.pixelgesamt = Math.min(this.width, this.height) - 120;
        this.radius = this.pixelgesamt / 2;
        g.drawOval(this.getX(this.midx - this.radius), this.getY(this.midy - this.radius), this.pixelgesamt, this.pixelgesamt);
        this.calculateAttributeVectors();
        g.setColor(this.foreground);
        int x = this.midx;
        int y = this.midy;
        for (int i = 0; i < this.angles.length; ++i) {
            x = this.midx;
            y = this.midy;
            x = (int)((float)x + this.attributvektorx[i]);
            y = (int)((float)y - this.attributvektory[i]);
            g.drawLine(this.getX(this.midx), this.getY(this.midy), this.getX(x), this.getY(y));
        }
        if (this.labelaxis) {
            g.setColor(this.foreground);
            Font font = new Font("Monospaced", 0, 15);
            g.setFont(font);
            for (int i = 0; i < this.angles.length; ++i) {
                x = this.midx;
                y = this.midy;
                x = (int)((float)x + this.attributvektorx[i]);
                y = (int)((float)y - this.attributvektory[i]);
                if (this.angles[i] >= 0.0f && this.angles[i] <= 90.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 5.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 5.0f);
                } else if (this.angles[i] >= 90.0f && this.angles[i] < 180.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 10.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 10.0f);
                } else if (this.angles[i] >= 180.0f && this.angles[i] < 270.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 15.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 15.0f);
                } else if (this.angles[i] >= 270.0f && this.angles[i] < 360.0f) {
                    x = (int)((float)x + this.attributvektorx[i] / (float)this.radius * 10.0f);
                    y = (int)((float)y - this.attributvektory[i] / (float)this.radius * 10.0f);
                }
                g.drawString(Integer.toString(i + 1), this.getX(x), this.getY(y));
            }
        }
        g.setColor(this.foreground);
        if (this.colorbyattribute) {
            this.initColorTable();
        }
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            this.drawSample(g, sample);
        }
    }

    public void drawSample(Graphics g, int sample) {
        float endangle;
        float startangle;
        float my;
        float mx;
        float line2y;
        float line2x;
        float rkreis;
        float rneu;
        float linelength;
        float liney;
        if (this.colorbyattribute) {
            if (this.colorattr.isNominal()) {
                g.setColor(this.colortable[(int)this.colorvalues[sample]]);
            }
            if (this.colorattr.isNumerical()) {
                int index = (int)(this.colorvalues[sample] * 99.0f);
                if (index < 0) {
                    index = 0;
                }
                if (index > 99) {
                    index = 99;
                }
                g.setColor(this.colortable[index]);
            }
        }
        float alpha = this.angles[1];
        float arcangle = this.angles[1];
        float x1 = this.attributvektorx[0] * this.samples[0][sample];
        float y1 = this.attributvektory[0] * this.samples[0][sample];
        float xstart = x1;
        float ystart = y1;
        float x2 = x1;
        float y2 = x1;
        for (int d = 1; d < this.samples.length; ++d) {
            x2 = this.attributvektorx[d] * this.samples[d][sample];
            y2 = this.attributvektory[d] * this.samples[d][sample];
            float linex = (x2 - x1) / 2.0f;
            liney = (y2 - y1) / 2.0f;
            linelength = (float)Math.sqrt(linex * linex + liney * liney);
            rneu = this.sin(alpha / 2.0f);
            if (rneu < 0.001f && rneu > -0.001f) {
                rneu = 1.0f;
            }
            rkreis = linelength / rneu;
            rneu = linelength * this.sin(90.0f - alpha / 2.0f) / rneu;
            line2x = 0.0f;
            if (linex >= 0.0f && liney >= 0.0f) {
                line2x = 1.0f;
            } else if (linex >= 0.0f && liney < 0.0f) {
                line2x = -1.0f;
            } else if (linex < 0.0f && liney < 0.0f) {
                line2x = -1.0f;
            } else if (linex < 0.0f && liney >= 0.0f) {
                line2x = 1.0f;
            }
            line2y = -1.0f * (linex * line2x / liney);
            linelength = (float)Math.sqrt(line2x * line2x + line2y * line2y);
            line2x = line2x / linelength * rneu;
            line2y = line2y / linelength * rneu;
            mx = x1 + linex + line2x;
            my = y1 + liney + line2y;
            startangle = this.getAngle(mx, my, x1, y1, rkreis);
            endangle = this.getAngle(mx, my, x2, y2, rkreis);
            endangle = this.transformAngle(endangle);
            startangle = this.transformAngle(startangle);
            mx -= rkreis;
            my += rkreis;
            mx = (float)this.midx + mx;
            my = (float)this.midy - my;
            g.drawArc(this.getX((int)mx), this.getY((int)my), (int)(2.0f * rkreis), (int)(2.0f * rkreis), (int)endangle, (int)arcangle);
            x1 = x2;
            y1 = y2;
        }
        x2 = xstart;
        y2 = ystart;
        float linex = (x2 - x1) / 2.0f;
        liney = (y2 - y1) / 2.0f;
        linelength = (float)Math.sqrt(linex * linex + liney * liney);
        rneu = this.sin(alpha / 2.0f);
        if (rneu < 0.001f && rneu > -0.001f) {
            rneu = 1.0f;
        }
        rkreis = linelength / rneu;
        rneu = linelength * this.sin(90.0f - alpha / 2.0f) / rneu;
        line2x = 0.0f;
        if (linex >= 0.0f && liney >= 0.0f) {
            line2x = 1.0f;
        } else if (linex >= 0.0f && liney < 0.0f) {
            line2x = -1.0f;
        } else if (linex < 0.0f && liney < 0.0f) {
            line2x = -1.0f;
        } else if (linex < 0.0f && liney >= 0.0f) {
            line2x = 1.0f;
        }
        line2y = -1.0f * (linex * line2x / liney);
        linelength = (float)Math.sqrt(line2x * line2x + line2y * line2y);
        line2x = line2x / linelength * rneu;
        line2y = line2y / linelength * rneu;
        mx = x1 + linex + line2x;
        my = y1 + liney + line2y;
        startangle = this.getAngle(mx, my, x1, y1, rkreis);
        endangle = this.getAngle(mx, my, x2, y2, rkreis);
        endangle = this.transformAngle(endangle);
        startangle = this.transformAngle(startangle);
        mx -= rkreis;
        my += rkreis;
        mx = (float)this.midx + mx;
        my = (float)this.midy - my;
        g.drawArc(this.getX((int)mx), this.getY((int)my), (int)(2.0f * rkreis), (int)(2.0f * rkreis), (int)endangle, (int)arcangle);
    }

    public float getAngle(float mx, float my, float x, float y, float radius) {
        x = (x - mx) / radius;
        y = (y - my) / radius;
        float angle = 0.0f;
        if (!(x >= 0.0f) || !(y >= 0.0f)) {
            if (x >= 0.0f && y < 0.0f) {
                angle = 90.0f;
            } else if (x < 0.0f && y < 0.0f) {
                angle = 180.0f;
            } else if (x < 0.0f && y > 0.0f) {
                angle = 270.0f;
            }
        }
        float l = angle;
        float r = angle + 90.0f;
        float midangle = (r + l) / 2.0f;
        float value1 = this.sin(midangle);
        value1 = (value1 /= x) > 1.0f ? (value1 -= 1.0f) : 1.0f - value1;
        for (int iter = 0; value1 > 1.0E-7f && iter < 15; ++iter) {
            float angle1 = (midangle + l) / 2.0f;
            float angle2 = (r + midangle) / 2.0f;
            value1 = this.sin(angle1);
            float value2 = this.sin(angle2);
            value1 /= x;
            value2 /= x;
            value1 = value1 > 1.0f ? (value1 -= 1.0f) : 1.0f - value1;
            value2 = value2 > 1.0f ? (value2 -= 1.0f) : 1.0f - value2;
            if (value1 < value2) {
                r = midangle;
                midangle = angle1;
                continue;
            }
            l = midangle;
            midangle = angle2;
            value1 = value2;
        }
        return midangle;
    }

    public float transformAngle(float angle) {
        if (angle < 90.0f) {
            angle = 360.0f + angle;
        }
        float abstand180 = 180.0f - (angle -= 90.0f);
        angle = 180.0f + abstand180;
        return angle;
    }

    public float sin(float angle) {
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        double value = (double)(angle / 360.0f * 2.0f) * Math.PI;
        return (float)Math.sin(value);
    }

    public float cos(float angle) {
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        double value = (double)(angle / 360.0f * 2.0f) * Math.PI;
        return (float)Math.cos(value);
    }
}

