/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.parameter;

import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class JViToParameters
implements XMLDocument {
    private Map keyToValueMap = new HashMap();
    private Map keyToTypeMap = new HashMap();

    public JViToParameters(List parameterTypes) {
        Iterator i = parameterTypes.iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            this.keyToTypeMap.put(type.getKey(), type);
        }
    }

    public Object clone() {
        Object key;
        JViToParameters clone = new JViToParameters(new LinkedList());
        Iterator i = this.keyToValueMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            clone.keyToValueMap.put(key, this.keyToValueMap.get(key));
        }
        i = this.keyToTypeMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            clone.keyToTypeMap.put(key, this.keyToTypeMap.get(key));
        }
        return clone;
    }

    public ParameterType getParameterType(String key) {
        return (ParameterType)this.keyToTypeMap.get(key);
    }

    public void setParameter(String key, Object value) {
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            LogService.logMessage("Illegal key: '" + key + "'", 4);
            type = value instanceof List ? new ParameterTypeList(key, "guessed", new ParameterTypeString(null, null)) : new ParameterTypeString(key, "guessed");
            this.keyToTypeMap.put(key, type);
        }
        if (type instanceof ParameterTypeColor) {
            if (value instanceof String) {
                StringTokenizer st = new StringTokenizer((String)value, ",");
                int red = Integer.parseInt(st.nextToken());
                int green = Integer.parseInt(st.nextToken());
                int blue = Integer.parseInt(st.nextToken());
                red = this.adjustColor(red);
                green = this.adjustColor(green);
                blue = this.adjustColor(blue);
                Color c = new Color(red, green, blue);
                this.keyToValueMap.put(key, type.checkValue(c));
            } else if (value instanceof Color) {
                this.keyToValueMap.put(key, type.checkValue(value));
            } else {
                this.keyToValueMap.put(key, type.checkValue(value));
            }
        } else {
            this.keyToValueMap.put(key, type.checkValue(value));
        }
    }

    private int adjustColor(int colorvalue) {
        if (colorvalue < 0) {
            return 0;
        }
        if (colorvalue > 255) {
            return 255;
        }
        return colorvalue;
    }

    public void setParameterWithoutCheck(String key, Object value) {
        if (value == null) {
            this.keyToValueMap.remove(key);
        } else {
            this.keyToValueMap.put(key, value);
        }
    }

    public Object getParameter(String key) {
        if (this.keyToValueMap.containsKey(key)) {
            return this.keyToValueMap.get(key);
        }
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object value = type.getDefaultValue();
        if (value == null && !type.isOptional()) {
            LogService.logMessage("Parameter '" + key + "' is not set and has no default value.", 6);
        } else {
            this.keyToValueMap.put(key, value);
            LogService.logMessage("Parameter '" + key + "' is not set. Using default ('" + type.toString(value) + "').", 0);
        }
        return value;
    }

    public Set getKeys() {
        return this.keyToTypeMap.keySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof JViToParameters) {
            JViToParameters params = (JViToParameters)o;
            if (params.keyToValueMap.size() != this.keyToValueMap.size()) {
                return false;
            }
            Iterator i = this.keyToValueMap.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = params.keyToValueMap.get(key);
                if (value != null && value.equals(this.keyToValueMap.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        Iterator i = this.keyToValueMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.keyToValueMap.get(key);
            ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
            if (type != null) {
                result.append(type.getXML(indent, key, value));
                continue;
            }
            result.append(indent + "<parameter key=\"" + key + "\"\tvalue=\"" + value.toString() + "\"/>\n");
        }
        return result.toString();
    }

    public LinkedList getXMLDocChilds() {
        return new LinkedList();
    }

    public void loadXMLDocument(Element element) throws XMLException {
    }

    public void writeXML(PrintWriter out, String indent) {
    }
}

