/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui.attributeeditor;

import edu.udo.cs.jvito.data.FileSource;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.YaleLineReader;
import edu.udo.cs.yale.gui.EditorCellRenderer;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AttributeEditor
extends JTable
implements MouseListener {
    protected Action REMOVE_COLUMN_ACTION = new RemoveColumnAction();
    protected Action GUESS_TYPE_ACTION = new GuessTypeAction();
    private static final int COLUMN_WIDTH = 100;
    private static final int NAME_ROW = 0;
    private static final int TYPE_ROW = 1;
    private static final int UNIT_ROW = 2;
    private static final int VALUE_TYPE_ROW = 3;
    private static final int BLOCK_TYPE_ROW = 4;
    private static final int NUM_OF_HEADER_ROWS = 5;
    private ArrayList[] cellEditors;
    private ArrayList[] cellRenderers;
    private TableCellRenderer dataRenderer = new DataCellRenderer();
    private ArrayList sourceList;
    private LinkedList list;
    private boolean haveExampleSet;
    private File file;
    private Source source;
    private ExampleSet set;
    private AttributeTableModel model;
    private int rowCount;
    private Vector dataColumnVector;

    public AttributeEditor(Source source) {
        this.cellEditors = new ArrayList[5];
        this.cellRenderers = new ArrayList[5];
        for (int i = 0; i < 5; ++i) {
            this.cellEditors[i] = new ArrayList();
            this.cellRenderers[i] = new ArrayList();
        }
        this.sourceList = new ArrayList();
        this.rowCount = 0;
        this.dataColumnVector = new Vector();
        this.model = new AttributeTableModel();
        this.setModel(this.model);
        this.source = source;
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(this);
    }

    public AttributeEditor(ExampleSet set) {
        this.cellEditors = new ArrayList[5];
        this.cellRenderers = new ArrayList[5];
        for (int i = 0; i < 5; ++i) {
            this.cellEditors[i] = new ArrayList();
            this.cellRenderers[i] = new ArrayList();
        }
        this.sourceList = new ArrayList();
        this.rowCount = 0;
        this.dataColumnVector = new Vector();
        this.haveExampleSet = true;
        this.list = new LinkedList();
        this.model = new AttributeTableModel();
        this.setModel(this.model);
        this.set = set;
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(this);
    }

    private AttributeDataSource getDataSource(int i) {
        return (AttributeDataSource)this.sourceList.get(i);
    }

    private String getDatum(int row, int column) {
        Vector col = (Vector)this.dataColumnVector.get(column);
        if (row >= col.size()) {
            return "?";
        }
        return (String)col.get(row);
    }

    private void setDatum(int row, int column, String value) {
        Vector col = (Vector)this.dataColumnVector.get(column);
        if (row >= col.size()) {
            col.addElement(value);
            if (row >= this.rowCount) {
                this.rowCount = row + 1;
            }
        } else {
            col.setElementAt(value, row);
        }
    }

    private int getNumberOfDataRows() {
        String max = System.getProperty("yale.gui.attributeeditor.rowlimit");
        if (max != null) {
            int rowLimit = Integer.MAX_VALUE;
            try {
                rowLimit = Integer.parseInt(max);
                if (rowLimit == -1) {
                    return this.rowCount;
                }
                if (this.rowCount <= rowLimit) {
                    return this.rowCount;
                }
                return rowLimit;
            }
            catch (NumberFormatException e) {
                System.err.println("Value of yale.gui.attributeeditor.rowlimit must be an integer!");
                return this.rowCount;
            }
        }
        return this.rowCount;
    }

    private void createNewColumn() {
        this.cellEditors[0].add(new DefaultCellEditor(new JTextField()));
        JComboBox<String> typeBox = new JComboBox<String>(AttributeDataSource.KNOWN_TYPES);
        typeBox.setEditable(true);
        this.cellEditors[1].add(new DefaultCellEditor(typeBox));
        this.cellEditors[2].add(new DefaultCellEditor(new JTextField()));
        this.cellEditors[3].add(new DefaultCellEditor(new JComboBox<String>(Ontology.ATTRIBUTE_VALUE_TYPE.getNames())));
        this.cellEditors[4].add(new DefaultCellEditor(new JComboBox<String>(Ontology.ATTRIBUTE_BLOCK_TYPE.getNames())));
        for (int i = 0; i < this.cellRenderers.length; ++i) {
            this.cellRenderers[i].add(new EditorCellRenderer((TableCellEditor)this.cellEditors[i].get(this.cellEditors[i].size() - 1)));
        }
        this.dataColumnVector.add(new Vector());
    }

    private void addColumn(File file, int index) {
        String name = file.getName() + " (" + (index + 1) + ")";
        AttributeDataSource source = new AttributeDataSource(AttributeFactory.createAttribute(name, 0), file, index, "attribute");
        this.createNewColumn();
        this.sourceList.add(source);
    }

    protected void clear() {
        this.sourceList.clear();
        this.dataColumnVector.clear();
        this.rowCount = 0;
        this.model.fireTableStructureChanged();
    }

    public void readFile(File file) throws IOException {
        String[] columns;
        int columnOffset = this.sourceList.size();
        int numberOfNewColumns = 0;
        int currentRow = -1;
        BufferedReader in = new BufferedReader(new FileReader(file));
        YaleLineReader reader = new YaleLineReader(this.source.getParameterAsString("column_separators"), this.source.getParameterAsString("comment_chars").toCharArray(), this.source.getParameterAsBoolean("use_quotes"));
        ArrayList<Integer> valueTypes = new ArrayList<Integer>();
        int expectedNumberOfColumns = -1;
        while ((columns = reader.readLine(in, expectedNumberOfColumns)) != null) {
            expectedNumberOfColumns = columns.length;
            ++currentRow;
            for (int currentColumn = 0; currentColumn < columns.length; ++currentColumn) {
                int valueType = 3;
                String value = columns[currentColumn];
                if (!value.equals("?") && value.length() > 0) {
                    try {
                        double d = Double.parseDouble(value);
                        valueType = d == (double)((int)d) ? 3 : 4;
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                    }
                }
                if (currentColumn >= numberOfNewColumns) {
                    this.addColumn(file, currentColumn);
                    ++numberOfNewColumns;
                    valueTypes.add(new Integer(valueType));
                } else {
                    int soFar = (Integer)valueTypes.get(currentColumn);
                    if (soFar != valueType) {
                        if (soFar == 1 || valueType == 1) {
                            valueTypes.set(currentColumn, new Integer(1));
                        } else {
                            valueTypes.set(currentColumn, new Integer(4));
                        }
                    }
                }
                this.setDatum(currentRow, currentColumn + columnOffset, value);
            }
        }
        in.close();
        for (int i = 0; i < valueTypes.size(); ++i) {
            Attribute oldAttribute = this.getDataSource(i + columnOffset).getAttribute();
            this.getDataSource(i + columnOffset).setAttribute(AttributeFactory.changeValueType(oldAttribute, (Integer)valueTypes.get(i)));
        }
        this.model.fireTableStructureChanged();
    }

    private void autoSetValueType(int column) {
        int valueType = 3;
        AttributeDataSource source = this.getDataSource(column);
        for (int i = 0; i < this.getNumberOfDataRows(); ++i) {
            String value = this.getDatum(i, column);
            if (value == null || value.equals("?")) continue;
            try {
                double d = Double.parseDouble(value.toString());
                if (valueType != 3 || (double)((int)d) == d) continue;
                valueType = 4;
                continue;
            }
            catch (NumberFormatException e) {
                valueType = 1;
                break;
            }
        }
        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), valueType));
        this.model.fireTableCellUpdated(3, column);
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (row >= 5) {
            return super.getCellEditor(row, column);
        }
        return (TableCellEditor)this.cellEditors[row].get(column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= 5) {
            return this.dataRenderer;
        }
        return (TableCellRenderer)this.cellRenderers[row].get(column);
    }

    private boolean checkData(Object value, int row, int column) {
        return true;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.createPopupMenu(this.columnAtPoint(e.getPoint())).show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu(int column) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.GUESS_TYPE_ACTION);
        menu.add(this.REMOVE_COLUMN_ACTION);
        return menu;
    }

    public void removeColumn(int column) {
        this.sourceList.remove(column);
        this.dataColumnVector.removeElementAt(column);
        this.model.fireTableStructureChanged();
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator i = this.sourceList.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = (AttributeDataSource)i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(new Integer(j));
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            i = columns.iterator();
            j = 0;
            while (i.hasNext()) {
                names[j++] = ((AttributeDataSource)i.next()).getAttribute().getName();
            }
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, type + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                i = columns.iterator();
                Iterator k = columnNumbers.iterator();
                while (i.hasNext()) {
                    AttributeDataSource source = (AttributeDataSource)i.next();
                    Integer number = (Integer)k.next();
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.model.fireTableCellUpdated(1, number);
                }
            }
        }
    }

    public void writeXML(PrintWriter out) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        File defaultSource = this.getDataSource(0).getFile();
        out.println("<attributeset default_source=\"" + defaultSource.getAbsolutePath() + "\">");
        Iterator i = this.sourceList.iterator();
        while (i.hasNext()) {
            ((AttributeDataSource)i.next()).writeXML(out, defaultSource);
        }
        out.println("</attributeset>");
    }

    public void writeData(File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        for (int i = 0; i < this.sourceList.size(); ++i) {
            AttributeDataSource source = (AttributeDataSource)this.sourceList.get(i);
            source.setSource(file, i);
        }
        for (int row = 0; row < this.getNumberOfDataRows(); ++row) {
            for (int col = 0; col < this.sourceList.size(); ++col) {
                if (col != 0) {
                    out.print("\t");
                }
                out.print(this.getDatum(row, col));
            }
            out.println();
        }
        out.close();
    }

    public void openAttributeFile() {
        File file = SwingTools.chooseFile(this, null, true);
        if (file != null) {
            try {
                this.openAttributeFile(file);
            }
            catch (UserError userError) {
                // empty catch block
            }
        }
    }

    public void showExampleSet() {
        Collection coll;
        if (!this.haveExampleSet) {
            return;
        }
        this.list = new LinkedList();
        for (int i = 0; i < this.set.getNumberOfAttributes(); ++i) {
            this.list.add(this.set.getAttribute(i));
        }
        Attribute att = this.set.getLabel();
        if (att != null) {
            this.list.add(att);
        }
        if ((att = this.set.getPredictedLabel()) != null) {
            this.list.add(att);
        }
        if ((att = null) != null) {
            this.list.add(att);
        }
        if ((att = this.set.getWeight()) != null) {
            this.list.add(att);
        }
        if ((att = this.set.getCluster()) != null) {
            this.list.add(att);
        }
        if ((coll = this.set.getSpecialAttributeNames()) != null) {
            Iterator iter = coll.iterator();
        }
        for (int j = 0; j < this.list.size(); ++j) {
            this.createNewColumn();
        }
        ExampleReader e = this.set.getExampleReader();
        int row = 0;
        while (e.hasNext()) {
            Example example = e.next();
            Iterator attIterator = this.list.iterator();
            int n = 0;
            while (attIterator.hasNext()) {
                this.setDatum(row, n++, example.getValueAsString((Attribute)attIterator.next()));
            }
            ++row;
        }
        this.model.fireTableStructureChanged();
    }

    public void openAttributeFile(File file) throws UserError {
        AttributeDataSources attributeDataSources = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(file, true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not open '" + file + "':\n" + e, "Error", 0);
            return;
        }
        if (!(this.source instanceof FileSource)) {
            return;
        }
        this.file = file;
        this.clear();
        FileDataRowReader reader = null;
        try {
            reader = new FileDataRowReader(new DataRowFactory(0), attributeDataSources.getDataSources(), -1, this.source.getParameterAsString("column_separators"), this.source.getParameterAsString("comment_chars").toCharArray(), this.source.getParameterAsBoolean("use_quotes"));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Cannot open data file: " + e, "Error", 0);
            return;
        }
        this.sourceList.addAll(attributeDataSources.getDataSources());
        for (int j = 0; j < attributeDataSources.getDataSources().size(); ++j) {
            this.createNewColumn();
        }
        MemoryExampleTable table = new MemoryExampleTable(new AttributeSet(attributeDataSources).getAllAttributes(), reader);
        ExampleReader e = table.createCompleteExampleSet(null, null, null, null).getExampleReader();
        int row = 0;
        while (e.hasNext()) {
            Example example = e.next();
            Iterator adsIterator = this.sourceList.iterator();
            int n = 0;
            while (adsIterator.hasNext()) {
                AttributeDataSource ads = (AttributeDataSource)adsIterator.next();
                this.setDatum(row, n++, example.getValueAsString(ads.getAttribute()));
            }
            ++row;
        }
        this.model.fireTableStructureChanged();
    }

    public void saveAttributeFile() {
        for (int i = 1; i < AttributeDataSource.KNOWN_TYPES.length; ++i) {
            this.ensureAttributeTypeIsUnique(AttributeDataSource.KNOWN_TYPES[i]);
        }
        File file = SwingTools.chooseFile(this, null, false);
        if (file != null) {
            this.file = file;
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.writeXML(out);
                out.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private AttributeTableModel() {
        }

        public int getColumnCount() {
            if (AttributeEditor.this.haveExampleSet) {
                return AttributeEditor.this.list.size();
            }
            return AttributeEditor.this.sourceList.size();
        }

        public int getRowCount() {
            if (AttributeEditor.this.haveExampleSet) {
                return AttributeEditor.this.set.getSize() + 5;
            }
            return AttributeEditor.this.getNumberOfDataRows() + 5;
        }

        public String getColumnName(int column) {
            if (AttributeEditor.this.haveExampleSet) {
                return "attribute(" + (column + 1) + ")";
            }
            AttributeDataSource source = AttributeEditor.this.getDataSource(column);
            return source.getFile().getName() + " (" + (source.getColumn() + 1) + ")";
        }

        public Object getValueAt(int row, int column) {
            if (AttributeEditor.this.haveExampleSet) {
                if (row < 5) {
                    Attribute att = (Attribute)AttributeEditor.this.list.get(column);
                    switch (row) {
                        case 1: {
                            if (AttributeEditor.this.set.getLabel() != null && AttributeEditor.this.set.getLabel().getName().equals(att.getName())) {
                                return "label";
                            }
                            if (AttributeEditor.this.set.getCluster() != null && ((Object)AttributeEditor.this.set.getCluster()).equals(att.getName())) {
                                return "cluster";
                            }
                            if (AttributeEditor.this.set.getWeight() != null && ((Object)AttributeEditor.this.set.getWeight()).equals(att.getName())) {
                                return "weight";
                            }
                            return "attribute";
                        }
                        case 0: {
                            return att.getName();
                        }
                        case 2: {
                            String unitString = att.unitToString();
                            if (unitString.length() == 0) {
                                return "[unit]";
                            }
                            return unitString;
                        }
                        case 3: {
                            return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(att.getValueType());
                        }
                        case 4: {
                            return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(att.getBlockType());
                        }
                    }
                    return "This cannot happen!";
                }
                return AttributeEditor.this.getDatum(row - 5, column);
            }
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 1: {
                        return source.getType();
                    }
                    case 0: {
                        return source.getAttribute().getName();
                    }
                    case 2: {
                        String unitString = source.getAttribute().unitToString();
                        if (unitString.length() == 0) {
                            return "[unit]";
                        }
                        return unitString;
                    }
                    case 3: {
                        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(source.getAttribute().getValueType());
                    }
                    case 4: {
                        return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(source.getAttribute().getBlockType());
                    }
                }
                return "This cannot happen!";
            }
            return AttributeEditor.this.getDatum(row - 5, column);
        }

        public void setValueAt(Object value, int row, int column) {
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 1: {
                        source.setType((String)value);
                        break;
                    }
                    case 0: {
                        source.getAttribute().setName((String)value);
                        break;
                    }
                    case 2: {
                        if (value.equals("[unit]")) break;
                        source.getAttribute().setUnits((String)value);
                        break;
                    }
                    case 3: {
                        Attribute oldAttribute = source.getAttribute();
                        source.setAttribute(AttributeFactory.changeValueType(oldAttribute, Ontology.ATTRIBUTE_VALUE_TYPE.mapName((String)value)));
                        break;
                    }
                    case 4: {
                        source.getAttribute().setBlockType(Ontology.ATTRIBUTE_BLOCK_TYPE.mapName((String)value));
                    }
                }
            } else {
                AttributeEditor.this.setDatum(row - 5, column, (String)value);
            }
        }
    }

    private class GuessTypeAction
    extends AbstractAction {
        private int column = -1;

        private GuessTypeAction() {
            super("Guess value type");
            this.putValue("ShortDescription", "Guess the value type of the current column based on the data.");
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent e) {
            int column = AttributeEditor.this.getSelectedColumn();
            if (column != -1) {
                AttributeEditor.this.autoSetValueType(column);
            }
        }
    }

    private class RemoveColumnAction
    extends AbstractAction {
        private RemoveColumnAction() {
            super("Remove column");
            this.putValue("ShortDescription", "Remove the current column");
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            int column = AttributeEditor.this.getSelectedColumn();
            if (column != -1) {
                AttributeEditor.this.removeColumn(column);
            }
        }
    }

    private class DataCellRenderer
    extends DefaultTableCellRenderer {
        private DataCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!AttributeEditor.this.checkData(value, row, column)) {
                c.setBackground(Color.red);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }
}

