/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.AttributeRangeDialog;
import edu.udo.cs.yale.example.Attribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ValueColoringNumericalEditor
extends DefaultCellEditor
implements ActionListener,
TableCellRenderer {
    private Attribute attribute;
    private String text;
    private JButton button;
    private JLabel label;
    private JDialog parent;

    public ValueColoringNumericalEditor(JDialog parent, Attribute attribute, String text) {
        super(new JCheckBox());
        this.parent = parent;
        this.attribute = attribute;
        this.button = new JButton(text);
        this.editorComponent = this.button;
        this.setClickCountToStart(1);
        this.button.setBackground(Color.white);
        this.button.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.button.setFont(this.button.getFont().deriveFont(0));
        this.button.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        StringTokenizer st = new StringTokenizer(this.text, ",");
        double min = this.attribute.getMinimum();
        double max = this.attribute.getMaximum();
        try {
            min = Double.parseDouble(st.nextToken());
            max = Double.parseDouble(st.nextToken());
        }
        catch (NumberFormatException error) {
            error.printStackTrace();
            min = this.attribute.getMinimum();
            max = this.attribute.getMaximum();
        }
        AttributeRangeDialog dialog = new AttributeRangeDialog(this.parent, this.attribute, min, max);
        if (dialog.getExitAction() == 0) {
            this.text = dialog.getMinimum() + "," + dialog.getMaximum();
            this.button.setText(this.text);
        }
    }

    public Object getCellEditorValue() {
        return this.text;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.button.setText(value.toString());
        this.text = (String)value;
        return this.editorComponent;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

