/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.gui.Navigator;
import edu.udo.cs.jvito.gui.PlotTreeNode;
import edu.udo.cs.jvito.gui.ProjectTreeNode;
import edu.udo.cs.jvito.gui.SourceTreeNode;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class NavigatorRenderer
extends JPanel
implements TreeCellRenderer {
    private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
    private static final Color NON_SELECTED_COLOR = UIManager.getColor("Tree.textBackground");
    private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
    private static final Color BORDER_SELECTED_COLOR = UIManager.getColor("Tree.selectionBorderColor");
    private boolean hasFocus;
    private boolean isSelected;
    private JLabel mainLabel = new JLabel();
    private JLabel compiled = new JLabel();
    private JLabel error = new JLabel();
    private Navigator navi;

    public NavigatorRenderer(Navigator navi) {
        this.navi = navi;
        this.compiled.setVerticalAlignment(0);
        this.compiled.setHorizontalAlignment(0);
        this.mainLabel.setHorizontalAlignment(2);
        this.mainLabel.setFont(this.getFont().deriveFont(0));
        this.mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setLayout(new FlowLayout(0));
        this.setBackground(new Color(0, 0, 0, 0));
        this.add(this.compiled);
        this.add(this.mainLabel);
        this.add(this.error);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.isSelected = selected;
        this.hasFocus = hasFocus;
        if (selected) {
            this.mainLabel.setForeground(TEXT_SELECTED_COLOR);
        } else {
            this.mainLabel.setForeground(TEXT_NON_SELECTED_COLOR);
        }
        if (value instanceof ProjectTreeNode) {
            Project project = ((ProjectTreeNode)value).getProject();
            Object object = ((ProjectTreeNode)value).getUserObject();
            if (object instanceof String) {
                if (this.navi.isValidTreeNodeName((String)object)) {
                    project.setName((String)object);
                } else {
                    String name = this.navi.getValidTreeNodeName((String)object);
                    project.setName(name);
                    ((ProjectTreeNode)value).setUserObject(name);
                }
            }
            Image img = project.getImage();
            this.mainLabel.setIcon(new ImageIcon(img));
            this.mainLabel.setText("<html>" + project.getName() + "<br><font size=-2> Project" + "</font></html>");
            if (!project.isCompiled()) {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("NOTCOMPILED")));
            } else {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("COMPILED")));
            }
        } else if (value instanceof SourceTreeNode) {
            Source source = ((SourceTreeNode)value).getSource();
            Object object = ((SourceTreeNode)value).getUserObject();
            if (object instanceof String) {
                if (this.navi.isValidTreeNodeName((String)object)) {
                    source.setName((String)object);
                } else {
                    String name = this.navi.getValidTreeNodeName((String)object);
                    source.setName(name);
                    ((SourceTreeNode)value).setUserObject(name);
                }
                JViTo.getApplication().updateDataTableWindow(source);
            }
            Image img = source.getImage();
            this.mainLabel.setIcon(new ImageIcon(img));
            this.mainLabel.setText("<html>" + source.getName() + "<br><font size=-2>" + source.getClassName() + "</font></html>");
            if (!source.isCompiled()) {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("NOTCOMPILED")));
            } else {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("COMPILED")));
            }
        } else if (value instanceof PlotTreeNode) {
            Plot plot = ((PlotTreeNode)value).getPlot();
            Object object = ((PlotTreeNode)value).getUserObject();
            if (object instanceof String) {
                if (this.navi.isValidTreeNodeName((String)object)) {
                    plot.setName((String)object);
                } else {
                    String name = this.navi.getValidTreeNodeName((String)object);
                    plot.setName(name);
                    ((PlotTreeNode)value).setUserObject(name);
                }
                JViTo.getApplication().updatePlotWindow(plot);
            }
            Image img = plot.getImage();
            this.mainLabel.setIcon(new ImageIcon(img));
            this.mainLabel.setText("<html>" + plot.getName() + "<br><font size=-2>" + plot.getClassName() + "</font></html>");
            if (!plot.isCompiled()) {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("NOTCOMPILED")));
            } else {
                this.compiled.setIcon(new ImageIcon(Resources.getImage("COMPILED")));
            }
        } else {
            this.mainLabel.setIcon(null);
            this.mainLabel.setText(value.toString());
        }
        return this;
    }

    public void paint(Graphics g) {
        if (this.isSelected) {
            g.setColor(SELECTED_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus) {
            g.setColor(BORDER_SELECTED_COLOR);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }
}

