/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.DesktopWindowListener;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.gui.SearchDialog;
import edu.udo.cs.yale.gui.SwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class LogViewer
extends JInternalFrame
implements MouseListener {
    public final OutputStream outputStream = new MessageViewerOutputStream();
    public final Action CLEAR_MESSAGE_VIEWER_ACTION = new ClearMessageAction();
    public final Action SAVE_LOGFILE_ACTION = new SaveLogFileAction();
    public final Action FIND_ACTION = new FindAction();
    private JTextArea textArea;
    private JScrollPane scrollpane;
    private String searchPattern = null;
    private JButton clearButton;
    private JButton saveButton;
    private JButton findButton;
    private Application app;

    public LogViewer(Application app) {
        this(app, new JTextArea(8, 40));
        this.addInternalFrameListener(new DesktopWindowListener());
    }

    private LogViewer(Application app, JTextArea textArea) {
        super(Resources.getString("LOGVIEWER"));
        this.app = app;
        this.textArea = textArea;
        textArea.setEditable(false);
        textArea.addMouseListener(this);
        textArea.setFont(new Font("Courier", 0, 12));
        this.initComponents();
    }

    private void initComponents() {
        this.scrollpane = new JScrollPane(this.textArea);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollpane, "Center");
        JPanel panel = new JPanel();
        panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        BoxLayout boxlay = new BoxLayout(panel, 0);
        panel.setLayout(boxlay);
        this.clearButton = new JButton(this.CLEAR_MESSAGE_VIEWER_ACTION);
        this.saveButton = new JButton(this.SAVE_LOGFILE_ACTION);
        this.findButton = new JButton(this.FIND_ACTION);
        panel.add(this.clearButton);
        panel.add(this.saveButton);
        panel.add(this.findButton);
        JPanel southpanel = new JPanel();
        southpanel.setLayout(new BorderLayout());
        southpanel.add((Component)panel, "East");
        this.getContentPane().add((Component)southpanel, "South");
        this.setIconifiable(true);
        this.setMaximizable(true);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.createPopupMenu().show(this.textArea, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.CLEAR_MESSAGE_VIEWER_ACTION);
        menu.add(this.SAVE_LOGFILE_ACTION);
        menu.add(this.FIND_ACTION);
        return menu;
    }

    public String getLogMessage() {
        return this.textArea.getText();
    }

    public void refresh() {
        this.textArea.setText(Logger.getText());
        this.textArea.repaint();
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    private class MessageViewerOutputStream
    extends OutputStream {
        private StringBuffer currentString = new StringBuffer();

        private MessageViewerOutputStream() {
        }

        public void write(int b) {
            char c = (char)b;
            switch (b) {
                case 10: 
                case 13: {
                    if (this.currentString.length() <= 0) break;
                    LogViewer.this.textArea.append(this.currentString.toString() + "\n");
                    LogViewer.this.textArea.setCaretPosition(LogViewer.this.textArea.getDocument().getLength());
                    this.currentString = new StringBuffer();
                    break;
                }
                case 9: {
                    this.currentString.append("   ");
                    break;
                }
                default: {
                    try {
                        this.currentString.append(c);
                        break;
                    }
                    catch (IOException error) {
                        error.printStackTrace();
                    }
                }
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
            super("Find...");
            this.putValue("ShortDescription", "Find text in the logging output.");
            this.putValue("MnemonicKey", new Integer(70));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
        }

        public void actionPerformed(ActionEvent e) {
            new SearchDialog(LogViewer.this, LogViewer.this.textArea).setVisible(true);
        }
    }

    private class SaveLogFileAction
    extends AbstractAction {
        private SaveLogFileAction() {
            super("Save log file...");
            this.putValue("ShortDescription", "Save the logging output to a file");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File("./");
            String logFile = JViTo.getApplication().getProject().getParameterAsString("logfile");
            if (logFile != null) {
                file = JViTo.resolveFileName(logFile);
            } else {
                file = JViTo.getApplication().getProjectFile();
                if (file != null) {
                    file = file.getParentFile();
                }
            }
            file = null;
            file = SwingTools.chooseFile(LogViewer.this, file, false);
            if (file != null) {
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    out.println(LogViewer.this.textArea.getText());
                    out.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }

    private class ClearMessageAction
    extends AbstractAction {
        private ClearMessageAction() {
            super("Clear...");
            this.putValue("ShortDescription", "Clear the message viewer");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            LogViewer.this.textArea.setText("");
            Logger.clear();
        }
    }
}

