/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.gui.LogFileFilter;
import edu.udo.cs.jvito.gui.PreferenceTab;
import edu.udo.cs.jvito.util.Logger;
import edu.udo.cs.jvito.util.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogTab
extends PreferenceTab
implements ActionListener {
    private Component parent;
    private JComboBox box;
    private JTextField textfield;
    private JButton button;

    public LogTab(Component parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        JPanel center = new JPanel();
        JPanel centerwest = new JPanel();
        JPanel center2 = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        centerwest.setLayout(new GridLayout(2, 1, 5, 5));
        center2.setLayout(new GridLayout(2, 1, 5, 5));
        centerwest.add(new JLabel(Resources.getString("LOGVERBOSITY")));
        this.box = new JComboBox<String>(Logger.LOG_VERBOSITY_NAMES);
        this.box.setSelectedIndex(Logger.getVerbosityLevel());
        center2.add(this.box);
        centerwest.add(new JLabel(Resources.getString("LOGFILE")));
        JPanel filepanel = new JPanel();
        filepanel.setLayout(new BorderLayout());
        this.textfield = new JTextField();
        File file = Logger.getLogFile();
        String filestring = new String("");
        if (file != null) {
            filestring = file.toString();
        }
        this.textfield.setText(filestring);
        filepanel.add((Component)this.textfield, "Center");
        this.button = new JButton(Resources.getString("FILE_CHOOSE"));
        this.button.addActionListener(this);
        filepanel.add((Component)this.button, "East");
        center2.add(filepanel);
        center.add((Component)centerwest, "West");
        center.add((Component)center2, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)center, "North");
    }

    public void apply() {
        String filename = this.textfield.getText();
        if (filename != null && filename.equals("")) {
            Logger.setLogFile(null);
            JViTo.getApplication().logviewer.refresh();
            JViTo.getApplication().getPreferences().setString("logfile", "");
        } else {
            File file = new File(filename);
            if (!file.isDirectory() && file.getParentFile().isDirectory() && file.getParentFile().exists()) {
                Logger.setLogFile(file);
                JViTo.getApplication().logviewer.refresh();
                JViTo.getApplication().getPreferences().setString("logfile", file.toString());
            }
        }
        int level = this.box.getSelectedIndex();
        Logger.setVerbosityLevel(level);
        JViTo.getApplication().getPreferences().setInt("logverbosity", level);
    }

    public void cancel() {
    }

    public void ok() {
        this.apply();
    }

    public String toString() {
        return Resources.getString("LOGTAB");
    }

    public void actionPerformed(ActionEvent event) {
        File file;
        String wdir = this.textfield.getText();
        if (wdir == null) {
            wdir = "";
        }
        if (wdir.equals("")) {
            wdir = JViTo.getWorkingDir();
            file = new File(wdir);
        } else {
            file = new File(wdir);
            if (!(file = file.getParentFile()).isDirectory() || !file.exists()) {
                file = new File(JViTo.getWorkingDir());
            }
        }
        JFileChooser chooser = new JFileChooser(file);
        chooser.setFileFilter(new LogFileFilter());
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showOpenDialog(this.parent);
        if (ret == 0) {
            this.textfield.setText(chooser.getSelectedFile().toString());
        }
    }
}

