/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public class LabelColoringTableModel
extends AbstractTableModel {
    private ExampleSet exampleset;
    private ExampleColoring coloring;
    private int columns;
    private int rows;

    public LabelColoringTableModel(ExampleSet exampleset, ExampleColoring coloring) {
        this.exampleset = exampleset;
        this.coloring = coloring;
    }

    public int getColumnCount() {
        this.columns = 0;
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        if (label != null) {
            if (label.isNumerical()) {
                this.columns = 2;
            }
            if (label.isNominal()) {
                this.columns = label.getValues().size();
            }
        }
        if (pred != null) {
            if (pred.isNumerical()) {
                this.columns = Math.max(this.columns, 2);
            }
            if (pred.isNominal()) {
                this.columns = Math.max(this.columns, pred.getValues().size());
            }
        }
        ++this.columns;
        return this.columns;
    }

    public String getColumnName(int index) {
        if (index == 0) {
            return "Table for";
        }
        if (index == 1) {
            return "Label-";
        }
        if (index == 2) {
            return "Coloring";
        }
        return "";
    }

    public int getRowCount() {
        this.rows = 4;
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        if (label != null && pred != null && label.isNominal() && pred.isNominal()) {
            this.rows += 2;
            this.rows += label.getValues().size();
        }
        return this.rows;
    }

    public Object getValueAt(int row, int column) {
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        Collection values = null;
        if (label != null) {
            values = label.getValues();
        }
        if (row == 0) {
            if (column == 0) {
                return Resources.getString("EXAMPLECOLORING_LABEL");
            }
            if (column == 1) {
                if (label != null && label.isNumerical()) {
                    return Resources.getString("EXAMPLECOLORING_START_COLOR");
                }
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[0];
                }
                return "";
            }
            if (column == 2) {
                if (label != null && label.isNumerical()) {
                    return Resources.getString("EXAMPLECOLORING_END_COLOR");
                }
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[1];
                }
                return "";
            }
            if (column > 2) {
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[column - 1];
                }
                return "";
            }
        }
        if (row == 1) {
            if (column == 0) {
                if (label != null) {
                    return label.getName();
                }
                return "";
            }
            if (column == 1) {
                if (label != null && label.isNumerical()) {
                    return this.coloring.getStartColorOfLabel(label);
                }
                if (label != null && label.isNominal()) {
                    return this.coloring.getColorOfLabelValue(label, (String)values.toArray()[0]);
                }
                return "";
            }
            if (column == 2) {
                if (label != null && label.isNumerical()) {
                    return this.coloring.getEndColorOfLabel(label);
                }
                if (label != null && label.isNominal()) {
                    return this.coloring.getColorOfLabelValue(label, (String)values.toArray()[1]);
                }
                return "";
            }
            if (column > 2) {
                if (label != null && label.isNominal()) {
                    return this.coloring.getColorOfLabelValue(label, (String)values.toArray()[column - 1]);
                }
                return "";
            }
        }
        if (row == 2) {
            if (column == 0) {
                return Resources.getString("EXAMPLECOLORING_PREDICTION");
            }
            if (column == 1) {
                if (label != null && label.isNumerical()) {
                    return Resources.getString("EXAMPLECOLORING_START_COLOR");
                }
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[0];
                }
                return "";
            }
            if (column == 2) {
                if (label != null && label.isNumerical()) {
                    return Resources.getString("EXAMPLECOLORING_END_COLOR");
                }
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[1];
                }
                return "";
            }
            if (column > 2) {
                if (label != null && label.isNominal()) {
                    return (String)values.toArray()[column - 1];
                }
                return "";
            }
        }
        if (row == 3) {
            if (column == 0) {
                if (pred != null) {
                    return pred.getName();
                }
                return "";
            }
            if (column == 1) {
                if (pred != null && pred.isNumerical()) {
                    return this.coloring.getStartColorOfPredLabel(pred);
                }
                if (pred != null && pred.isNominal()) {
                    return this.coloring.getColorOfPredLabelValue(pred, (String)values.toArray()[0]);
                }
                return "";
            }
            if (column == 2) {
                if (pred != null && pred.isNumerical()) {
                    return this.coloring.getEndColorOfPredLabel(pred);
                }
                if (pred != null && pred.isNominal()) {
                    return this.coloring.getColorOfPredLabelValue(pred, (String)values.toArray()[1]);
                }
                return "";
            }
            if (column > 2) {
                if (pred != null && pred.isNominal()) {
                    return this.coloring.getColorOfPredLabelValue(pred, (String)values.toArray()[column - 1]);
                }
                return "";
            }
        }
        if (row == 4) {
            return "";
        }
        if (row == 5) {
            if (column == 0) {
                return Resources.getString("EXAMPLECOLORING_CONFUSIONMATRIX");
            }
            if (column > 0) {
                return (String)values.toArray()[column - 1];
            }
        }
        if (row > 5) {
            if (column == 0) {
                return (String)values.toArray()[row - 6];
            }
            if (column > 0) {
                return this.coloring.getColorOfLabelvsPred(label, pred, (String)values.toArray()[column - 1], (String)values.toArray()[row - 6]);
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        Collection values = null;
        if (label != null) {
            values = label.getValues();
        }
        if (column == 0) {
            return false;
        }
        if (row == 0) {
            return false;
        }
        if (row == 1) {
            if (label == null) {
                return false;
            }
            return column <= 2 || !label.isNumerical();
        }
        if (row == 2) {
            return false;
        }
        if (row == 3) {
            if (pred == null) {
                return false;
            }
            return column <= 2 || !pred.isNumerical();
        }
        if (row == 4) {
            return false;
        }
        if (row == 5) {
            return false;
        }
        return row > 5 && column > 0;
    }

    public void setValueAt(Object aValue, int row, int column) {
        Object oldvalue = this.getValueAt(row, column);
        if (!(oldvalue instanceof Color) || ((Color)oldvalue).equals((Color)aValue)) {
            return;
        }
        JViTo.getApplication().setDirty();
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        Collection values = null;
        if (label != null) {
            values = label.getValues();
        }
        if (row == 1) {
            if (column == 1) {
                if (label != null && label.isNumerical()) {
                    this.coloring.setStartColorOfLabel(label, (Color)aValue);
                }
                if (label != null && label.isNominal()) {
                    this.coloring.setColorOfLabelValue(label, (String)values.toArray()[0], (Color)aValue);
                }
            }
            if (column == 2) {
                if (label != null && label.isNumerical()) {
                    this.coloring.setEndColorOfLabel(label, (Color)aValue);
                }
                if (label != null && label.isNominal()) {
                    this.coloring.setColorOfLabelValue(label, (String)values.toArray()[1], (Color)aValue);
                }
            }
            if (column > 2 && label != null && label.isNominal()) {
                this.coloring.setColorOfLabelValue(label, (String)values.toArray()[column - 1], (Color)aValue);
            }
        }
        if (row == 3) {
            if (column == 1) {
                if (pred != null && pred.isNumerical()) {
                    this.coloring.setStartColorOfPredLabel(pred, (Color)aValue);
                }
                if (pred != null && pred.isNominal()) {
                    this.coloring.setColorOfPredLabelValue(pred, (String)values.toArray()[0], (Color)aValue);
                }
            }
            if (column == 2) {
                if (pred != null && pred.isNumerical()) {
                    this.coloring.setEndColorOfPredLabel(pred, (Color)aValue);
                }
                if (pred != null && pred.isNominal()) {
                    this.coloring.setColorOfPredLabelValue(pred, (String)values.toArray()[1], (Color)aValue);
                }
            }
            if (column > 2 && pred != null && pred.isNominal()) {
                this.coloring.setColorOfPredLabelValue(pred, (String)values.toArray()[column - 1], (Color)aValue);
            }
        }
        if (row > 5 && column > 0) {
            this.coloring.setColorOfLabelvsPred(label, pred, (String)values.toArray()[column - 1], (String)values.toArray()[row - 6], (Color)aValue);
        }
    }
}

