/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.gui.ColorEditor;
import edu.udo.cs.jvito.gui.ColorRenderer;
import edu.udo.cs.jvito.gui.LabelColoringTableModel;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class LabelColoringTable
extends JTable {
    private ExampleColoring coloring;
    private ExampleSet exampleset;
    private LabelColoringTableModel model;
    ColorRenderer colorrenderer;
    private DefaultTableCellRenderer defaultrenderer;

    public LabelColoringTable(ExampleSet exampleset, ExampleColoring coloring) {
        this.coloring = coloring;
        this.exampleset = exampleset;
        this.model = new LabelColoringTableModel(exampleset, coloring);
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + 8);
        this.initRenderer();
    }

    private void initRenderer() {
        this.defaultrenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setBackground(Color.LIGHT_GRAY);
                return comp;
            }
        };
        this.colorrenderer = new ColorRenderer(true);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        Collection values = null;
        if (label != null) {
            values = label.getValues();
        }
        if (column == 0) {
            return super.getCellEditor();
        }
        if (row == 0) {
            return super.getCellEditor();
        }
        if (row == 1) {
            if (label == null) {
                return super.getCellEditor();
            }
            if (column > 2 && label.isNumerical()) {
                return super.getCellEditor();
            }
            return new ColorEditor((Color)this.getValueAt(row, column));
        }
        if (row == 2) {
            return super.getCellEditor();
        }
        if (row == 3) {
            if (pred == null) {
                return super.getCellEditor();
            }
            if (column > 2 && pred.isNumerical()) {
                return super.getCellEditor();
            }
            return new ColorEditor((Color)this.getValueAt(row, column));
        }
        if (row == 4) {
            return super.getCellEditor();
        }
        if (row == 5) {
            return super.getCellEditor();
        }
        if (row > 5 && column > 0) {
            return new ColorEditor((Color)this.getValueAt(row, column));
        }
        return super.getCellEditor();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Attribute label = this.exampleset.getLabel();
        Attribute pred = this.exampleset.getPredictedLabel();
        Collection values = null;
        if (label != null) {
            values = label.getValues();
        }
        if (column == 0) {
            return this.defaultrenderer;
        }
        if (row == 0) {
            return this.defaultrenderer;
        }
        if (row == 1) {
            if (label == null) {
                return this.defaultrenderer;
            }
            if (column > 2 && label.isNumerical()) {
                return this.defaultrenderer;
            }
            return this.colorrenderer;
        }
        if (row == 2) {
            return this.defaultrenderer;
        }
        if (row == 3) {
            if (pred == null) {
                return this.defaultrenderer;
            }
            if (column > 2 && pred.isNumerical()) {
                return this.defaultrenderer;
            }
            return this.colorrenderer;
        }
        if (row == 4) {
            return this.defaultrenderer;
        }
        if (row == 5) {
            return this.defaultrenderer;
        }
        if (row > 5 && column > 0) {
            return this.colorrenderer;
        }
        return this.defaultrenderer;
    }
}

