/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.JViToMenu;
import edu.udo.cs.jvito.util.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class JViToToolBar
extends JToolBar {
    private Application app;
    private Vector buttons;

    public JViToToolBar(Application app) {
        this.app = app;
        this.buttons = new Vector();
        this.initComponents();
        this.enableClose();
    }

    public void setButtonEnabled(String key, boolean bool) {
        String name = Resources.getString(key);
        for (int i = 0; i < this.buttons.size(); ++i) {
            JButton comp = (JButton)this.buttons.get(i);
            if (!comp.getName().equals(name)) continue;
            comp.setEnabled(bool);
            return;
        }
    }

    public boolean isButtonEnabled(String key) {
        String name = Resources.getString(key);
        for (int i = 0; i < this.buttons.size(); ++i) {
            JButton comp = (JButton)this.buttons.get(i);
            if (!comp.getName().equals(name)) continue;
            return comp.isEnabled();
        }
        return false;
    }

    public void enableNew() {
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVE"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVEAS"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_CUT"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_PASTE"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_ADDSOURCE"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_ADDPLOT"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_COMPILESELECTED"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_COMPILEALL"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SHOWDATA"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SHOWPLOT"), true);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVEPLOT"), true);
    }

    public void enableClose() {
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVE"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVEAS"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_CUT"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_PASTE"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_ADDSOURCE"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_ADDPLOT"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_COMPILESELECTED"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_COMPILEALL"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SHOWDATA"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SHOWPLOT"), false);
        this.setButtonEnabled(Resources.getString("TOOLBAR_SAVEPLOT"), false);
    }

    private void initComponents() {
        this.setFloatable(false);
        ExecutableButton button = new ExecutableButton("TOOLBAR_NEW"){

            public void execute() {
                JViToToolBar.this.app.promptNew();
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_OPEN"){

            public void execute() {
                JViToToolBar.this.app.promptOpen();
                if (JViToToolBar.this.app.getProjectFile() != null) {
                    ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).getRecentFiles().setRecentFile(JViToToolBar.this.app.getProjectFile().toString());
                    ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).setRecentFilesMenu();
                }
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_SAVE"){

            public void execute() {
                JViToToolBar.this.app.promptSave();
                ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).getRecentFiles().setRecentFile(JViToToolBar.this.app.getProjectFile().toString());
                ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).setRecentFilesMenu();
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_SAVEAS"){

            public void execute() {
                JViToToolBar.this.app.promptSaveAs();
                ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).getRecentFiles().setRecentFile(JViToToolBar.this.app.getProjectFile().toString());
                ((JViToMenu)JViToToolBar.this.app.getJMenuBar()).setRecentFilesMenu();
            }
        };
        this.add(button);
        this.addSeparator();
        button = new ExecutableButton("TOOLBAR_CUT"){

            public void execute() {
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_PASTE"){

            public void execute() {
            }
        };
        this.add(button);
        this.addSeparator();
        button = new ExecutableButton("TOOLBAR_COMPILESELECTED"){

            public void execute() {
                JViToToolBar.this.app.promptCompile(0);
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_COMPILEALL"){

            public void execute() {
                JViToToolBar.this.app.promptCompile(1);
            }
        };
        this.add(button);
        this.addSeparator();
        button = new ExecutableButton("TOOLBAR_SHOWDATA"){

            public void execute() {
                JViToToolBar.this.app.promptShowData();
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_SHOWPLOT"){

            public void execute() {
                JViToToolBar.this.app.promptShowPlot();
            }
        };
        this.add(button);
        button = new ExecutableButton("TOOLBAR_SAVEPLOT"){

            public void execute() {
                JViToToolBar.this.app.promptSavePlot();
            }
        };
        this.add(button);
    }

    private static interface Executable {
        public void execute();
    }

    private class ExecutableButton
    extends JButton
    implements ActionListener,
    Executable {
        public ExecutableButton(String name) {
            this.setName(Resources.getString(name));
            this.addActionListener(this);
            this.setIcon(Resources.getImageIcon(name));
            this.setToolTipText(Resources.getToolTipText(name));
            JViToToolBar.this.buttons.add(this);
        }

        public void execute() {
        }

        public void actionPerformed(ActionEvent event) {
            this.execute();
        }
    }
}

