/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.parameter.ParameterTypeDynamicCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class InspectorValueEditor
extends DefaultCellEditor
implements TableCellEditor,
TableCellRenderer {
    private ParameterObject paramobject;

    public InspectorValueEditor(ParameterTypeBoolean type) {
        super(new JCheckBox());
        ((JCheckBox)this.editorComponent).setBackground(UIManager.getColor("Table.cellBackground"));
        ((JCheckBox)this.editorComponent).setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
    }

    public InspectorValueEditor(ParameterTypeInt type) {
        super(new JTextField());
        JTextField field = (JTextField)this.editorComponent;
        field.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        field.setHorizontalAlignment(2);
    }

    public InspectorValueEditor(final ParameterTypeDouble type) {
        super(new JTextField());
        JTextField field = (JTextField)this.editorComponent;
        field.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        field.setHorizontalAlignment(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    if (x instanceof Double || x instanceof String) {
                        ((JTextField)InspectorValueEditor.this.editorComponent).setText(x.toString());
                    } else {
                        throw new IllegalArgumentException("Illegal value class for double parameter: " + x.getClass().getName());
                    }
                }
            }

            public Object getCellEditorValue() {
                try {
                    double d = Double.parseDouble(((JTextField)InspectorValueEditor.this.editorComponent).getText());
                    if (d < type.getMinValue()) {
                        d = type.getMinValue();
                    }
                    if (d > type.getMaxValue()) {
                        d = type.getMaxValue();
                    }
                    return new Double(d);
                }
                catch (NumberFormatException e) {
                    return type.getDefaultValue();
                }
            }
        };
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public InspectorValueEditor(ParameterTypeString type) {
        super(new JTextField());
        JTextField field = (JTextField)this.editorComponent;
        field.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        field.setHorizontalAlignment(2);
    }

    public InspectorValueEditor(ParameterTypeCategory type) {
        super(new JComboBox<String>(type.getValues()));
        JComboBox box = (JComboBox)this.editorComponent;
        box.setBackground(UIManager.getColor("Table.cellBackground"));
        box.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                ((JComboBox)InspectorValueEditor.this.editorComponent).setSelectedIndex((Integer)x);
            }

            public Object getCellEditorValue() {
                return new Integer(((JComboBox)InspectorValueEditor.this.editorComponent).getSelectedIndex());
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public InspectorValueEditor(ParameterTypeDynamicCategory type) {
        super(new JComboBox<String>(type.getValues()));
        JComboBox box = (JComboBox)this.editorComponent;
        box.setSelectedIndex(0);
        box.setBackground(UIManager.getColor("Table.cellBackground"));
        box.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
    }

    public InspectorValueEditor(ParameterTypeStringCategory type) {
        super(new JComboBox<String>(type.getValues()));
        JComboBox box = (JComboBox)this.editorComponent;
        box.setEditable(true);
        box.setBackground(UIManager.getColor("Table.cellBackground"));
        box.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
    }

    public InspectorValueEditor(ParameterTypePassword type) {
        super(new JPasswordField(""));
        JPasswordField field = (JPasswordField)this.editorComponent;
        field.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        field.setHorizontalAlignment(2);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

