/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.awt.Color;
import javax.swing.table.AbstractTableModel;

public class InspectorModel
extends AbstractTableModel {
    private ParameterObject paramobject;

    public InspectorModel(ParameterObject paramobject) {
        this.paramobject = paramobject;
    }

    private void initValues() {
        for (int i = 0; i < this.paramobject.countParameterTypes(); ++i) {
            super.setValueAt(this.paramobject.getParameterType(i).getKey(), 0, i);
            super.setValueAt(this.paramobject.getParameter(i), 1, i);
        }
    }

    public void setParameterObject(ParameterObject paramobject) {
        this.paramobject = paramobject;
        this.fireTableDataChanged();
    }

    public String getColumnName(int colIndex) {
        if (colIndex == 0) {
            return Resources.getString("INSPECTOR_PARAMETER");
        }
        if (colIndex == 1) {
            return Resources.getString("INSPECTOR_VALUE");
        }
        return "";
    }

    public boolean isCellEditable(int rowIndex, int colIndex) {
        if (colIndex == 0) {
            return false;
        }
        return colIndex == 1;
    }

    public void setValueAt(Object value, int rowIndex, int colIndex) {
        if (colIndex == 1) {
            if (value instanceof Color) {
                this.paramobject.setParameter(rowIndex, value);
            } else if (value != null) {
                this.paramobject.setParameter(rowIndex, (Object)value.toString());
            }
            this.fireTableCellUpdated(rowIndex, colIndex);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.paramobject.countParameterTypes();
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        if (colIndex == 0) {
            ParameterType type = this.paramobject.getParameterType(rowIndex);
            if (type == null) {
                return new String("none");
            }
            return this.paramobject.getParameterType(rowIndex).getKey();
        }
        if (colIndex == 1) {
            return this.paramobject.getParameter(rowIndex);
        }
        return null;
    }
}

