/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.JViToPlotable;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InputDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private Application app;
    private LinkedList inputlist;
    private JButton addbutton;
    private JButton removebutton;
    private JButton closebutton;
    private JList jlist;
    private JPanel description;
    private JScrollPane scrollpane2;

    public InputDialog(Application app, LinkedList inputlist) {
        super(app, Resources.getString("DIALOG_INPUT_TITLE"), true);
        this.app = app;
        this.inputlist = inputlist;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(750, 650);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        Border emptyborder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        JLabel label = new JLabel(Resources.getString("DIALOG_INPUT_LABEL"));
        top_panel.add((Component)label, "North");
        this.jlist = new JList();
        this.jlist.setSelectionMode(2);
        this.jlist.setLayoutOrientation(0);
        this.jlist.setVisibleRowCount(-1);
        this.jlist.addListSelectionListener(this);
        this.jlist.setListData(this.getInputListData());
        JScrollPane scrollpane1 = new JScrollPane(this.jlist);
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BorderLayout());
        leftpanel.setBorder(emptyborder);
        leftpanel.add((Component)scrollpane1, "Center");
        this.description = new JPanel();
        this.scrollpane2 = new JScrollPane(this.description);
        JPanel rightpanel = new JPanel();
        rightpanel.setLayout(new BorderLayout());
        rightpanel.setBorder(emptyborder);
        rightpanel.add((Component)this.scrollpane2, "Center");
        JPanel mid_panel = new JPanel();
        mid_panel.setLayout(new BorderLayout());
        leftpanel.setPreferredSize(new Dimension(200, leftpanel.getHeight()));
        mid_panel.add((Component)leftpanel, "West");
        mid_panel.add((Component)rightpanel, "Center");
        top_panel.add((Component)mid_panel, "Center");
        this.addbutton = new JButton(Resources.getString("DIALOG_INPUT_ADD"));
        this.addbutton.setEnabled(false);
        this.addbutton.addActionListener(this);
        this.removebutton = new JButton(Resources.getString("DIALOG_INPUT_REMOVE"));
        this.removebutton.setEnabled(false);
        this.removebutton.addActionListener(this);
        this.closebutton = new JButton(Resources.getString("DIALOG_INPUT_CLOSE"));
        this.closebutton.setEnabled(true);
        this.closebutton.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.addbutton);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.removebutton);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.closebutton);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resources.getString("DIALOG_INPUT_ADD"))) {
            this.addSelectedInput();
        }
        if (cmd.equals(Resources.getString("DIALOG_INPUT_REMOVE"))) {
            this.removeSelectedInput();
        }
        if (cmd.equals(Resources.getString("DIALOG_INPUT_CLOSE"))) {
            this.dispose();
        }
    }

    private void addSelectedInput() {
        int[] indices = this.jlist.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            JViToPlotable plotable = (JViToPlotable)this.inputlist.get(index);
            this.inputlist.remove(index);
            this.app.addOperator(plotable);
        }
        this.jlist.setListData(this.getInputListData());
    }

    private void removeSelectedInput() {
        int[] indices = this.jlist.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            this.inputlist.remove(index);
        }
        this.jlist.setListData(this.getInputListData());
        this.description.add(new JPanel());
        this.scrollpane2.revalidate();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.jlist.isSelectionEmpty()) {
            this.addbutton.setEnabled(true);
            this.removebutton.setEnabled(true);
            this.description.add(this.getDescription());
        } else {
            this.addbutton.setEnabled(false);
            this.removebutton.setEnabled(false);
            this.description.add(new JPanel());
        }
        this.scrollpane2.revalidate();
    }

    private String[] getInputListData() {
        String[] items = new String[this.inputlist.size()];
        for (int i = 0; i < this.inputlist.size(); ++i) {
            JViToPlotable plotable = (JViToPlotable)this.inputlist.get(i);
            items[i] = plotable instanceof ExampleSet ? new String("ExampleSet " + (i + 1)) : (plotable instanceof JMySVMModel ? new String("JMySVMModel " + (i + 1)) : new String("JViToPlotable"));
        }
        return items;
    }

    private Component getDescription() {
        int index = this.jlist.getSelectedIndex();
        JViToPlotable plotable = (JViToPlotable)this.inputlist.get(index);
        if (plotable instanceof ExampleSet) {
            return ((ExampleSet)plotable).getVisualisationComponent();
        }
        if (plotable instanceof JMySVMModel) {
            return ((JMySVMModel)plotable).getVisualisationComponent();
        }
        return new JPanel();
    }
}

