/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.gui;

import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.gui.Application;
import edu.udo.cs.jvito.gui.AttributeColoringTable;
import edu.udo.cs.jvito.gui.LabelColoringTable;
import edu.udo.cs.jvito.gui.ValueColoringTable;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class ExampleColoringDialog
extends JDialog
implements ActionListener {
    private Application app;
    private ExampleColoring coloring;
    private ExampleSet exampleset;
    private JButton okbutton;
    private JButton closebutton;
    private JButton valueaddbutton;
    private JButton valuedeletebutton;
    private JTabbedPane tabbedpane;
    private JPanel attributetab;
    private JPanel labeltab;
    private JPanel valuetab;
    private JPanel idtab;
    private ValueColoringTable valuetable;

    public ExampleColoringDialog(Application app, ExampleSet exampleset, ExampleColoring coloring) {
        super(app, Resources.getString("EXAMPLECOLORING_DIALOG_TITLE"), true);
        this.app = app;
        this.coloring = coloring;
        this.exampleset = exampleset;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(700, 500);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        Border emptyborder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        this.getContentPane().add(toppanel);
        this.okbutton = new JButton(Resources.getString("EXAMPLECOLORING_OK"));
        this.okbutton.addActionListener(this);
        this.closebutton = new JButton(Resources.getString("EXAMPLECOLORING_CLOSE"));
        this.closebutton.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.okbutton);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.closebutton);
        toppanel.add((Component)bottom, "South");
        this.tabbedpane = new JTabbedPane();
        toppanel.add((Component)this.tabbedpane, "Center");
        this.attributetab = new JPanel();
        this.attributetab.setLayout(new BorderLayout());
        this.tabbedpane.addTab(Resources.getString("EXAMPLECOLORING_ATTRIBUTE_TAB"), this.attributetab);
        AttributeColoringTable atttable = new AttributeColoringTable(this.exampleset, this.coloring);
        JScrollPane scrollpane = new JScrollPane(atttable);
        this.attributetab.setBorder(emptyborder);
        this.attributetab.add((Component)scrollpane, "Center");
        if (this.exampleset.getLabel() != null || this.exampleset.getPredictedLabel() != null) {
            this.labeltab = new JPanel();
            this.labeltab.setLayout(new BorderLayout());
            this.tabbedpane.addTab(Resources.getString("EXAMPLECOLORING_LABEL_TAB"), this.labeltab);
            LabelColoringTable labeltable = new LabelColoringTable(this.exampleset, this.coloring);
            scrollpane = new JScrollPane(labeltable);
            this.labeltab.setBorder(emptyborder);
            this.labeltab.add((Component)scrollpane, "Center");
        }
        this.valuetab = new JPanel();
        this.valuetab.setLayout(new BorderLayout());
        this.tabbedpane.addTab(Resources.getString("EXAMPLECOLORING_VALUE_TAB"), this.valuetab);
        this.valuetable = new ValueColoringTable(this, this.exampleset, this.coloring);
        scrollpane = new JScrollPane(this.valuetable);
        this.valuetab.setBorder(emptyborder);
        this.valuetab.add((Component)scrollpane, "Center");
        this.valueaddbutton = new JButton(Resources.getString("EXAMPLECOLORING_VALUE_INSERT"));
        this.valueaddbutton.addActionListener(this);
        this.valuedeletebutton = new JButton(Resources.getString("EXAMPLECOLORING_VALUE_REMOVE"));
        this.valuedeletebutton.addActionListener(this);
        JPanel valuebutton = new JPanel();
        valuebutton.setLayout(new BoxLayout(valuebutton, 0));
        valuebutton.add(Box.createHorizontalGlue());
        valuebutton.add(this.valueaddbutton);
        valuebutton.add(Box.createRigidArea(new Dimension(10, 0)));
        valuebutton.add(this.valuedeletebutton);
        valuebutton.add(Box.createHorizontalGlue());
        this.valuetab.add((Component)valuebutton, "South");
    }

    private void applyChanges() {
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(Resources.getString("EXAMPLECOLORING_OK"))) {
            this.applyChanges();
        }
        if (cmd.equals(Resources.getString("EXAMPLECOLORING_CLOSE"))) {
            this.dispose();
        }
        if (cmd.equals(Resources.getString(Resources.getString("EXAMPLECOLORING_VALUE_INSERT")))) {
            this.valuetable.insert();
        }
        if (cmd.equals(Resources.getString(Resources.getString("EXAMPLECOLORING_VALUE_REMOVE")))) {
            this.valuetable.remove();
        }
    }
}

