/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.JViTo;
import edu.udo.cs.jvito.OperatorDescription;
import edu.udo.cs.jvito.OperatorsReader;
import edu.udo.cs.jvito.Project;
import edu.udo.cs.jvito.XMLDocument;
import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.data.ExampleColoring;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.exception.XMLException;
import edu.udo.cs.jvito.parameter.ParameterObject;
import edu.udo.cs.jvito.plot.Plot;
import edu.udo.cs.jvito.util.Resources;
import edu.udo.cs.yale.example.ExampleSet;
import java.awt.Component;
import java.awt.Image;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Source
extends ParameterObject
implements XMLDocument,
Compileable {
    protected boolean iscompiling = false;
    protected boolean iscompiled = false;
    protected String name;
    protected String oldname;
    protected Project project;
    protected LinkedList sources;
    protected LinkedList plots;
    protected ExampleSet exampleset;
    protected Source source;
    protected OperatorDescription opdesc;
    protected Image image = Resources.getImage("TREE_SOURCE");
    protected ExampleColoring examplecoloring;
    protected JInternalFrame frame;

    public Source() {
        this.plots = new LinkedList();
        this.sources = new LinkedList();
        this.examplecoloring = new ExampleColoring();
    }

    public ExampleColoring getExampleColoring() {
        return this.examplecoloring;
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldname;
    }

    public void setName(String name) {
        this.oldname = this.name == null ? name : this.name;
        this.name = name;
        JViTo.getApplication().setDirty();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public int getSourceCount() {
        if (this.sources == null) {
            return -1;
        }
        return this.sources.size();
    }

    public Source getSource(int index) {
        return (Source)this.sources.get(index);
    }

    public void addSource(Source source) {
        this.sources.add(source);
        source.setSource(this);
    }

    public void addSource(Source source, int index) {
        this.sources.add(index, source);
        source.setSource(this);
    }

    public void removeSource(Source source) {
        this.sources.remove(source);
    }

    public int getPlotCount() {
        if (this.plots == null) {
            return -1;
        }
        return this.plots.size();
    }

    public Plot getPlot(int index) {
        return (Plot)this.plots.get(index);
    }

    public void addPlot(Plot plot) {
        plot.setSource(this);
        this.plots.add(plot);
    }

    public void addPlot(Plot plot, int index) {
        plot.setSource(this);
        this.plots.add(index, plot);
    }

    public void removePlot(Plot plot) {
        this.plots.remove(plot);
    }

    public String getClassName() {
        String classname = this.getClass().getName();
        return classname.substring(classname.lastIndexOf(".") + 1);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image != null ? image : Resources.getImage("TREE_SOURCE");
    }

    public ExampleSet getExampleSet() {
        return this.exampleset;
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        String breakpointString = "";
        result.append(indent + "<source " + "name=\"" + this.name + "\" " + "class=\"" + this.getClass().getName() + "\">\n");
        result.append(indent + "  <description text=\"" + this.getDescription() + "\"/>\n");
        result.append(this.parameters.getXML(indent + "  "));
        LinkedList childs = this.getXMLDocChilds();
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            XMLDocument doc = (XMLDocument)iter.next();
            result.append(doc.getXML(indent + "\t"));
        }
        result.append(indent + "</source>\n");
        return result.toString();
    }

    public LinkedList getXMLDocChilds() {
        LinkedList<ExampleColoring> list = new LinkedList<ExampleColoring>();
        if (this.examplecoloring != null) {
            list.add(this.examplecoloring);
        }
        if (this.plots != null) {
            list.addAll(this.plots);
        }
        if (this.sources != null) {
            list.addAll(this.sources);
        }
        return list;
    }

    private String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private Object[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new Object[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    public void loadXMLDocument(Element element) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("source")) {
            throw new XMLException("<source> expected!");
        }
        String className = null;
        String name = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <source> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <source> tag is not defined! ");
        }
        name = nameAttr.getValue();
        this.setName(name);
        NodeList innerTags = element.getChildNodes();
        for (int i = 0; i < innerTags.getLength(); ++i) {
            OperatorDescription opdesc;
            Class<?> c;
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                Object[] parameter = this.createParameterFromXML(inner);
                this.getParameters().setParameter((String)parameter[0], parameter[1]);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("source")) {
                classAttr = inner.getAttributeNode("class");
                if (classAttr == null) {
                    throw new XMLException("Attribute 'class' of <operator> tag is not defined! ");
                }
                className = classAttr.getValue();
                Source source = null;
                try {
                    c = Class.forName(className);
                    source = (Source)c.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new XMLException("Can't find class " + className, e);
                }
                catch (InstantiationException e) {
                    throw new XMLException("Can not instantiate the class for className: " + className, e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLException("Illegal Access for the class: " + className, e);
                }
                catch (ClassCastException e) {
                    throw new XMLException("Can not cast from " + className + " to Source!");
                }
                opdesc = OperatorsReader.getOperatorDescription(c);
                source.setImage(opdesc.getIcon());
                source.loadXMLDocument(inner);
                this.addSource(source);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("plot")) {
                classAttr = inner.getAttributeNode("class");
                if (classAttr == null) {
                    throw new XMLException("Attribute 'class' of <plot> tag is not defined! ");
                }
                className = classAttr.getValue();
                Plot plot = null;
                try {
                    c = Class.forName(className);
                    plot = (Plot)c.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new XMLException("Can't find class " + className, e);
                }
                catch (InstantiationException e) {
                    throw new XMLException("Can not instantiate the class for className: " + className, e);
                }
                catch (IllegalAccessException e) {
                    throw new XMLException("Illegal Access for the class: " + className, e);
                }
                catch (ClassCastException e) {
                    throw new XMLException("Can not cast from " + className + " to Source!");
                }
                opdesc = OperatorsReader.getOperatorDescription(c);
                plot.setImage(opdesc.getIcon());
                plot.loadXMLDocument(inner);
                this.addPlot(plot);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("description")) {
                String description = this.createDescriptionFromXML(inner);
                this.setDescription(description);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("examplecoloring")) {
                this.examplecoloring = new ExampleColoring();
                this.examplecoloring.loadXMLDocument(inner);
                continue;
            }
            throw new XMLException("Ilegal inner tag for <source>: " + inner.getTagName());
        }
    }

    public void writeXML(PrintWriter out, String indent) {
    }

    public void compile() throws CompilerException {
    }

    public Compileable getCompileableChild(int index) {
        if (index < this.sources.size()) {
            return (Compileable)this.sources.get(index);
        }
        if ((index -= this.sources.size()) < this.plots.size()) {
            return (Compileable)this.plots.get(index);
        }
        return null;
    }

    public int getCompileableChildCount() {
        return this.sources.size() + this.plots.size();
    }

    public Compileable getParentCompileableObject() {
        if (this.source != null) {
            return this.source;
        }
        return this.project;
    }

    public boolean isCompiled() {
        return this.iscompiled;
    }

    public boolean isCompiling() {
        return this.iscompiling;
    }

    public void parentIsCompiled() {
    }

    public void fireIsCompiled() {
        Iterator iter = this.sources.iterator();
        while (iter.hasNext()) {
            Source source = (Source)iter.next();
            source.parentIsCompiled();
        }
        iter = this.plots.iterator();
        while (iter.hasNext()) {
            Plot plot = (Plot)iter.next();
            plot.parentIsCompiled();
        }
    }

    public void refreshParameter() {
    }

    public void setJInternalFrame(JInternalFrame frame) {
        this.frame = frame;
    }

    public Component getVisualisationComponent() {
        if (this.exampleset == null) {
            return new JPanel();
        }
        JScrollPane scrollpane = new JScrollPane(this.exampleset.getVisualisationComponent());
        return scrollpane;
    }
}

