/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.data;

import edu.udo.cs.jvito.data.Source;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FileSource
extends Source {
    public FileSource() {
        this.plots = new LinkedList();
        this.sources = new LinkedList();
    }

    public FileSource(String name) {
        this.name = name;
        this.plots = new LinkedList();
        this.sources = new LinkedList();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("attributes", "Filename for the xml attribute description file. This file also contains the names of the files to read the data from.", false));
        ParameterTypeInt type = new ParameterTypeInt("sample_size", "The maximum number of examples to read from the data files (-1 = all)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString("column_separators", "Column separators for data files (regular expression)", ",?\\s|;?\\s|,|;"));
        types.add(new ParameterTypeString("comment_chars", "Lines beginning with these characters are ignored.", "#"));
        types.add(new ParameterTypeBoolean("use_quotes", "Indicates if quotes should be regarded (slower!).", false));
        return types;
    }

    public void compile() throws CompilerException {
        this.iscompiling = true;
        String attributes = this.getParameterAsString("attributes");
        int maxLines = this.getParameterAsInt("sample_size");
        String separatorRegExpr = this.getParameterAsString("column_separators");
        char[] comments = this.getParameterAsString("comment_chars").toCharArray();
        int dataRowType = this.getParameterAsInt("datamanagement");
        boolean useQuotes = this.getParameterAsBoolean("use_quotes");
        AttributeDataSources attributeDataSources = null;
        FileDataRowReader reader = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(new File(attributes), true);
            reader = new FileDataRowReader(new DataRowFactory(dataRowType), attributeDataSources.getDataSources(), maxLines, separatorRegExpr, comments, useQuotes);
        }
        catch (IOException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        catch (XMLException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        catch (SAXException e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        ExampleSet result = null;
        try {
            AttributeSet attributeSet = new AttributeSet(attributeDataSources);
            MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader);
            result = table.createExampleSet(attributeSet);
            if (result.getSize() == 0) {
                this.iscompiling = false;
                throw new CompilerException("Size of the ExampleSet is null.");
            }
        }
        catch (UserError e) {
            this.iscompiling = false;
            throw new CompilerException(e.getMessage(), e);
        }
        this.exampleset = result;
        this.exampleset.recalculateAllAttributeStatistics();
        this.iscompiling = false;
        this.iscompiled = true;
    }
}

