/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.jvito.compile;

import edu.udo.cs.jvito.compile.Compileable;
import edu.udo.cs.jvito.compile.Compiler;
import edu.udo.cs.jvito.exception.CompilerException;
import edu.udo.cs.jvito.util.Resources;
import java.util.LinkedList;

public class JViToCompiler
implements Compiler,
Runnable {
    private Compileable comp;
    private Exception exception;
    private Compileable current;
    private boolean iscompiling = true;
    private int task;
    public static final int COMPILE = 0;
    public static final int COMPILE_ALL = 1;
    public static final int COMPILE_ALL_CHILDS = 2;
    public static final int COMPILE_ALL_PARENTS = 3;
    public static final String[] COMPILE_TASK_NAMES = new String[]{Resources.getString("COMILE"), Resources.getString("COMILE_ALL"), Resources.getString("COMILE_ALL_CHILDS"), Resources.getString("COMILE_ALL_PARENTS")};

    public JViToCompiler(Compileable comp, int task) {
        this.comp = comp;
        this.task = task;
        this.current = null;
        this.exception = null;
    }

    public int getTask() {
        return this.task;
    }

    public String getTaskName() {
        return COMPILE_TASK_NAMES[this.task];
    }

    public void compile(Compileable comp) throws CompilerException {
        Compileable parent = comp.getParentCompileableObject();
        if (parent != null && !parent.isCompiled()) {
            throw new CompilerException(Resources.getString("EXCEPTION_PARENT_NOT_COMPILED"));
        }
        this.current = comp;
        comp.compile();
        comp.fireIsCompiled();
    }

    public void compileAll(Compileable comp) throws CompilerException {
        this.current = comp;
        comp.compile();
        comp.fireIsCompiled();
        this.compileAllChilds(comp);
    }

    public void compileAllChilds(Compileable comp) throws CompilerException {
        LinkedList<Compileable> complist = new LinkedList<Compileable>();
        int childs = comp.getCompileableChildCount();
        for (int i = 0; i < childs; ++i) {
            complist.add(comp.getCompileableChild(i));
        }
        while (!complist.isEmpty()) {
            Compileable c = (Compileable)complist.removeFirst();
            this.compile(c);
            int count = c.getCompileableChildCount();
            for (int i = 0; i < count; ++i) {
                complist.add(c.getCompileableChild(i));
            }
        }
    }

    public void compileAllParents(Compileable comp) throws CompilerException {
        LinkedList<Compileable> complist = new LinkedList<Compileable>();
        Compileable parent = comp.getParentCompileableObject();
        while (parent != null) {
            complist.addFirst(parent);
        }
        while (!complist.isEmpty()) {
            Compileable c = (Compileable)complist.removeFirst();
            this.compile(c);
        }
    }

    public void run() {
        try {
            this.runthis();
        }
        catch (CompilerException e) {
            this.exception = e;
            e.printStackTrace();
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
        }
    }

    public void runthis() throws CompilerException {
        this.iscompiling = true;
        if (this.task == 0) {
            this.compile(this.comp);
        } else if (this.task == 1) {
            this.compileAll(this.comp);
        } else if (this.task == 2) {
            this.compileAllChilds(this.comp);
        } else if (this.task == 3) {
            this.compileAllParents(this.comp);
        }
        this.iscompiling = false;
        this.current = null;
    }

    public Exception getException() {
        return this.exception;
    }

    public Compileable getCurrentCompileableObject() {
        return this.current;
    }

    public boolean isCompiling() {
        return this.iscompiling;
    }
}

