/*
 * Decompiled with CFR 0.152.
 */
package miningmart.systemControl;

import java.io.File;
import java.io.IOException;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.InstallComponents;
import miningmart.installWizard.exceptions.InstallWizardException;

public class ScriptExecuter {
    public static final short RMI = 0;
    public static final short M4C = 1;
    public static final short JBOSS = 2;
    public static final short HCI = 3;
    private static final String fs = File.separator;
    private static final String M4C_DIR = String.valueOf(fs) + "compiler";
    private static final String RMI_SCRIPT = String.valueOf(M4C_DIR) + fs + "rmi_registry";
    private static final String M4C_SCRIPT = String.valueOf(M4C_DIR) + fs + "start";
    private static final String HCI_SCRIPT = String.valueOf(fs) + "HCI" + fs + "start_hci";
    private static final String JBOSS_SCRIPT = String.valueOf(fs) + "jboss-3.0.0" + fs + "bin" + fs + "run";
    private static final String JBOSS_KILL_SCRIPT = String.valueOf(fs) + "jboss-3.0.0" + fs + "bin" + fs + "shutdown";
    private static final String COMPILER_KILL_SCRIPT = String.valueOf(M4C_DIR) + fs + "stop";
    private final String miningMartHome;

    public ScriptExecuter(String miningMartHome) {
        this.miningMartHome = miningMartHome;
    }

    private String getHomeDir() {
        return this.miningMartHome;
    }

    public Process getProcess(short component) throws InstallWizardException {
        switch (component) {
            case 0: {
                return this.getRmiProcess();
            }
            case 1: {
                return this.getCompilerProcess();
            }
            case 2: {
                return this.getJbossProcess();
            }
            case 3: {
                return this.getHciProcess();
            }
        }
        throw new InstallWizardException("ScriptExecuter.getProcess(short) : Unknown component number " + component);
    }

    public static boolean isKillable(short component) {
        return component == 2 || component == 1;
    }

    public Process getKillProcess(short component) throws InstallWizardException {
        switch (component) {
            case 2: {
                return ScriptExecuter.runBinaryInOwnDir(this.getJbossKillScript());
            }
            case 1: {
                return ScriptExecuter.runBinaryInOwnDir(this.getCompilerKillScript());
            }
        }
        return null;
    }

    public Process getRmiProcess() throws InstallWizardException {
        return ScriptExecuter.runBinaryInOwnDir(this.getRmiScript());
    }

    public Process getCompilerProcess() throws InstallWizardException {
        return ScriptExecuter.runBinaryInOwnDir(this.getCompilerScript());
    }

    public Process getJbossProcess() throws InstallWizardException {
        return ScriptExecuter.runBinaryInOwnDir(this.getJbossScript());
    }

    public Process getHciProcess() throws InstallWizardException {
        return ScriptExecuter.runBinaryInOwnDir(this.getHciScript());
    }

    private static File extractDirectory(String path) {
        int index;
        if (path != null && (index = path.lastIndexOf(fs)) > 0) {
            return new File(path.substring(0, index));
        }
        return null;
    }

    private static Process runBinaryInOwnDir(String command) throws InstallWizardException {
        File dir = ScriptExecuter.extractDirectory(command);
        if (command != null && dir != null) {
            if (command.endsWith(".sh") && InstallComponents.getOperatingSystem() != 3) {
                String[] args = new String[]{"chmod", "u+x", command};
                Process p = ScriptExecuter.runBinary(args, dir);
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (p != null) {
                    p.destroy();
                }
            }
            return ScriptExecuter.runBinary(command, dir);
        }
        return null;
    }

    public static void setExecBitShScripts(File dir) throws InstallWizardException {
        String command = "chmod u+x *.sh";
        ScriptExecuter.execBinShCommand(command, dir);
    }

    public static void setExecBitAllFiles(File dir) throws InstallWizardException {
        String command = "chmod u+x *";
        ScriptExecuter.execBinShCommand(command, dir);
    }

    private static void execBinShCommand(String command, File dir) throws InstallWizardException {
        short os = InstallComponents.getOperatingSystem();
        if ((os == 2 || os == 1) && dir != null && dir.exists() && dir.isDirectory()) {
            String[] args = new String[]{"/bin/sh", "-c", command};
            Process p = ScriptExecuter.runBinary(args, dir);
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (p != null) {
                p.destroy();
            }
        }
    }

    private String getScriptFileSuffix() {
        return Configurator.getScriptFileSuffix();
    }

    private String getRmiScript() {
        return String.valueOf(this.getHomeDir()) + RMI_SCRIPT + this.getScriptFileSuffix();
    }

    private String getCompilerScript() {
        return String.valueOf(this.getHomeDir()) + M4C_SCRIPT + this.getScriptFileSuffix();
    }

    private String getJbossScript() {
        return String.valueOf(this.getHomeDir()) + JBOSS_SCRIPT + this.getScriptFileSuffix();
    }

    private String getHciScript() {
        return String.valueOf(this.getHomeDir()) + HCI_SCRIPT + this.getScriptFileSuffix();
    }

    private String getJbossKillScript() {
        return String.valueOf(this.getHomeDir()) + JBOSS_KILL_SCRIPT + this.getScriptFileSuffix();
    }

    private String getCompilerKillScript() {
        return String.valueOf(this.getHomeDir()) + COMPILER_KILL_SCRIPT + this.getScriptFileSuffix();
    }

    private static Process runBinary(String command, File execDir) throws InstallWizardException {
        String[] cmdArray = new String[]{command};
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmdArray, null, execDir);
        }
        catch (IOException ioe) {
            throw new InstallWizardException("Error accessing command: " + ioe.getMessage());
        }
        return process;
    }

    private static Process runBinary(String[] commandArray, File execDir) throws InstallWizardException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commandArray, null, execDir);
        }
        catch (IOException ioe) {
            throw new InstallWizardException("Error accessing command: " + ioe.getMessage());
        }
        return process;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java miningmart.systemControl.ScriptExecuter <command> <whereToExecute>");
            System.exit(-1);
        }
        File dir = null;
        try {
            dir = new File(args[1]).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            System.err.println("Directory " + dir.getAbsolutePath() + " not found!");
            System.exit(-1);
        }
        String command = args[0];
        System.out.println("Starting " + command + " in directory " + dir.getAbsolutePath());
        ScriptExecuter.runBinary(command, dir);
        System.out.println("*** Exit ***");
    }
}

