/*
 * Decompiled with CFR 0.152.
 */
package miningmart.systemControl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import miningmart.installWizard.exceptions.InstallWizardException;

public class ProcessWindow
extends Thread {
    private final Process process;
    private boolean exitFlag = false;
    private boolean outputOn = false;
    private Exception theException = null;
    private final Frame frame;
    private final JScrollPane scrollPane;
    private final JTextArea output;
    private final ActionListener exitAction;

    public ProcessWindow(Process process, ActionListener hideAction, ActionListener killAction, ActionListener exitAction) {
        this.process = process;
        this.exitAction = exitAction;
        this.frame = new Frame();
        this.output = new JTextArea(25, 60);
        this.output.setEditable(false);
        this.frame.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.output);
        this.frame.add((Component)this.scrollPane, "Center");
        this.outputOn = true;
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        JButton button = new JButton("Kill");
        if (killAction != null) {
            button.addActionListener(killAction);
        } else {
            button.setEnabled(false);
            this.println("Please note, that there is no kill functionality for this component, yet.");
            this.println("Please exit the launched application manually.\n");
        }
        panel.add(button);
        button = new JButton("Hide");
        if (hideAction == null) {
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProcessWindow.this.hide();
                }
            });
        } else {
            button.addActionListener(hideAction);
        }
        panel.add(button);
        this.frame.add((Component)panel, "South");
        this.show();
        this.start();
    }

    public void show() {
        this.frame.pack();
        this.frame.show();
    }

    public void hide() {
        this.frame.hide();
    }

    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            try {
                while (!this.getExitFlag()) {
                    if (in.ready()) {
                        String line = in.readLine();
                        if (line != null) {
                            this.println(line);
                            continue;
                        }
                        break;
                    }
                    ProcessWindow.shortBreak(300);
                    try {
                        this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException line) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                in.close();
                throw throwable;
            }
            Object var5_8 = null;
            in.close();
            try {
                int exitCode = this.process.waitFor();
            }
            catch (InterruptedException e) {}
        }
        catch (IOException ioe) {
            this.theException = new InstallWizardException("Error accessing command: " + ioe.getMessage());
            ioe.printStackTrace();
        }
        this.frame.dispose();
        if (this.exitAction != null) {
            this.exitAction.actionPerformed(null);
        }
        this.dispose();
    }

    public void dispose() {
        if (this.setExitFlag()) {
            ProcessWindow.shortBreak(1000);
            this.process.destroy();
        }
    }

    private synchronized boolean setExitFlag() {
        if (!this.exitFlag) {
            this.exitFlag = true;
            return true;
        }
        return false;
    }

    public boolean getExitFlag() {
        return this.exitFlag;
    }

    public Exception getLastException() {
        return this.theException;
    }

    public void print(String s) {
        if (!this.getExitFlag()) {
            this.output.append(s);
            JTextArea out = this.output;
            double height = out.getSize().getHeight();
            double vheight = out.getVisibleRect().getHeight();
            this.scrollPane.getViewport().setViewPosition(new Point(0, (int)(height - vheight)));
        }
    }

    public void println(String s) {
        this.print(String.valueOf(s) + "\n");
    }

    public static void shortBreak(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

