/*
 * Decompiled with CFR 0.152.
 */
package miningmart.systemControl;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JPanel;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.systemControl.ProcessWindow;
import miningmart.systemControl.ScriptExecuter;

public class MainWindow
extends Frame {
    private static final String RMI_NAME = "The RMI registry is:";
    private static final String M4C_NAME = "The M4 Compiler is:";
    private static final String JBOSS_NAME = "The JBOSS server is:";
    private static final String HCI_NAME = "The HCI is:";
    private final ScriptExecuter executer;

    public MainWindow(String miningMartHome) throws InstallWizardException {
        this.executer = new ScriptExecuter(miningMartHome);
        this.prepareComponents();
        this.pack();
        this.show();
    }

    private void prepareComponents() throws InstallWizardException {
        this.setTitle("*** MiningMart System Control ***");
        this.setLayout(new GridLayout(4, 1));
        this.add(this.getRmiPanel());
        this.add(this.getCompilerPanel());
        this.add(this.getJbossPanel());
        this.add(this.getHciPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.dispose();
            }
        });
        Object w = null;
    }

    private JPanel getRmiPanel() throws InstallWizardException {
        return new ComponentInformation(RMI_NAME, 0);
    }

    private JPanel getCompilerPanel() throws InstallWizardException {
        return new ComponentInformation(M4C_NAME, 1);
    }

    private JPanel getJbossPanel() throws InstallWizardException {
        return new ComponentInformation(JBOSS_NAME, 2);
    }

    private JPanel getHciPanel() throws InstallWizardException {
        return new ComponentInformation(HCI_NAME, 3);
    }

    public ScriptExecuter getExecuter() {
        return this.executer;
    }

    public static void main(String[] args) throws InstallWizardException {
        if (args.length != 1) {
            System.err.println("Please provide the MiningMart home directory as an argument to this launcher!");
            System.exit(-1);
        }
        new MainWindow(args[0]);
    }

    private class ComponentInformation
    extends JPanel {
        static final String STATUS_OFF = "Not launched";
        static final String STATUS_ON = "Running";
        static final String BUTTON_RUN = "Launch";
        static final String BUTTON_SHOW = "View";
        static final String BUTTON_HIDE = "Hide";
        final String name;
        final TextField statusTf;
        final JButton button;
        final short component;
        ProcessWindow processWindow;
        String status = "Not launched";

        ComponentInformation(String name, short comp) {
            this.name = name;
            this.component = comp;
            this.setLayout(new GridLayout(1, 3));
            TextField nameField = new TextField(name);
            nameField.setEditable(false);
            this.add(nameField);
            this.statusTf = new TextField(this.status);
            this.statusTf.setEditable(false);
            this.add(this.statusTf);
            this.button = new JButton(BUTTON_RUN);
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ ComponentInformation this$1;
                {
                    this.this$1 = componentInformation;
                }

                public void actionPerformed(ActionEvent e) {
                    ComponentInformation.access$0(this.this$1);
                }
            });
            this.add(this.button);
        }

        private void buttonAction() {
            String text = this.button.getText();
            if (text.equals(BUTTON_SHOW)) {
                this.showAction();
            } else if (text.equals(BUTTON_HIDE)) {
                this.hideAction();
            } else if (text.equals(BUTTON_RUN)) {
                this.launchAction();
            }
        }

        private void switchButton(String text) {
            this.button.setText(text);
            this.button.repaint();
        }

        private void switchStatus(String text) {
            this.status = text;
            this.statusTf.setText(text);
        }

        private void hideAction() {
            this.processWindow.hide();
            this.switchButton(BUTTON_SHOW);
        }

        private void showAction() {
            this.processWindow.show();
            this.switchButton(BUTTON_HIDE);
        }

        private void launchAction() {
            try {
                if (this.processWindow != null) {
                    this.processWindow.dispose();
                    this.processWindow = null;
                }
                Process p = MainWindow.this.getExecuter().getProcess(this.component);
                ActionListener hide = new ActionListener(this){
                    private final /* synthetic */ ComponentInformation this$1;
                    {
                        this.this$1 = componentInformation;
                    }

                    public void actionPerformed(ActionEvent e) {
                        ComponentInformation.access$1(this.this$1);
                    }
                };
                ActionListener kill = null;
                if (ScriptExecuter.isKillable(this.component)) {
                    kill = new ActionListener(this){
                        private final /* synthetic */ ComponentInformation this$1;
                        {
                            this.this$1 = componentInformation;
                        }

                        public void actionPerformed(ActionEvent e) {
                            ComponentInformation.access$2(this.this$1);
                        }
                    };
                }
                ActionListener exit = new ActionListener(this){
                    private final /* synthetic */ ComponentInformation this$1;
                    {
                        this.this$1 = componentInformation;
                    }

                    public void actionPerformed(ActionEvent e) {
                        ComponentInformation.access$3(this.this$1);
                    }
                };
                this.processWindow = new ProcessWindow(p, hide, kill, exit);
            }
            catch (InstallWizardException e) {
                System.err.println(e.getMessage());
            }
            this.switchButton(BUTTON_HIDE);
            this.switchStatus(STATUS_ON);
        }

        private void exitAction() {
            this.switchStatus(STATUS_OFF);
            this.switchButton(BUTTON_RUN);
            this.processWindow = null;
        }

        private void killAction() {
            Thread t = new Thread(this){
                private final /* synthetic */ ComponentInformation this$1;
                {
                    this.this$1 = componentInformation;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Process process;
                    block13: {
                        process = null;
                        try {
                            try {
                                process = ComponentInformation.access$4(this.this$1).getExecuter().getKillProcess(this.this$1.component);
                                if (process == null) break block13;
                                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                boolean running = true;
                                try {
                                    while (running && !this.this$1.processWindow.getExitFlag()) {
                                        if (in.ready()) {
                                            String line = in.readLine();
                                            if (line == null) {
                                                try {
                                                    process.waitFor();
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                                running = false;
                                                continue;
                                            }
                                            this.this$1.processWindow.println(line);
                                            continue;
                                        }
                                        ProcessWindow.shortBreak(300);
                                        try {
                                            process.exitValue();
                                            running = false;
                                        }
                                        catch (IllegalThreadStateException illegalThreadStateException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var9_9 = null;
                                    in.close();
                                    throw throwable;
                                }
                                Object var9_10 = null;
                                in.close();
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_12 = null;
                            if (process == null) throw throwable;
                            process.destroy();
                            throw throwable;
                        }
                    }
                    Object var8_13 = null;
                    if (process == null) return;
                    process.destroy();
                }
            };
            t.start();
        }

        static /* synthetic */ void access$0(ComponentInformation componentInformation) {
            componentInformation.buttonAction();
        }

        static /* synthetic */ void access$1(ComponentInformation componentInformation) {
            componentInformation.hideAction();
        }

        static /* synthetic */ void access$2(ComponentInformation componentInformation) {
            componentInformation.killAction();
        }

        static /* synthetic */ void access$3(ComponentInformation componentInformation) {
            componentInformation.exitAction();
        }

        static /* synthetic */ MainWindow access$4(ComponentInformation componentInformation) {
            return componentInformation.MainWindow.this;
        }
    }
}

