/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnZipper {
    private final String topDirS;

    public UnZipper(File file, String targetDir) throws IOException {
        ZipFile zip = new ZipFile(file);
        File target = new File(targetDir);
        if (!target.isDirectory() || !target.exists()) {
            throw new IOException("Error in class UnZipper: Target directory " + targetDir + " does not exist.");
        }
        this.topDirS = target.getCanonicalPath();
        Enumeration<? extends ZipEntry> theFiles = zip.entries();
        while (theFiles.hasMoreElements()) {
            ZipEntry entry = theFiles.nextElement();
            if (System.getProperty("VERBOSE") != null) {
                System.out.print(entry.getName());
                System.out.println(" - size: " + entry.getCompressedSize());
            }
            if (entry.isDirectory()) {
                this.createSubDirectory(entry);
                continue;
            }
            this.unpackToFile(zip, entry);
        }
        zip.close();
    }

    private void unpackToFile(ZipFile zip, ZipEntry entry) throws IOException {
        FileOutputStream fos;
        String targetFilePath = new File(String.valueOf(this.topDirS) + File.separator + entry.getName()).getCanonicalPath();
        if (!targetFilePath.startsWith(this.topDirS)) {
            throw new IOException("Found irregular file structure in ZIP file! I will not create file " + targetFilePath + "!");
        }
        try {
            fos = new FileOutputStream(targetFilePath);
        }
        catch (IOException e) {
            this.createSubDirectoriesForFile(targetFilePath);
            fos = new FileOutputStream(targetFilePath);
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(entry));
        byte[] buffer = new byte[32768];
        int avail = 1;
        int num = 0;
        while (avail > 0 && num != -1) {
            avail = bis.available();
            if (avail <= 0 || (num = bis.read(buffer, 0, avail < buffer.length ? avail : buffer.length)) <= 0) continue;
            bos.write(buffer, 0, num);
        }
        bis.close();
        bos.close();
    }

    private void createSubDirectoriesForFile(String targetFilePath) throws IOException {
        int index = targetFilePath.lastIndexOf(File.separator);
        if (index == -1) {
            throw new IOException("File with absolute path expected, but no file separators found in: " + targetFilePath);
        }
        String lastDir = targetFilePath.substring(0, index);
        this.createSubDirectoriesUpTo(lastDir);
    }

    private void createSubDirectoriesUpTo(String targetFilePath) throws IOException {
        File target = new File(targetFilePath);
        if (target.exists() && target.isDirectory()) {
            return;
        }
        int index = targetFilePath.lastIndexOf(File.separator);
        String lastDir = "";
        if (index > 0) {
            lastDir = targetFilePath.substring(0, index);
        }
        if (!lastDir.startsWith(this.topDirS)) {
            throw new IOException("Failed to create subdirectories up to '" + targetFilePath + "', probably because top directory " + this.topDirS + " does not exists, or because it is no super-directory.");
        }
        this.createSubDirectoriesUpTo(lastDir);
        File newDir = new File(targetFilePath);
        newDir.mkdir();
    }

    private void createSubDirectory(ZipEntry entry) throws IOException {
        File newDir = new File(String.valueOf(this.topDirS) + File.separator + entry.getName());
        if (!newDir.getCanonicalPath().startsWith(this.topDirS)) {
            throw new IOException("Found irregular file structure in ZIP file! I will not create file " + newDir.getCanonicalPath() + "!");
        }
        if (!newDir.exists() || !newDir.isDirectory()) {
            newDir.mkdir();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 1) {
            System.out.println("Trying to unzip file " + args[0] + " to directory " + args[1] + " ...");
            new UnZipper(new File(args[0]), args[1]);
            System.out.println("Successfully unzipped " + args[0] + ".");
        } else {
            System.err.println("Please specify a ZIP-file and a target directory.");
        }
    }
}

