/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard.utils;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.VariableValue;

public class ConfigReader {
    public static final short UNIX_SCRIPT = 1;
    public static final short WINDOWS_SCRIPT = 2;
    public static final short MISC_LINEBASED = 3;
    private final short typeOfFile;
    private LineNumberReader myLineReader;
    private String myLine;

    public ConfigReader(String configFileName, short typeOfFile) throws IOException {
        this.typeOfFile = typeOfFile;
        this.myLineReader = new LineNumberReader(new FileReader(configFileName));
        this.myLine = this.myLineReader.readLine();
    }

    public boolean hasMoreLines() {
        return this.myLine != null;
    }

    public String getLine() throws IOException {
        String s = this.myLine;
        this.myLine = this.myLineReader.readLine();
        return s;
    }

    public VariableValue getVariableValue(String variable) throws IOException {
        VariableValue vv;
        while ((vv = this.getNextVariableAssignment()) != null && !vv.getVariableName().equals(variable)) {
        }
        return vv == null ? null : vv;
    }

    public VariableValue getNextVariableAssignment() throws IOException {
        Object foundVar = null;
        Object value = null;
        if (!this.hasMoreLines()) {
            return null;
        }
        VariableValue vv = null;
        do {
            String s;
            if ((s = this.getLine()) == null) continue;
            s = s.trim();
            switch (this.typeOfFile) {
                case 1: {
                    vv = ConfigReader.getUnixVariableAssignment(s);
                    break;
                }
                case 2: {
                    vv = ConfigReader.getWindowsVariableAssignment(s);
                }
            }
        } while (this.hasMoreLines() && vv == null);
        return vv;
    }

    public VariableValue getVariableAssignment(String line) throws InstallWizardException {
        switch (this.typeOfFile) {
            case 1: {
                return ConfigReader.getUnixVariableAssignment(line);
            }
            case 2: {
                return ConfigReader.getWindowsVariableAssignment(line);
            }
        }
        throw new InstallWizardException("getVariableAssignment(String) not defined for current file type");
    }

    public static VariableValue getUnixVariableAssignment(String line) {
        int index;
        VariableValue vv = null;
        if (line != null && !(line = line.trim()).startsWith("#") && (index = line.indexOf(61)) != -1) {
            String foundVar = line.substring(0, index);
            String value = line.substring(index + 1).trim();
            if (foundVar != "") {
                vv = VariableValue.createVariableValue(foundVar, value);
            }
        }
        return vv;
    }

    public static VariableValue getWindowsVariableAssignment(String line) {
        int index;
        VariableValue vv = null;
        if (line != null && (line = line.trim()).toLowerCase().startsWith("set") && Character.isWhitespace(line.charAt(3)) && (index = line.indexOf(61)) != -1) {
            String foundVar = line.substring(4, index).trim();
            String value = line.substring(index + 1).trim();
            if (foundVar != "") {
                vv = VariableValue.createVariableValue(foundVar, value);
            }
        }
        return vv;
    }

    public void close() throws IOException {
        this.myLineReader.close();
        this.myLine = null;
    }

    public static void main(String[] args) throws Exception {
        System.out.print("File? ");
        byte[] b = new byte[60];
        System.in.read(b);
        String s = new String(b).trim();
        ConfigReader cfr = new ConfigReader(s, 1);
        System.out.print("Variable? ");
        b = new byte[30];
        System.in.read(b);
        s = new String(b).trim();
        System.out.println("Variable: " + s + "=" + cfr.getVariableValue(s).getVariableValue());
        cfr.close();
    }
}

