/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.File;
import java.io.IOException;
import miningmart.installWizard.ConfigWindow;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.PortsFilesConfigurator;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.SetOfVariableSettings;
import miningmart.installWizard.utils.VariableValue;

public class PortsFilesWindow
extends ConfigWindow {
    private static final String IP_OR_HOSTNAME = "LOCALHOST";
    private static final String[][] mapping = new String[][]{{"LOCALHOST", "IP or host name of this computer:", "127.0.0.1", ConfigWindow.MAPPING_VALUE_NO, ConfigWindow.MAPPING_VALUE_NO}, {PortsFilesConfigurator.JBOSS_PORT, "Port of your JBOSS server", "1299", ConfigWindow.MAPPING_VALUE_NO, ConfigWindow.MAPPING_VALUE_NO}, {PortsFilesConfigurator.M4C_RMIREGISTRY, "How to start rmiregistry from a command line?", "rmiregistry", "", ConfigWindow.MAPPING_VALUE_NO}};

    public PortsFilesWindow(File miningMartHome, MainWindow mw) throws IOException, InstallWizardException {
        super(miningMartHome, mw);
    }

    protected Configurator createConfigurator(File miningMartHome, MainWindow mw) throws IOException, InstallWizardException {
        return new PortsFilesConfigurator(miningMartHome, mw);
    }

    protected String[][] getMapping() {
        return mapping;
    }

    protected void mapVariableValuesToGui() {
        int index;
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String jndi = theSet.getVariableValue(PortsFilesConfigurator.HCI_JBOSS_JNDI);
        if (jndi != null && (index = jndi.indexOf("//")) != -1) {
            String host;
            if ((index = (jndi = jndi.substring(index + 2).trim()).indexOf(58)) != -1) {
                host = jndi.substring(0, index);
                String port = jndi.substring(index + 1);
                if (port.endsWith("\"")) {
                    port = port.substring(0, port.length() - 1);
                }
                VariableValue portVar = VariableValue.createVariableValue(PortsFilesConfigurator.JBOSS_PORT, port.trim());
                theSet.addVariableValue(portVar);
            } else {
                host = jndi.endsWith("\"") ? jndi.substring(0, jndi.length() - 1) : jndi;
            }
            VariableValue ipHost = VariableValue.createVariableValue(IP_OR_HOSTNAME, host);
            theSet.addVariableValue(ipHost);
        }
    }

    protected void mapGuiValuesToVariables() {
        int index;
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String localhost = theSet.getVariableValue(IP_OR_HOSTNAME);
        String jbossPort = theSet.getVariableValue(PortsFilesConfigurator.JBOSS_PORT);
        String jndiOld = theSet.getVariableValue(PortsFilesConfigurator.HCI_JBOSS_JNDI);
        String prefix = "\"java.naming.provider.url=jnp://";
        String suffix = "\"";
        if (jndiOld != null && (index = jndiOld.indexOf("//")) != -1) {
            prefix = jndiOld.substring(0, index + 2).trim();
            suffix = prefix.startsWith("\"") ? "\"" : "";
        }
        String theValue = String.valueOf(prefix) + (localhost == null ? "" : localhost) + ":" + (jbossPort == null ? "" : jbossPort) + suffix;
        VariableValue vv = VariableValue.createVariableValue(PortsFilesConfigurator.HCI_JBOSS_JNDI, theValue);
        theSet.addVariableValue(vv);
        this.copyVariableValue(IP_OR_HOSTNAME, PortsFilesConfigurator.HCI_COMPILER_SERVER);
    }

    protected void editNextFile() throws InstallWizardException, IOException {
        this.println("\nConfiguration finished.");
        this.mainWindow.setExecutableBits();
        this.mainWindow.setButtonsActive();
        this.mainWindow.cancelButtonAction();
    }
}

