/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.InstallComponents;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.ConfigReader;
import miningmart.installWizard.utils.SetOfVariableSettings;
import miningmart.installWizard.utils.VariableValue;

public class PortsFilesConfigurator
extends Configurator {
    public static final String HCI_DIR = "HCI";
    private static final String HCI_STARTFILE_PREFIX = "start_hci";
    public static final String M4C_DIR = "compiler";
    private static final String M4C_ETC = "compiler" + Configurator.fs + "runtime" + Configurator.fs + "etc";
    private static final String M4C_PROP_FILE_SUNOS = "properties";
    private static final String M4C_PROP_FILE_LINUX = "properties";
    private static final String M4C_PROP_FILE_WINDOWS = "properties.bat";
    private static String JBOSS_CONF_DIR = "jboss-3.0.0" + Configurator.fs + "server" + Configurator.fs + "default" + Configurator.fs + "conf";
    private static String JBOSS_SERVICE_FILE = "jboss-service.xml";
    private static String JBOSS_PORT_ORIENTATION_TAG_A = "name=\"jboss:service=Naming\"";
    private static String JBOSS_PORT_ORIENTATION_TAG_B = ">";
    private static String JBOSS_PORT_START_TAG = "<attribute name=\"Port\">";
    private static String JBOSS_PORT_CLOSE_TAG = "</attribute>";
    public static String HCI_HOME = "MYPATH";
    public static String HCI_COMPILER_SERVER = "COMPILERSERVER";
    public static String HCI_JBOSS_JNDI = "JNDI3";
    public static String JBOSS_PORT = "jboss_port";
    public static String M4C_HOME = "M4C_HOME";
    public static String M4C_COMPILER_SERVER = HCI_COMPILER_SERVER;
    public static String M4C_RMIREGISTRY = "RMI_REGISTRY";
    private static String[] HCI_START_VARS = new String[]{HCI_HOME, HCI_COMPILER_SERVER, HCI_JBOSS_JNDI};

    public PortsFilesConfigurator(File miningMartHome, MainWindow mw) throws InstallWizardException, IOException {
        super(miningMartHome, mw);
    }

    protected void initVariables() throws IOException, InstallWizardException {
        this.readHciStartVars();
        this.readM4cPropertyVars();
        this.autoConfigurePath();
    }

    private void autoConfigurePath() {
        SetOfVariableSettings theSet = this.getTheSettings();
        String home = String.valueOf(this.getHomeDir()) + Configurator.fs;
        theSet.addVariableValue(VariableValue.createVariableValue(M4C_HOME, String.valueOf(home) + M4C_DIR));
        theSet.addVariableValue(VariableValue.createVariableValue(HCI_HOME, String.valueOf(home) + HCI_DIR));
    }

    private void readHciStartVars() throws IOException, InstallWizardException {
        File file = new File(this.getHciStartFileName());
        if (!file.exists()) {
            throw new InstallWizardException("PortsFilesConfigurator.readHciStartVars() : No HCI start script found.");
        }
        short typeOfFile = 1;
        if (InstallComponents.getOperatingSystem() == 3) {
            typeOfFile = 2;
        }
        ConfigReader cr = new ConfigReader(file.getAbsolutePath(), typeOfFile);
        SetOfVariableSettings theSet = this.getTheSettings();
        block0: while (cr.hasMoreLines()) {
            VariableValue vv = cr.getNextVariableAssignment();
            if (vv == null) continue;
            int i = 0;
            while (i < HCI_START_VARS.length) {
                String name = HCI_START_VARS[i];
                if (vv.getVariableName().equals(name)) {
                    theSet.addVariableValue(vv);
                    continue block0;
                }
                ++i;
            }
        }
        cr.close();
    }

    private void readM4cPropertyVars() throws IOException, InstallWizardException {
        short os = InstallComponents.getOperatingSystem();
        short typeOfFile = 1;
        if (os == 3) {
            typeOfFile = 2;
        }
        File file = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + M4C_ETC + Configurator.fs + this.getM4CPropertyFileName());
        ConfigReader cr = new ConfigReader(file.getAbsolutePath(), typeOfFile);
        SetOfVariableSettings theSet = this.getTheSettings();
        while (cr.hasMoreLines()) {
            VariableValue vv = cr.getNextVariableAssignment();
            if (vv == null || !vv.getVariableName().equals(M4C_RMIREGISTRY)) continue;
            theSet.addVariableValue(vv);
        }
        cr.close();
    }

    private String getHciStartFileName() {
        String suffix = Configurator.getScriptFileSuffix();
        if (suffix != null) {
            String path = String.valueOf(this.getHomeDir()) + Configurator.fs + HCI_DIR + Configurator.fs + HCI_STARTFILE_PREFIX + suffix;
            return path;
        }
        return null;
    }

    private String getM4CPropertyFileName() {
        try {
            short os = InstallComponents.getOperatingSystem();
            switch (os) {
                case 1: {
                    return "properties";
                }
                case 2: {
                    return "properties";
                }
                case 3: {
                    return M4C_PROP_FILE_WINDOWS;
                }
            }
            return null;
        }
        catch (InstallWizardException e) {
            return null;
        }
    }

    public void save() throws IOException, InstallWizardException {
        super.save();
        this.adaptHciStartScript();
        this.adaptM4cPropertyFile();
        this.adaptJbossOracleFile();
    }

    public void adaptHciStartScript() throws IOException, InstallWizardException {
        short os = InstallComponents.getOperatingSystem();
        short typeOfFile = 1;
        if (os == 3) {
            typeOfFile = 2;
        }
        File file = new File(this.getHciStartFileName());
        this.println("Saving configuration file " + file.getAbsolutePath());
        File backup = this.makeBackupFile(file);
        if (backup == null) {
            throw new InstallWizardException("Error in PortsFilesConfigurator.adaptHciStartScript: File " + file.getAbsolutePath() + " does not exist!");
        }
        ConfigReader cr = new ConfigReader(backup.getAbsolutePath(), typeOfFile);
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        while (cr.hasMoreLines()) {
            String line = cr.getLine();
            VariableValue vv = cr.getVariableAssignment(line);
            if (vv != null) {
                int i = 0;
                while (i < HCI_START_VARS.length) {
                    String var = HCI_START_VARS[i];
                    if (vv.getVariableName().equals(var)) {
                        String newValue = this.getTheSettings().getVariableValue(var);
                        line = this.replaceAssignment(newValue, line);
                        break;
                    }
                    ++i;
                }
            }
            ps.println(line);
        }
        cr.close();
        ps.close();
    }

    public void adaptM4cPropertyFile() throws IOException, InstallWizardException {
        short os = InstallComponents.getOperatingSystem();
        short typeOfFile = 1;
        if (os == 3) {
            typeOfFile = 2;
        }
        File file = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + M4C_ETC + Configurator.fs + this.getM4CPropertyFileName());
        this.println("Saving configuration file " + file.getAbsolutePath());
        File backup = this.makeBackupFile(file);
        if (backup == null) {
            throw new InstallWizardException("Error in PortsFilesConfigurator.adaptHciStartScript: File " + file.getAbsolutePath() + " does not exist!");
        }
        ConfigReader cr = new ConfigReader(backup.getAbsolutePath(), typeOfFile);
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        while (cr.hasMoreLines()) {
            String line = cr.getLine();
            VariableValue vv = cr.getVariableAssignment(line);
            if (vv != null) {
                String newValue;
                if (vv.getVariableName().equals(M4C_HOME)) {
                    newValue = this.getTheSettings().getVariableValue(M4C_HOME);
                    line = this.replaceAssignment(newValue, line);
                } else if (vv.getVariableName().equals(M4C_COMPILER_SERVER)) {
                    newValue = this.getTheSettings().getVariableValue(M4C_COMPILER_SERVER);
                    line = this.replaceAssignment(newValue, line);
                } else if (vv.getVariableName().equals(M4C_RMIREGISTRY)) {
                    newValue = this.getTheSettings().getVariableValue(M4C_RMIREGISTRY);
                    line = this.replaceAssignment(newValue, line);
                }
            }
            ps.println(line);
        }
        cr.close();
        ps.close();
    }

    private void adaptJbossOracleFile() throws IOException {
        String deployPath = String.valueOf(this.getHomeDir()) + Configurator.fs + JBOSS_CONF_DIR;
        File targetFile = new File(String.valueOf(deployPath) + Configurator.fs + JBOSS_SERVICE_FILE);
        this.println("Saving configuration file " + targetFile.getAbsolutePath());
        String xml = this.fileToString(targetFile);
        this.makeBackupFile(targetFile);
        BufferedWriter out = new BufferedWriter(new FileWriter(targetFile));
        SetOfVariableSettings theSet = this.getTheSettings();
        String port = theSet.getVariableValue(JBOSS_PORT);
        port = port == null ? "" : port.trim();
        try {
            xml = this.changeVarInXml(xml, JBOSS_PORT_ORIENTATION_TAG_A, JBOSS_PORT_ORIENTATION_TAG_B, "", out);
            xml = this.changeVarInXml(xml, JBOSS_PORT_START_TAG, JBOSS_PORT_CLOSE_TAG, port, out);
            out.write(xml);
        }
        catch (InstallWizardException e) {
            this.println("Warning: File " + targetFile.getAbsolutePath() + " is corrupt!");
            this.println("Error when trying to change variable settings:\n" + e.getMessage());
        }
        out.close();
    }
}

