/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import miningmart.installWizard.ConfigWindow;
import miningmart.installWizard.DatabaseConfigWindow;
import miningmart.installWizard.InstallComponents;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.systemControl.ScriptExecuter;

public class MainWindow
extends Frame {
    public static final String WIZARD_PROPERTY_FILE = "properties";
    public static final String WPF_MM_SYSTEM_VAR = "MM_HOME";
    public static final String JBOSS_BIN_DIR = "jboss-3.0.0" + File.separator + "bin";
    public static final String M4INSTALL_BIN_DIR = "M4Installer";
    public static final short DOWNLOAD_M4INSTALLER = 0;
    public static final short DOWNLOAD_M4_COMPILER = 1;
    public static final short DOWNLOAD_JBOSS = 2;
    public static final short DOWNLOAD_M4_INTERFACE = 3;
    public static final short DOWNLOAD_HCI = 4;
    private static String[] theQuestions = new String[]{"Download the M4Installer Script?", "Download the M4 Compiler?", "Download JBOSS-3.0.0?", "Download the M4 Interface?", "Download the Human Computer Interface?"};
    private final JPanel rootPanel = new JPanel();
    private final BooleanCheckboxPanel[] theBoxes;
    private JPanel inputPanel;
    private final JFileChooser homeDirFileDialog;
    private final JTextField homeDirCurrentEntry;
    private final JTextArea outputArea;
    private final JScrollPane scrollPane;
    private boolean buttonsInactive = false;

    public MainWindow() {
        this.rootPanel.setLayout(new BorderLayout());
        this.homeDirFileDialog = new JFileChooser();
        this.homeDirCurrentEntry = new JTextField();
        this.theBoxes = this.setUpRootPanelPanel(this.createHomeDirPanel(), this.createSaveCancelPanel());
        this.outputArea = this.createOutputArea();
        this.scrollPane = new JScrollPane(this.outputArea);
        this.rootPanel.add((Component)this.scrollPane, "South");
        this.add(this.rootPanel);
        this.setTitle("*** The MiningMart InstallWizard ***");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.cancelButtonAction();
            }
        });
        this.pack();
        this.show();
    }

    private Panel createSaveCancelPanel() {
        Panel p = new Panel();
        p.setLayout(new GridLayout(1, 2));
        JButton save = new JButton("Continue");
        JButton cancel = new JButton("Cancel");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveButtonAction();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.cancelButtonAction();
            }
        });
        p.add((Component)save, "West");
        p.add((Component)cancel, "East");
        return p;
    }

    private BooleanCheckboxPanel[] setUpRootPanelPanel(Panel fileDialogPanel, Panel saveCancel) {
        JPanel p = new JPanel();
        int length = theQuestions.length;
        p.setLayout(new GridLayout(length + 2, 1));
        p.add(fileDialogPanel);
        BooleanCheckboxPanel[] b = new BooleanCheckboxPanel[length];
        int i = 0;
        while (i < length) {
            String label = theQuestions[i];
            BooleanCheckboxPanel bcp = new BooleanCheckboxPanel(label);
            p.add(bcp);
            b[i] = bcp;
            ++i;
        }
        p.add(saveCancel);
        this.rootPanel.add((Component)p, "Center");
        this.inputPanel = p;
        return b;
    }

    private Panel createHomeDirPanel() {
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        TextField tf = new TextField("Home directory of the system:");
        tf.setEditable(false);
        p.add((Component)tf, "West");
        p.add((Component)this.homeDirCurrentEntry, "Center");
        JButton button = new JButton("Browse");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.browseButtonAction();
            }
        });
        p.add((Component)button, "East");
        File sysPath = new File(WIZARD_PROPERTY_FILE);
        if (sysPath.exists() && sysPath.isFile()) {
            try {
                String line;
                LineNumberReader in = new LineNumberReader(new FileReader(sysPath));
                String homeDir = null;
                while ((line = in.readLine()) != null) {
                    int index = line.indexOf(61);
                    if (index == -1 || !line.substring(0, index).trim().equals(WPF_MM_SYSTEM_VAR)) continue;
                    homeDir = line.substring(index + 1).trim();
                    break;
                }
                in.close();
                if (homeDir != null) {
                    this.homeDirCurrentEntry.setText(homeDir);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return p;
    }

    private JTextArea createOutputArea() {
        JTextArea t = new JTextArea(20, 80);
        t.setEditable(false);
        return t;
    }

    private void browseButtonAction() {
        if (!this.setButtonsInactive()) {
            return;
        }
        JFileChooser fd = this.homeDirFileDialog;
        fd.setFileSelectionMode(1);
        fd.showOpenDialog(this);
        File entry = fd.getSelectedFile();
        if (entry != null) {
            this.homeDirCurrentEntry.setText(entry.getAbsolutePath());
        }
        this.setButtonsActive();
    }

    void cancelButtonAction() {
        if (!this.setButtonsInactive()) {
            return;
        }
        Thread t = new Thread(){

            public void run() {
                MainWindow.this.println("\n*** Exiting ***");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MainWindow.this.dispose();
            }
        };
        t.start();
    }

    private void saveButtonAction() {
        if (!this.setButtonsInactive()) {
            return;
        }
        String mmHomePath = this.homeDirCurrentEntry.getText();
        try {
            File dir = new File(mmHomePath).getCanonicalFile();
            if (dir.exists() && !dir.isDirectory()) {
                this.println("\nError: The home directory you specified exists, but is no directory!");
                this.setButtonsActive();
                return;
            }
            if (!dir.exists()) {
                this.println("\nTrying to create directory " + dir.getAbsolutePath());
                dir.mkdir();
                this.println("Directory created.");
            }
            new InstallComponents(dir, this, this.getBoxesResult());
            File sysPath = new File(WIZARD_PROPERTY_FILE);
            PrintStream ps = new PrintStream(new FileOutputStream(sysPath));
            ps.println("MM_HOME=" + dir.getAbsolutePath());
            ps.close();
        }
        catch (InstallWizardException e) {
            this.println("\n*** InstallWizardException caught during installation: ***\n" + e.getMessage());
            this.setButtonsActive();
        }
        catch (IOException e) {
            this.println("\n*** IOException caught during installation: ***\n" + e.getMessage());
            this.setButtonsActive();
        }
    }

    public boolean[] getBoxesResult() {
        boolean[] r = new boolean[this.theBoxes.length];
        int i = 0;
        while (i < r.length) {
            r[i] = this.theBoxes[i].getSelectedState();
            ++i;
        }
        return r;
    }

    synchronized boolean setButtonsInactive() {
        if (!this.buttonsInactive) {
            this.buttonsInactive = true;
            return true;
        }
        return false;
    }

    void setButtonsActive() {
        this.buttonsInactive = false;
    }

    public void print(String s) {
        if (s != null) {
            this.outputArea.append(s);
            double height = this.outputArea.getSize().getHeight();
            double vheight = this.outputArea.getVisibleRect().getHeight();
            this.scrollPane.getViewport().setViewPosition(new Point(0, (int)(height - vheight)));
        }
    }

    public void println(String s) {
        this.print(String.valueOf(s) + "\n");
    }

    public void afterInstallingComponents(File directory) throws InstallWizardException, IOException {
        this.println("\n--- Successfully downloaded all specified components! ---\n\n");
        this.switchToDbConfigWindow(directory);
        this.setButtonsActive();
    }

    private void switchToDbConfigWindow(File mmHome) throws InstallWizardException, IOException {
        DatabaseConfigWindow cw = new DatabaseConfigWindow(mmHome, this);
        this.switchToConfigWindow(cw);
    }

    void switchToConfigWindow(ConfigWindow cw) {
        JPanel newPanel = cw.getRootPanel();
        JPanel rp = this.rootPanel;
        rp.remove(this.inputPanel);
        rp.add((Component)newPanel, "Center");
        this.inputPanel = newPanel;
        this.pack();
        this.repaint();
    }

    void setExecutableBits() throws InstallWizardException {
        short os = InstallComponents.getOperatingSystem();
        if (os == 2 || os == 1) {
            String mmHome = String.valueOf(this.homeDirCurrentEntry.getText()) + File.separator;
            File m4InstBin = new File(String.valueOf(mmHome) + M4INSTALL_BIN_DIR);
            File m4cBin = new File(String.valueOf(mmHome) + "compiler");
            File jbossBin = new File(String.valueOf(mmHome) + JBOSS_BIN_DIR);
            File hciBin = new File(String.valueOf(mmHome) + "HCI");
            this.setExecBitShScripts(m4InstBin);
            this.setExecBitShScripts(m4cBin);
            this.setExecBitShScripts(jbossBin);
            this.setExecBitShScripts(hciBin);
        }
    }

    private void setExecBitShScripts(File dir) throws InstallWizardException {
        ScriptExecuter.setExecBitShScripts(dir);
        this.println("Succefully executed 'chmod u+x " + dir.getAbsolutePath() + "/*.sh");
    }

    public static void main(String[] args) {
        new MainWindow();
    }

    private class BooleanCheckboxPanel
    extends Panel {
        private String YES_LABEL = "Yes";
        private String NO_LABEL = "No";
        public CheckboxGroup cbg = new CheckboxGroup();

        public BooleanCheckboxPanel(String text) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(1, 2));
            p.add(new Checkbox(this.YES_LABEL, this.cbg, true));
            p.add(new Checkbox(this.NO_LABEL, this.cbg, false));
            JTextField tf = new JTextField(text);
            tf.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)tf, "Center");
            this.add((Component)p, "East");
        }

        public boolean getSelectedState() {
            String label = this.cbg.getSelectedCheckbox().getLabel();
            return label == this.YES_LABEL;
        }
    }
}

