/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.Downloader;
import miningmart.installWizard.utils.UnZipper;
import miningmart.systemControl.ScriptExecuter;

public class InstallComponents
extends Thread {
    public static final short SUNOS = 1;
    public static final short LINUX = 2;
    public static final short WINDOWS = 3;
    private static String MM_WEBSITE = "http://www-ai.cs.uni-dortmund.de/MMWEB/downloads/";
    private static String HCI = "SYSTEM/hci.zip";
    private static String GRAPH_VIEW = "SYSTEM/GraphView.jar";
    private static String HOTDRAW = "SYSTEM/hotdraw.jar";
    private static String COMPILER_MAIN = "COMPILER/M4CompilerServer.zip";
    private static String COMPILER_RUNTIME_LINUX = "COMPILER/M4CompilerRuntime_Linux.zip";
    private static String COMPILER_RUNTIME_UNIX = "COMPILER/M4CompilerRuntime_SunOS.zip";
    private static String COMPILER_RUNTIME_WINDOWS = "COMPILER/M4CompilerRuntime_Windows.zip";
    private static String M4_INSTALLER = "M4/InstallingM4.zip";
    private static String JBOSS = "SYSTEM/jboss-3.0.0-default.zip";
    private static String M4_INTERFACE = "SYSTEM/M4InterfaceServer.jar";
    private final File targetDir;
    private final MainWindow mw;
    private final boolean[] downloadRequests;

    public InstallComponents(File targetDir) throws InstallWizardException {
        if (!targetDir.isDirectory() || !targetDir.exists()) {
            throw new InstallWizardException("Target directory for downloads '" + targetDir.getAbsolutePath() + "' does not exist!");
        }
        this.targetDir = targetDir;
        this.downloadRequests = null;
        this.mw = null;
        this.start();
    }

    public InstallComponents(File targetDir, MainWindow mw, boolean[] downloadRequests) throws InstallWizardException {
        if (!targetDir.isDirectory() || !targetDir.exists()) {
            throw new InstallWizardException("Target directory for downloads '" + targetDir.getAbsolutePath() + "' does not exist!");
        }
        this.targetDir = targetDir;
        this.downloadRequests = downloadRequests;
        this.mw = mw;
        this.start();
    }

    public void run() {
        block10: {
            try {
                if (this.haveToDownload((short)0)) {
                    this.downloadM4Installer();
                }
                if (this.haveToDownload((short)1)) {
                    this.downloadCompiler();
                }
                if (this.haveToDownload((short)2)) {
                    this.downloadJboss();
                }
                if (this.haveToDownload((short)3)) {
                    this.downloadM4Interface();
                }
                if (this.haveToDownload((short)4)) {
                    this.downloadHCI();
                }
                if (this.mw != null) {
                    this.mw.afterInstallingComponents(this.targetDir);
                }
            }
            catch (IOException e) {
                System.err.println("\n*** IOException caught: ***\n" + e.getMessage());
                if (this.mw != null) {
                    this.mw.setButtonsActive();
                }
            }
            catch (InstallWizardException e) {
                System.err.println("\n*** InstallWizardException caught during installation: ***\n" + e.getMessage());
                if (this.mw == null) break block10;
                this.mw.setButtonsActive();
            }
        }
    }

    public boolean haveToDownload(short specification) {
        return this.downloadRequests == null || this.downloadRequests.length <= specification || this.downloadRequests[specification];
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    private void downloadHCI() throws IOException, InstallWizardException {
        String systemTargetDir = this.getTargetDir().getAbsolutePath();
        File hci = new File(String.valueOf(systemTargetDir) + File.separator + "hci.zip");
        this.print("Downloading the main HCI file - ");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + HCI), hci);
        this.print("Unpacking - ");
        new UnZipper(hci, systemTargetDir);
        this.print("Deleting packed file - ");
        hci.delete();
        this.print("Done.\nDownloading additional packages: GraphView.jar - ");
        String lib = String.valueOf(systemTargetDir) + File.separator + "HCI" + File.separator + "lib" + File.separator;
        this.checkDirectoryExistance(lib);
        File graphView = new File(String.valueOf(lib) + "GraphView.jar");
        File hotdraw = new File(String.valueOf(lib) + "hotdraw.jar");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + GRAPH_VIEW), graphView);
        this.print("Hotdraw.jar - ");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + HOTDRAW), hotdraw);
        this.println("Done.");
    }

    private void downloadCompiler() throws IOException, InstallWizardException {
        String systemTargetDir = this.getTargetDir().getAbsolutePath();
        File compiler = new File(String.valueOf(systemTargetDir) + File.separator + "M4CompilerServer.zip");
        this.print("Downloading the main compiler archive - ");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + COMPILER_MAIN), compiler);
        this.print("Unpacking - ");
        new UnZipper(compiler, systemTargetDir);
        this.print("Deleting packed file - ");
        compiler.delete();
        this.println("Done.");
        short os = InstallComponents.getOperatingSystem();
        String runtime = null;
        switch (os) {
            case 1: {
                runtime = String.valueOf(MM_WEBSITE) + COMPILER_RUNTIME_UNIX;
                break;
            }
            case 2: {
                runtime = String.valueOf(MM_WEBSITE) + COMPILER_RUNTIME_LINUX;
                break;
            }
            case 3: {
                runtime = String.valueOf(MM_WEBSITE) + COMPILER_RUNTIME_WINDOWS;
            }
        }
        this.print("Downloading runtime package. - ");
        File runtimeFile = new File(String.valueOf(systemTargetDir) + File.separator + "M4CompilerRuntime.zip");
        new Downloader(new URL(runtime), runtimeFile);
        this.print("Unpacking - ");
        String runtimeSubDir = String.valueOf(systemTargetDir) + File.separator + "compiler" + File.separator + "runtime";
        this.checkDirectoryExistance(runtimeSubDir);
        new UnZipper(runtimeFile, runtimeSubDir);
        this.print("Deleting packed file - ");
        runtimeFile.delete();
        if (os == 2 || os == 1) {
            this.println("Setting executable bits for binaries - ");
            String binFolder = String.valueOf(runtimeSubDir) + File.separator + "bin" + File.separator;
            binFolder = os == 2 ? String.valueOf(binFolder) + "Linux" : String.valueOf(binFolder) + "SunOS";
            ScriptExecuter.setExecBitAllFiles(new File(binFolder));
        }
        this.println("Done.");
    }

    private void downloadM4Installer() throws IOException, InstallWizardException {
        String systemTargetDir = this.getTargetDir().getAbsolutePath();
        File m4inst = new File(String.valueOf(systemTargetDir) + File.separator + "InstallingM4.zip");
        this.print("Downloading the M4 installer scripts - ");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + M4_INSTALLER), m4inst);
        this.print("Unpacking - ");
        File m4dir = new File(String.valueOf(systemTargetDir) + File.separator + "M4Installer");
        if (!m4dir.exists()) {
            m4dir.mkdir();
        } else if (!m4dir.isDirectory()) {
            throw new IOException("Could not create subdirectory " + m4dir.getAbsolutePath() + "!");
        }
        new UnZipper(m4inst, m4dir.getAbsolutePath());
        this.print("Deleting packed file - ");
        m4inst.delete();
        this.println("Done.");
    }

    private void downloadJboss() throws IOException, InstallWizardException {
        String systemTargetDir = this.getTargetDir().getAbsolutePath();
        File jbossInst = new File(String.valueOf(systemTargetDir) + File.separator + "jboss-3.0.0-minimal.zip");
        this.print("Downloading JBOSS 3.0.0 default version - ");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + JBOSS), jbossInst);
        this.print("Unpacking - ");
        new UnZipper(jbossInst, systemTargetDir);
        this.print("Deleting packed file - ");
        jbossInst.delete();
        this.println("Done.");
    }

    private void downloadM4Interface() throws IOException, InstallWizardException {
        String systemTargetDir = this.getTargetDir().getAbsolutePath();
        this.print("Downloading M4Interface - ");
        String deploy = String.valueOf(systemTargetDir) + File.separator + "jboss-3.0.0" + File.separator + "server" + File.separator + "default" + File.separator + "deploy";
        this.checkDirectoryExistance(deploy);
        File m4interfaceInst = new File(String.valueOf(deploy) + File.separator + "M4InterfaceServer.jar");
        new Downloader(new URL(String.valueOf(MM_WEBSITE) + M4_INTERFACE), m4interfaceInst);
        this.println("Done.");
    }

    public static short getOperatingSystem() throws InstallWizardException {
        String prop = System.getProperty("os.name");
        if (prop.equals("SunOS")) {
            return 1;
        }
        if (prop.equals("Linux")) {
            return 2;
        }
        if (prop.substring(0, 3).equalsIgnoreCase("win")) {
            return 3;
        }
        throw new InstallWizardException("No M4Compiler runtime package found for your operating system.\nCurrently supported: SunOS, Linux and Windows.\nYour operating system is: " + System.getProperty("os.name"));
    }

    private void checkDirectoryExistance(String directoryPath) throws InstallWizardException {
        File dirFile = new File(directoryPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            throw new InstallWizardException("Subdirectory '" + dirFile.getAbsolutePath() + "'does not exist!");
        }
    }

    public void print(String s) {
        if (this.mw == null) {
            System.out.print(s);
        } else {
            this.mw.print(s);
        }
    }

    public void println(String s) {
        if (this.mw == null) {
            System.out.println(s);
        } else {
            this.mw.println(s);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Downloading the MiningMart system.");
        new InstallComponents(new File("/home/scholz/opentmp/testdir/"));
        System.out.println("\n\n*** Installed ***");
    }
}

