/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.InstallComponents;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.ConfigReader;
import miningmart.installWizard.utils.SetOfVariableSettings;
import miningmart.installWizard.utils.VariableValue;

public class DatabaseConfigurator
extends Configurator {
    private static final String DBCONFIG = "db.config";
    private static final String DBCONFIG_COMPILER = "compiler" + Configurator.fs + "runtime" + Configurator.fs + "etc";
    private static final String DBCONFIG_HCI = "HCI";
    private static final String M4INSTALL_DIR = "M4Installer";
    private static final String M4INSTALL_SUNOS = "install.sh";
    private static final String M4INSTALL_LINUX = "install.sh";
    private static final String M4INSTALL_WINDOWS = "install.bat";
    private static final String JDBC_FILE = "classes12.zip";
    private static final String JDBC_HCI = "HCI" + Configurator.fs + "lib";
    private static final String JDBC_COMPILER = "compiler" + Configurator.fs + "classes";
    private static final String JDBC_JBOSS = "jboss-3.0.0" + Configurator.fs + "server" + Configurator.fs + "default" + Configurator.fs + "lib";
    private static final String JBOSS_ORACLE_SERVICE = "oracle-service.xml";
    private static final String JBOSS_DEPLOY_DIR = "jboss-3.0.0" + Configurator.fs + "server" + Configurator.fs + "default" + Configurator.fs + "deploy";
    private static final String JBOSS_ORACLE_SERV_EXAMPLE = "jboss-3.0.0" + Configurator.fs + "docs" + Configurator.fs + "examples" + Configurator.fs + "jca";
    private static final String JNDI_START_TAG = "<attribute name=\"JndiName\">";
    private static final String JNDI_CLOSE_TAG = "</attribute>";
    private static final String CONNECT_START_TAG = "<config-property name=\"ConnectionURL\" type=\"java.lang.String\">";
    private static final String CONNECT_CLOSE_TAG = "</config-property>";
    private static final String USER_START_TAG = "<config-property name=\"UserName\" type=\"java.lang.String\">";
    private static final String USER_CLOSE_TAG = "</config-property>";
    private static final String PASSWORD_START_TAG = "<config-property name=\"Password\" type=\"java.lang.String\">";
    private static final String PASSWORD_CLOSE_TAG = "</config-property>";
    private static final String CONNECTION_URL = "MiningMartDB";
    public static final String M4_DATABASE_NAME = "m4DBName";
    public static final String BD_DATABASE_NAME = "dataDbname";
    public static final String M4_DATABASE_HOST = "M4HOST";
    public static final String BD_DATABASE_HOST = "BDHOST";
    public static final String M4_USER = "M4USER";
    public static final String BD_USER = "BDUSER";
    public static final String M4_PASSWORD = "M4PASS";
    public static final String BD_PASSWORD = "BDPASS";
    public static final String M4_JDBC_DRIVER = "m4DataDriver";
    public static final String BD_JDBC_DRIVER = "dataDriver";
    public static final String SQLPLUS = "SQL_PLUS";
    public static final String LOADJAVA = "LOAD_JAVA";
    public static final String JDBC_ZIP_LOCATION = "JDBC_Location";
    public static final String M4_HOST_ONLY = "M4SID";
    public static final String BD_HOST_ONLY = "BDSID";
    private static final String[] dbConfigVars;
    private static final String[] M4InstallVars;

    static {
        String[] stringArray = new String[11];
        stringArray[0] = M4_DATABASE_NAME;
        stringArray[1] = M4_USER;
        stringArray[2] = M4_PASSWORD;
        stringArray[3] = M4_JDBC_DRIVER;
        stringArray[4] = M4_DATABASE_HOST;
        stringArray[6] = BD_DATABASE_NAME;
        stringArray[7] = BD_USER;
        stringArray[8] = BD_PASSWORD;
        stringArray[9] = BD_JDBC_DRIVER;
        stringArray[10] = BD_DATABASE_HOST;
        dbConfigVars = stringArray;
        M4InstallVars = new String[]{M4_USER, M4_PASSWORD, M4_HOST_ONLY, BD_USER, BD_PASSWORD, BD_HOST_ONLY, SQLPLUS, LOADJAVA};
    }

    public DatabaseConfigurator(File miningMartHome, MainWindow mw) throws InstallWizardException, IOException {
        super(miningMartHome, mw);
    }

    protected void initVariables() throws IOException, InstallWizardException {
        this.readSetOfDBCVariables();
        this.findJdbcFile();
        this.readM4InstallVars();
    }

    private void readSetOfDBCVariables() throws IOException {
        File dbconfig = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + DBCONFIG_COMPILER + Configurator.fs + DBCONFIG);
        short typeOfFile = 3;
        if (!dbconfig.exists()) {
            dbconfig = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + DBCONFIG_HCI + Configurator.fs + DBCONFIG);
        }
        ConfigReader dbConfigReader = dbconfig.exists() ? new ConfigReader(dbconfig.getAbsolutePath(), typeOfFile) : null;
        try {
            this.addDBCToSet(dbConfigReader);
        }
        catch (InstallWizardException installWizardException) {
            // empty catch block
        }
        if (dbConfigReader != null) {
            dbConfigReader.close();
        }
    }

    private void addDBCToSet(ConfigReader cr) throws IOException, InstallWizardException {
        if (cr == null) {
            throw new InstallWizardException("No db.config file found.");
        }
        SetOfVariableSettings theSet = this.getTheSettings();
        theSet.clear();
        int i = 0;
        while (i < dbConfigVars.length) {
            String name = dbConfigVars[i];
            if (!cr.hasMoreLines()) {
                throw new InstallWizardException("db.config file too short. EOF when trying to read variable '" + name + "'!");
            }
            String value = cr.getLine();
            if (name != null) {
                VariableValue vv = VariableValue.createVariableValue(name, value);
                theSet.addVariableValue(vv);
            }
            ++i;
        }
    }

    private void findJdbcFile() {
        SetOfVariableSettings theSet = this.getTheSettings();
        File jdbc = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_COMPILER + Configurator.fs + JDBC_FILE);
        if (!(jdbc.exists() || (jdbc = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_HCI + Configurator.fs + JDBC_FILE)).exists() || (jdbc = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_JBOSS + Configurator.fs + JDBC_FILE)).exists())) {
            jdbc = null;
        }
        VariableValue vv = VariableValue.createVariableValue(JDBC_ZIP_LOCATION, jdbc == null ? null : jdbc.getAbsolutePath());
        theSet.addVariableValue(vv);
    }

    private void readM4InstallVars() throws IOException, InstallWizardException {
        File file = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + M4INSTALL_DIR + Configurator.fs + this.getInstallFileName());
        if (!file.exists()) {
            throw new InstallWizardException("DatabaseConfigurator.readM4InstallVars() : No M4Installer script found.");
        }
        short typeOfFile = 1;
        if (InstallComponents.getOperatingSystem() == 3) {
            typeOfFile = 2;
        }
        ConfigReader cr = new ConfigReader(file.getAbsolutePath(), typeOfFile);
        SetOfVariableSettings theSet = this.getTheSettings();
        block0: while (cr.hasMoreLines()) {
            VariableValue vv = cr.getNextVariableAssignment();
            if (vv == null) break;
            int i = 0;
            while (i < M4InstallVars.length) {
                String name = M4InstallVars[i];
                if (vv.getVariableName().equals(name)) {
                    theSet.addVariableValue(vv);
                    continue block0;
                }
                ++i;
            }
        }
        cr.close();
    }

    public void save() throws IOException, InstallWizardException {
        super.save();
        this.writeDbConfig(new File(String.valueOf(this.getHomeDir()) + Configurator.fs + DBCONFIG_COMPILER + Configurator.fs + DBCONFIG));
        this.writeDbConfig(new File(String.valueOf(this.getHomeDir()) + Configurator.fs + DBCONFIG_HCI + Configurator.fs + DBCONFIG));
        this.adaptM4InstallScript();
        this.adaptJbossOracleFile();
        this.cloneJdbcDrivers();
    }

    private void writeDbConfig(File file) throws IOException {
        this.println("Saving configuration file " + file.getAbsolutePath());
        this.makeBackupFile(file);
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        int i = 0;
        while (i < dbConfigVars.length) {
            String var = dbConfigVars[i];
            if (var == null) {
                ps.println();
            } else {
                String value = this.getTheSettings().getVariableValue(var);
                ps.println(value);
            }
            ++i;
        }
        ps.close();
    }

    private void cloneJdbcDrivers() throws IOException {
        String jdbcLocation = this.getTheSettings().getVariableValue(JDBC_ZIP_LOCATION);
        if (jdbcLocation != null && jdbcLocation.trim().length() > 0) {
            File jdbc = new File(jdbcLocation);
            if (jdbc.exists() && jdbc.isFile()) {
                this.copyFileTo(jdbc, new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_COMPILER));
                this.copyFileTo(jdbc, new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_HCI));
                this.copyFileTo(jdbc, new File(String.valueOf(this.getHomeDir()) + Configurator.fs + JDBC_JBOSS));
            } else {
                this.println("Warning: No JDBC driver file found!");
            }
        } else {
            this.println("No JDBC driver found.");
        }
    }

    private void adaptM4InstallScript() throws InstallWizardException, IOException {
        short os = InstallComponents.getOperatingSystem();
        short typeOfFile = 1;
        if (os == 3) {
            typeOfFile = 2;
        }
        File file = new File(String.valueOf(this.getHomeDir()) + Configurator.fs + M4INSTALL_DIR + Configurator.fs + this.getInstallFileName());
        this.println("Saving configuration file " + file.getAbsolutePath());
        File backup = this.makeBackupFile(file);
        if (backup == null) {
            throw new InstallWizardException("Error in DatabaseConfigurator.adaptM4InstallScript: File " + file.getAbsolutePath() + " does not exist!");
        }
        ConfigReader cr = new ConfigReader(backup.getAbsolutePath(), typeOfFile);
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        while (cr.hasMoreLines()) {
            String line = cr.getLine();
            VariableValue vv = cr.getVariableAssignment(line);
            if (vv != null) {
                int i = 0;
                while (i < M4InstallVars.length) {
                    String var = M4InstallVars[i];
                    if (vv.getVariableName().equals(var)) {
                        String newValue = this.getTheSettings().getVariableValue(var);
                        if (var.equals(M4_PASSWORD) || var.equals(BD_PASSWORD)) {
                            newValue = "\"" + newValue + "\"";
                        }
                        line = this.replaceAssignment(newValue, line);
                        break;
                    }
                    ++i;
                }
            }
            ps.println(line);
        }
        cr.close();
        ps.close();
    }

    private String getInstallFileName() {
        try {
            short os = InstallComponents.getOperatingSystem();
            switch (os) {
                case 1: {
                    return "install.sh";
                }
                case 2: {
                    return "install.sh";
                }
                case 3: {
                    return M4INSTALL_WINDOWS;
                }
            }
            return null;
        }
        catch (InstallWizardException e) {
            return null;
        }
    }

    private void adaptJbossOracleFile() throws IOException {
        String xml;
        String deployPath = String.valueOf(this.getHomeDir()) + Configurator.fs + JBOSS_DEPLOY_DIR;
        File targetFile = new File(String.valueOf(deployPath) + Configurator.fs + JBOSS_ORACLE_SERVICE);
        if (!targetFile.exists()) {
            String example = String.valueOf(this.getHomeDir()) + Configurator.fs + JBOSS_ORACLE_SERV_EXAMPLE + Configurator.fs + JBOSS_ORACLE_SERVICE;
            File exampleFile = new File(example);
            this.copyFileTo(exampleFile, new File(deployPath));
            xml = this.fileToString(targetFile);
        } else {
            xml = this.fileToString(targetFile);
            this.makeBackupFile(targetFile);
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(targetFile));
        SetOfVariableSettings theSet = this.getTheSettings();
        String driver = theSet.getVariableValue(M4_JDBC_DRIVER);
        String host = theSet.getVariableValue(M4_DATABASE_HOST);
        String sid = theSet.getVariableValue(M4_DATABASE_NAME);
        String connectString = "";
        if (driver != null && host != null && sid != null) {
            connectString = String.valueOf(driver) + host + sid;
        }
        String user = theSet.getVariableValue(M4_USER);
        String pass = theSet.getVariableValue(M4_PASSWORD);
        try {
            xml = this.changeVarInXml(xml, JNDI_START_TAG, JNDI_CLOSE_TAG, CONNECTION_URL, out);
            xml = this.changeVarInXml(xml, CONNECT_START_TAG, "</config-property>", connectString, out);
            xml = this.changeVarInXml(xml, USER_START_TAG, "</config-property>", user, out);
            xml = this.changeVarInXml(xml, PASSWORD_START_TAG, "</config-property>", pass, out);
            out.write(xml);
        }
        catch (InstallWizardException e) {
            this.println("Warning: File " + targetFile.getAbsolutePath() + " is corrupt!");
            this.println("Error when trying to change variable settings:\n" + e.getMessage());
        }
        out.close();
    }
}

