/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.File;
import java.io.IOException;
import miningmart.installWizard.ConfigWindow;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.DatabaseConfigurator;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.PortsFilesWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.SetOfVariableSettings;
import miningmart.installWizard.utils.VariableValue;

public class DatabaseConfigWindow
extends ConfigWindow {
    private static final String DATABASE_HOST = "db_host";
    private static final String DATABASE_PORT = "db_port";
    private static final String[][] mapping;

    static {
        String[][] stringArrayArray = new String[13][];
        stringArrayArray[0] = new String[]{"JDBC_Location", "Location of Oracle JDBC driver file (e.g. \"classes12.zip\")", "*** enter path to ORACLE's JDBC file classes12.zip ***", "", ConfigWindow.MAPPING_VALUE_NO};
        stringArrayArray[1] = new String[]{"SQL_PLUS", "Location of SQLplus executable (part of ORACLE)", "sqlplus", "", ConfigWindow.MAPPING_VALUE_NO};
        stringArrayArray[2] = new String[]{"LOAD_JAVA", "Location of the loadjava command (part of Oracle)", "loadjava", "", ConfigWindow.MAPPING_VALUE_NO};
        String[] stringArray = new String[5];
        stringArray[1] = "";
        stringArrayArray[3] = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = "m4DBName";
        stringArray2[1] = "Name of your database (SID):";
        stringArray2[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray2[4] = ConfigWindow.MAPPING_VALUE_NO;
        stringArrayArray[4] = stringArray2;
        stringArrayArray[5] = new String[]{"m4DataDriver", "JDBC driver:", "jdbc:oracle:thin", ConfigWindow.MAPPING_VALUE_NO, ConfigWindow.MAPPING_VALUE_NO};
        String[] stringArray3 = new String[5];
        stringArray3[0] = DATABASE_HOST;
        stringArray3[1] = "Host of your database:";
        stringArray3[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray3[4] = ConfigWindow.MAPPING_VALUE_NO;
        stringArrayArray[6] = stringArray3;
        stringArrayArray[7] = new String[]{DATABASE_PORT, "Port of your database:", "1521", ConfigWindow.MAPPING_VALUE_NO, ConfigWindow.MAPPING_VALUE_NO};
        String[] stringArray4 = new String[5];
        stringArray4[1] = "";
        stringArrayArray[8] = stringArray4;
        String[] stringArray5 = new String[5];
        stringArray5[0] = "M4USER";
        stringArray5[1] = "User of the M4 schema:";
        stringArray5[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray5[4] = ConfigWindow.MAPPING_VALUE_NO;
        stringArrayArray[9] = stringArray5;
        String[] stringArray6 = new String[5];
        stringArray6[0] = "BDUSER";
        stringArray6[1] = "User of business schema:";
        stringArray6[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray6[4] = ConfigWindow.MAPPING_VALUE_NO;
        stringArrayArray[10] = stringArray6;
        String[] stringArray7 = new String[5];
        stringArray7[0] = "M4PASS";
        stringArray7[1] = "Password of the M4 schema:";
        stringArray7[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray7[4] = "";
        stringArrayArray[11] = stringArray7;
        String[] stringArray8 = new String[5];
        stringArray8[0] = "BDPASS";
        stringArray8[1] = "Password of the business schema:";
        stringArray8[3] = ConfigWindow.MAPPING_VALUE_NO;
        stringArray8[4] = "";
        stringArrayArray[12] = stringArray8;
        mapping = stringArrayArray;
    }

    public DatabaseConfigWindow(File miningMartHome, MainWindow mw) throws IOException, InstallWizardException {
        super(miningMartHome, mw);
    }

    protected Configurator createConfigurator(File miningMartHome, MainWindow mw) throws IOException, InstallWizardException {
        return new DatabaseConfigurator(miningMartHome, mw);
    }

    protected String[][] getMapping() {
        return mapping;
    }

    protected void mapVariableValuesToGui() {
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String hostAndPort = theSet.getVariableValue("M4HOST");
        if (hostAndPort != null && hostAndPort.length() > 0) {
            String port;
            String host;
            int index = hostAndPort.indexOf(":");
            if (index == -1) {
                host = hostAndPort;
                port = "";
            } else {
                host = hostAndPort.substring(0, index).trim();
                port = hostAndPort.substring(index + 1).trim();
            }
            if (host.startsWith("@")) {
                host = host.substring(1);
            }
            if (port.endsWith(":")) {
                port = port.substring(0, port.length() - 1);
            }
            theSet.addVariableValue(VariableValue.createVariableValue(DATABASE_HOST, host));
            theSet.addVariableValue(VariableValue.createVariableValue(DATABASE_PORT, port));
        }
        this.unQuoteVariable("M4PASS");
        this.unQuoteVariable("BDPASS");
        String jdbcDriver = theSet.getVariableValue("m4DataDriver");
        if (jdbcDriver != null && jdbcDriver.endsWith(":")) {
            jdbcDriver = jdbcDriver.substring(0, jdbcDriver.length() - 1);
            theSet.addVariableValue(VariableValue.createVariableValue("m4DataDriver", jdbcDriver));
        }
    }

    protected void mapGuiValuesToVariables() {
        String jdbcDriver;
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String host = theSet.getVariableValue(DATABASE_HOST);
        String port = theSet.getVariableValue(DATABASE_PORT);
        if (host != null) {
            String value = host.trim();
            theSet.addVariableValue(VariableValue.createVariableValue("M4SID", value));
            this.copyVariableValue("M4SID", "BDSID");
            if (!value.startsWith("@")) {
                value = "@" + value;
            }
            if (port != null) {
                value = (port = port.trim()).startsWith(":") ? String.valueOf(value) + port : String.valueOf(value) + ":" + port;
            }
            if (!value.endsWith(":")) {
                value = String.valueOf(value) + ":";
            }
            theSet.addVariableValue(VariableValue.createVariableValue("M4HOST", value));
        }
        if ((jdbcDriver = theSet.getVariableValue("m4DataDriver")) != null) {
            if (!(jdbcDriver = jdbcDriver.trim()).trim().endsWith(":")) {
                jdbcDriver = String.valueOf(jdbcDriver.trim()) + ":";
            }
            theSet.addVariableValue(VariableValue.createVariableValue("m4DataDriver", jdbcDriver));
        }
        this.copyVariableValue("m4DataDriver", "dataDriver");
        this.copyVariableValue("m4DBName", "dataDbname");
        this.copyVariableValue("M4HOST", "BDHOST");
    }

    protected void editNextFile() throws InstallWizardException, IOException {
        File homeDir = new File(this.getConfigurator().getHomeDir());
        PortsFilesWindow cw = new PortsFilesWindow(homeDir, this.mainWindow);
        this.mainWindow.switchToConfigWindow(cw);
    }
}

