/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import miningmart.installWizard.InstallComponents;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.SetOfVariableSettings;

public abstract class Configurator {
    public static final String fs = File.separator;
    private static final String SUNOS_SCRIPT_SUFFIX = ".sh";
    private static final String LINUX_SCRIPT_SUFFIX = ".sh";
    private static final String WINDOWS_SCRIPT_SUFFIX = ".bat";
    private final SetOfVariableSettings theSettings = new SetOfVariableSettings();
    private final String homeDir;
    private final MainWindow mainWindow;

    public Configurator(File miningMartHome, MainWindow mw) throws InstallWizardException, IOException {
        if (miningMartHome == null || !miningMartHome.exists() || !miningMartHome.isDirectory()) {
            new InstallWizardException("Error initializing DatabaseConfigurator: Parameter MiningMart home is <null> or does not exist!");
        }
        this.homeDir = miningMartHome.getAbsolutePath();
        this.mainWindow = mw;
        this.initVariables();
    }

    protected abstract void initVariables() throws IOException, InstallWizardException;

    public final SetOfVariableSettings getTheSettings() {
        return this.theSettings;
    }

    public final String getHomeDir() {
        return this.homeDir;
    }

    public static String getScriptFileSuffix() {
        try {
            short os = InstallComponents.getOperatingSystem();
            switch (os) {
                case 1: {
                    return ".sh";
                }
                case 2: {
                    return ".sh";
                }
                case 3: {
                    return WINDOWS_SCRIPT_SUFFIX;
                }
            }
            return null;
        }
        catch (InstallWizardException e) {
            return null;
        }
    }

    public void save() throws IOException, InstallWizardException {
        this.println("Save settings:");
    }

    protected String replaceAssignment(String newValue, String line) {
        int index = line.indexOf(61);
        if (index != -1) {
            line = String.valueOf(line.substring(0, index + 1)) + (newValue == null ? "" : newValue);
        }
        return line;
    }

    protected String changeVarInXml(String xml, String startTag, String endTag, String value, BufferedWriter out) throws InstallWizardException, IOException {
        int index = xml.indexOf(startTag);
        if (index != -1) {
            out.write(xml.substring(0, index += startTag.length()));
            if (value != null) {
                out.write(value);
            }
            if ((index = xml.indexOf(endTag, index)) != -1) {
                out.write(endTag);
                return xml.substring(index += endTag.length());
            }
        }
        throw new InstallWizardException("Error when trying to change variable settings in XML file.startTag was: " + startTag + "\nendTag was:" + endTag);
    }

    protected String fileToString(File file) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer buffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buffer.append(String.valueOf(line) + "\n");
        }
        in.close();
        return buffer.toString();
    }

    protected File makeBackupFile(File file) {
        if (file.exists()) {
            boolean success;
            File backup = new File(String.valueOf(file.getAbsolutePath()) + ".old");
            if (backup.exists()) {
                backup.delete();
            }
            if (success = file.renameTo(backup)) {
                return backup;
            }
        }
        return null;
    }

    protected void copyFileTo(File source, File targetDir) throws IOException {
        if (!(source != null && targetDir != null && source.exists() && targetDir.exists() && targetDir.isDirectory())) {
            throw new IOException("Could not copy from " + (source == null ? "<null>" : source.getAbsolutePath()) + " to " + (targetDir == null ? "<null>" : targetDir.getAbsolutePath()));
        }
        String srcPath = source.getCanonicalPath();
        int index = srcPath.lastIndexOf(File.separator);
        if (index == -1) {
            throw new IOException("Could not extract file name from file " + srcPath + ".");
        }
        String targetPath = String.valueOf(targetDir.getCanonicalPath()) + srcPath.substring(index);
        if (srcPath.equals(targetPath)) {
            return;
        }
        File targetFile = new File(targetPath);
        this.copyFileToFile(source, targetFile);
    }

    protected void copyFileToFile(File source, File target) throws IOException {
        if (target.exists()) {
            this.println("File " + target.getAbsolutePath() + " exists.");
            return;
        }
        this.println("Copying file from " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            byte[] buffer = new byte[32768];
            int num = 0;
            do {
                if ((num = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, num);
            } while (num > -1);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            in.close();
            out.close();
            throw throwable;
        }
        Object var8_9 = null;
        in.close();
        out.close();
    }

    public void print(String s) {
        if (this.mainWindow == null) {
            System.out.print(s);
        } else {
            this.mainWindow.print(s);
        }
    }

    public void println(String s) {
        if (this.mainWindow == null) {
            System.out.println(s);
        } else {
            this.mainWindow.println(s);
        }
    }
}

