/*
 * Decompiled with CFR 0.152.
 */
package miningmart.installWizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import miningmart.installWizard.Configurator;
import miningmart.installWizard.MainWindow;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.installWizard.utils.SetOfVariableSettings;
import miningmart.installWizard.utils.VariableValue;

public abstract class ConfigWindow {
    private JPanel panel;
    private final SetOfVariableSettings variablesToEdit;
    private final Configurator configurator;
    protected final MainWindow mainWindow;
    public static final short MAPPING_ORIGINAL_VARIABLE = 0;
    public static final short MAPPING_GUI_VARIABLE = 1;
    public static final short MAPPING_DEFAULT_VALUE = 2;
    public static final short MAPPING_NEEDS_FILEDIALOG = 3;
    public static final short MAPPING_IS_PASSWORD = 4;
    public static final String MAPPING_VALUE_YES = "";
    public static final String MAPPING_VALUE_NO = null;
    private JTextField[] theGuiValues = new JTextField[this.getMappingLength()];

    public ConfigWindow(File miningMartHome, MainWindow mw) throws IOException, InstallWizardException {
        this.configurator = this.createConfigurator(miningMartHome, mw);
        this.mainWindow = mw;
        this.variablesToEdit = this.configurator.getTheSettings();
        this.mapVariableValuesToGui();
        this.prepareWindow();
    }

    protected abstract Configurator createConfigurator(File var1, MainWindow var2) throws IOException, InstallWizardException;

    protected abstract String[][] getMapping();

    protected abstract void editNextFile() throws IOException, InstallWizardException;

    public SetOfVariableSettings getSetOfVariables() {
        return this.variablesToEdit;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public String[] getMapping(int i) {
        String[][] mapping = this.getMapping();
        if (mapping != null && i >= 0 && i < mapping.length) {
            return mapping[i];
        }
        return null;
    }

    public int getMappingLength() {
        String[][] mapping = this.getMapping();
        if (mapping != null) {
            return mapping.length;
        }
        return 0;
    }

    public JPanel getRootPanel() {
        return this.panel;
    }

    protected abstract void mapVariableValuesToGui();

    protected abstract void mapGuiValuesToVariables();

    public void quoteVariable(String variableName) {
        if (variableName == null) {
            return;
        }
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String value = theSet.getVariableValue(variableName);
        if (value == null) {
            return;
        }
        value = "\"" + value + "\"";
        theSet.addVariableValue(VariableValue.createVariableValue(variableName, value));
    }

    public void unQuoteVariable(String variableName) {
        if (variableName == null) {
            return;
        }
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String value = theSet.getVariableValue(variableName);
        if (value == null) {
            return;
        }
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        theSet.addVariableValue(VariableValue.createVariableValue(variableName, value));
    }

    public void copyVariableValue(String srcVarName, String targetVarName) {
        if (srcVarName == null || targetVarName == null) {
            return;
        }
        SetOfVariableSettings theSet = this.getSetOfVariables();
        String value = theSet.getVariableValue(srcVarName);
        VariableValue vv = VariableValue.createVariableValue(targetVarName, value);
        theSet.addVariableValue(vv);
    }

    public String variableNameMapping(String name) throws InstallWizardException {
        if (name != null) {
            int i = 0;
            while (i < this.getMappingLength()) {
                String[] mapped = this.getMapping(i);
                if (name.equals(mapped[1])) {
                    return mapped[0];
                }
                ++i;
            }
        }
        throw new InstallWizardException("DatabaseConfigWindow: Could not find variable " + (name == null ? "<null>" : name) + " in mapping.");
    }

    public JPanel prepareWindow() throws IOException {
        SetOfVariableSettings theSet = this.getSetOfVariables();
        JPanel theFields = new JPanel();
        JPanel theNames = new JPanel();
        JPanel theValues = new JPanel();
        JPanel theFileDialogs = new JPanel();
        theNames.setLayout(new GridLayout(this.getMappingLength(), 1));
        theValues.setLayout(new GridLayout(this.getMappingLength(), 1));
        theFileDialogs.setLayout(new GridLayout(this.getMappingLength(), 1));
        int i = 0;
        while (i < this.getMappingLength()) {
            JComponent comp;
            JTextField valueTa;
            String[] currentMapping = this.getMapping(i);
            String name = currentMapping[1];
            if (currentMapping[0] != null) {
                JTextField nameTa = new JTextField(name);
                nameTa.setEditable(false);
                theNames.add(nameTa);
                String value = theSet.getVariableValue(currentMapping[0]);
                if ((value == null || value.length() == 0) && (value = currentMapping[2]) == null) {
                    value = MAPPING_VALUE_YES;
                }
                valueTa = currentMapping[4] == MAPPING_VALUE_NO ? new JTextField(value, 40) : new JPasswordField(value, 40);
                valueTa.setEditable(true);
                theValues.add(valueTa);
            } else {
                theNames.add(new JPanel());
                theValues.add(new JPanel());
                valueTa = new JTextField(MAPPING_VALUE_YES, 40);
            }
            this.theGuiValues[i] = valueTa;
            if (currentMapping[3] == MAPPING_VALUE_YES) {
                JButton b = new JButton("Browse");
                b.setName(currentMapping[0]);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ConfigWindow.this.browseButtonAction(e);
                    }
                });
                comp = b;
            } else {
                comp = new JPanel();
            }
            theFileDialogs.add(comp);
            ++i;
        }
        theFields.setLayout(new BorderLayout());
        theFields.add((Component)theNames, "West");
        theFields.add((Component)theValues, "Center");
        theFields.add((Component)theFileDialogs, "East");
        JPanel theButtons = new JPanel();
        theButtons.setLayout(new BorderLayout());
        JPanel center = new JPanel(new GridLayout(1, 2));
        JButton saveButton = new JButton("Continue");
        JButton cancelButton = new JButton("Cancel");
        center.add(saveButton);
        center.add(cancelButton);
        theButtons.add((Component)center, "Center");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.saveButtonAction();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.cancelButtonAction();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)theFields, "North");
        panel.add((Component)theButtons, "South");
        this.panel = panel;
        return this.panel;
    }

    protected void saveButtonAction() {
        if (this.mainWindow != null && this.mainWindow.setButtonsInactive()) {
            int i = 0;
            while (i < this.getMappingLength()) {
                String[] nameMapping = this.getMapping(i);
                if (nameMapping != null) {
                    String name = nameMapping[0];
                    String value = this.theGuiValues[i].getText();
                    VariableValue vv = VariableValue.createVariableValue(name, value);
                    this.getSetOfVariables().addVariableValue(vv);
                }
                ++i;
            }
            this.mapGuiValuesToVariables();
            Thread t = new Thread(){

                public void run() {
                    try {
                        ConfigWindow.this.configurator.save();
                        ConfigWindow.this.println("\n--- Successfully saved configuration files. ---\n");
                    }
                    catch (Exception e) {
                        ConfigWindow.this.println("\n*** Exception caught while saving config files: ***");
                        ConfigWindow.this.println(e.getMessage());
                    }
                    try {
                        ConfigWindow.this.editNextFile();
                    }
                    catch (Exception e) {
                        ConfigWindow.this.println("\n*** Exception caught while switching to next editor window: ***");
                        ConfigWindow.this.println(e.getMessage());
                    }
                    ConfigWindow.this.mainWindow.setButtonsActive();
                }
            };
            t.start();
        }
    }

    private void cancelButtonAction() {
        this.dispose();
    }

    private void browseButtonAction(ActionEvent e) {
        if (this.mainWindow != null && this.mainWindow.setButtonsInactive()) {
            block8: {
                JButton b = (JButton)e.getSource();
                String variable = b.getName();
                if (variable == null) {
                    this.println("Error: No variable set for FileDialog!");
                    return;
                }
                JFileChooser fd = new JFileChooser();
                fd.showOpenDialog(this.mainWindow);
                File file = null;
                file = fd.getSelectedFile();
                if (file != null) {
                    String fileCanonical = null;
                    try {
                        fileCanonical = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (file.exists() && file.isFile() && fileCanonical != null) {
                        int i = 0;
                        while (i < this.getMappingLength()) {
                            String mapVar = this.getMapping(i)[0];
                            if (mapVar == variable) {
                                this.theGuiValues[i].setText(fileCanonical);
                                break block8;
                            }
                            ++i;
                        }
                        this.println("Error: Could not find variable " + variable + " to store return value of FileDialog!");
                    }
                }
            }
            this.mainWindow.setButtonsActive();
        }
    }

    public void print(String s) {
        if (this.mainWindow == null) {
            System.out.print(s);
        } else {
            this.mainWindow.print(s);
        }
    }

    public void println(String s) {
        if (this.mainWindow == null) {
            System.out.println(s);
        } else {
            this.mainWindow.println(s);
        }
    }

    private void dispose() {
        if (this.mainWindow != null) {
            this.mainWindow.cancelButtonAction();
        }
    }
}

