/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import miningmart.installWizard.exceptions.InstallWizardException;
import miningmart.systemControl.MainWindow;

public class Main
extends Frame {
    private final WindowAdapter reshow = new WindowAdapter(){

        public void windowClosed(WindowEvent e) {
            Main.this.show();
        }
    };

    public Main() {
        this.setLayout(new GridLayout(2, 1));
        JButton button = new JButton("Download, edit system settings");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.downloader();
            }
        });
        this.add(button);
        button = new JButton("Start the system");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.systemController();
            }
        });
        this.add(button);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(-1);
            }
        });
        this.pack();
        this.show();
    }

    private void downloader() {
        this.hide();
        miningmart.installWizard.MainWindow f = new miningmart.installWizard.MainWindow();
        f.addWindowListener(this.reshow);
    }

    private void systemController() {
        File sysPath = new File("properties");
        boolean run = false;
        if (sysPath.exists() && sysPath.isFile()) {
            try {
                File dir;
                String line;
                LineNumberReader in = new LineNumberReader(new FileReader(sysPath));
                String homeDir = null;
                while ((line = in.readLine()) != null) {
                    int index = line.indexOf(61);
                    if (index == -1 || !line.substring(0, index).trim().equals("MM_HOME")) continue;
                    homeDir = line.substring(index + 1).trim();
                    break;
                }
                in.close();
                if (homeDir != null && (dir = new File(homeDir)).exists() && dir.isDirectory()) {
                    try {
                        this.hide();
                        MainWindow f = new MainWindow(homeDir);
                        f.addWindowListener(this.reshow);
                        run = true;
                    }
                    catch (InstallWizardException e) {
                        e.printStackTrace();
                        this.show();
                    }
                }
            }
            catch (IOException in) {
                // empty catch block
            }
        }
        if (!run) {
            JDialog dialog = new JDialog((Frame)this, "Error");
            dialog.getContentPane().add(new JTextField("Could not run the system controller. Please start the download/setup agent!"));
            dialog.pack();
            dialog.show();
        }
    }

    public static void main(String[] args) {
        new Main();
    }
}

