/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.m4.ejb;

import com.syllogic.j2ee.ejb.DBBeanBase;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import miningmart.m4.value.ConceptV;

public class ConceptsEJB
extends DBBeanBase
implements SessionBean {
    private SessionContext ctx;
    private static String DB_REF = "MiningMartDB";
    public static final String SELECT_NEXTID = "SELECT all_sq.nextval FROM dual";
    public static final String SELECT_COLS = "con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid";
    public static final String SELECT_REC = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t, case_t ca WHERE(con_id=? AND con_caid=ca.ca_id)";
    public static final String CREATE_REC = "INSERT INTO concept_t(con_id,con_name,con_caid,con_type,con_subconrestr) VALUES(?,?,?,?,?)";
    public static final String UPDATE_REC = "UPDATE concept_t SET con_name=?,con_type=?,con_subconrestr=? WHERE con_id=?";
    public static final String DELETE_REC = "DELETE FROM concept_t WHERE con_id=?";
    public static final String SELECT_REC_BY_PARENTCONCEPT = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t c, case_t ca, conceptisa_t x WHERE c.con_caid=ca.ca_id AND (x.cisa_superconid=?)AND(x.cisa_subconid=c.con_id)";
    public static final String SELECT_REC_BY_CHILDCONCEPT = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t c, case_t ca, conceptisa_t x WHERE c.con_caid=ca.ca_id AND (x.cisa_subconid=?)AND(x.cisa_superconid=c.con_id)";
    public static final String SELECT_REC_BY_PROJSRC = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t c, case_t ca, projection_t x WHERE c.con_caid=ca.ca_id AND (x.pro_fromconid=?)AND(x.pro_toconid=c.con_id)";
    public static final String SELECT_REC_BY_PROJDST = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t c, case_t ca, projection_t x WHERE c.con_caid=ca.ca_id AND (x.pro_toconid=?)AND(x.pro_tfromonid=c.con_id)";
    public static final String SELECT_REC_BY_CASE = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t, case_t ca WHERE(con_caid=?) AND con_caid=ca.ca_id";
    public static final String SELECT_REC_BY_BASEATTR = "SELECT con_id,con_name,ca.ca_id,ca.ca_name,con_type,con_subconrestr,con_valid FROM concept_t c, case_t ca, ba_concept_t x WHERE c.con_caid=ca.ca_id AND (x.bc_baid=?)AND(x.bc_conid=c.con_id)";
    public static final String SELECT_ALL_IDS_BY_CASE = "SELECT con_id, con_name FROM concept_t WHERE(con_caid=?)";
    public static final String ADD_PROJECTION = "INSERT INTO projection_t(pro_id,pro_fromconid, pro_toconid) VALUES(?,?,?)";
    public static final String REM_PROJECTION = "DELETE FROM projection_t WHERE(pro_fromconid=?)AND(pro_toconid=?)";
    public static final String ADD_CHILD_CONCEPT = "INSERT INTO conceptisa_t(cisa_id, cisa_superconid, cisa_subconid) VALUES(?,?,?)";
    public static final String REM_CHILD_CONCEPT = "DELETE FROM conceptisa_t WHERE(cisa_superconid=?)AND(cisa_subconid=?)";
    public static final String ADD_BASE_ATTRIBUTE = "INSERT INTO ba_concept_t(bc_id,bc_conid, bc_baid) VALUES(?,?,?)";
    public static final String REM_BASE_ATTRIBUTE = "DELETE FROM ba_concept_t WHERE(bc_conid=?)AND(bc_baid=?)";
    public static final String SELECT_ID_BY_NAME_AND_CASE = "SELECT con_id FROM concept_t WHERE(con_caid=?)AND(con_name=?)";
    public static final String SELECT_ID_BY_BASEATTRIB = "SELECT bc_conid FROM ba_concept_t WHERE bc_baid=?";
    public static final String SELECT_ID_BY_SUBCON = "SELECT cisa_superconid FROM conceptisa_t WHERE cisa_subconid=?";
    public static final String SELECT_ID_BY_FROMCON_AND_NAME = "SELECT c.con_id FROM concept_t c,projection_t x WHERE(x.pro_fromconid=?)AND(x.pro_toconid=c.con_id)AND(c.con_name=?)";
    public static final String SELECT_ID_BY_FROMCON = "SELECT pro_toconid FROM projection_t WHERE pro_fromconid=?";
    public static final String SELECT_ID_BY_TOCON = "SELECT pro_fromconid FROM projection_t WHERE pro_toconid=?";
    public static final String SELECT_ID_BY_PARENTCON = "SELECT cisa_subconid FROM conceptisa_t WHERE cisa_superconid=?";
    public static final String SELECT_ID_BY_PARENT_AND_NAME = "SELECT c.con_id FROM concept_t c,conceptisa_t x WHERE(x.cisa_superconid=?)AND(x.cisa_subconid=c.con_id)AND(c.con_name=?)";
    public static final String SELECT_ID_BY_CASE = "SELECT con_id FROM concept_t WHERE con_caid=?";
    public static final String SELECT_ID_BY_CASE_AND_TYPE = "SELECT con_id FROM concept_t WHERE con_caid=?";
    public static final String SELECT_VALIDITY = "SELECT con_valid FROM concept_t WHERE con_id=?";

    public void setSessionContext(SessionContext context) throws RemoteException, EJBException {
        this.ctx = context;
    }

    public void ejbActivate() throws RemoteException, EJBException {
    }

    public void ejbPassivate() throws RemoteException, EJBException {
    }

    public void ejbRemove() throws RemoteException, EJBException {
    }

    public void ejbCreate() throws CreateException, EJBException, RemoteException {
    }

    public int getNewId() throws SQLException {
        try {
            this.prep(SELECT_NEXTID);
            this.execQ();
            if (!this.nextRow()) {
                throw new SQLException("Failed to get next value from all_sq");
            }
            int n = this.getInt(1);
            Object var4_2 = null;
            this.cleanup();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void loadRec(ConceptV rec) throws SQLException {
        rec.setId(this.getInt(1));
        rec.setName(this.getString(2));
        rec.setMmCase(this.getInt(3));
        rec.setMmCaseName(this.getString(4));
        rec.setType(this.getString(5));
        rec.setSubConceptRestriction(this.getString(6));
        rec.setValid(this.getString(7).equals("YES"));
    }

    public ConceptV find(int id) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC);
            this.setInt(1, id);
            this.execQ();
            if (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                ConceptV conceptV = rec;
                Object var5_4 = null;
                this.cleanup();
                return conceptV;
            }
            Object var5_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanup();
            throw throwable;
        }
        return null;
    }

    public int create(ConceptV rec) throws SQLException {
        int id;
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            id = this.getNewId();
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(CREATE_REC);
            this.setInt(1, id);
            this.setString(2, rec.getName());
            this.setIntIf(3, rec.getMmCase(), rec.getMmCaseName() != null);
            this.setString(4, rec.getType());
            this.setString(5, rec.getSubConceptRestriction());
            this.execU();
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return id;
    }

    public void update(ConceptV rec) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(UPDATE_REC);
            this.setString(1, rec.getName());
            this.setString(2, rec.getType());
            this.setString(3, rec.getSubConceptRestriction());
            this.setInt(4, rec.getId());
            this.execU();
            if (this.getNumRows() == 0) {
                throw new SQLException("Data not found");
            }
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void delete(int id) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(DELETE_REC);
            this.setInt(1, id);
            this.execU();
            if (this.getNumRows() == 0) {
                throw new SQLException("Data not found");
            }
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public Boolean getValidity(int id) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_VALIDITY);
            this.setInt(1, id);
            this.execQ();
            if (this.nextRow()) {
                Boolean val;
                Boolean bl = val = new Boolean(this.getString(1).equals("YES"));
                Object var5_4 = null;
                this.cleanup();
                return bl;
            }
            Object var5_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanup();
            throw throwable;
        }
        return null;
    }

    public Collection findByParentConcept(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_PARENTCONCEPT);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public Collection findByChildConcept(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_CHILDCONCEPT);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public Collection findByProjectionSource(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_PROJSRC);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public Collection findByProjectionTarget(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_PROJDST);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public Collection findByCase(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_CASE);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public Collection findByBaseAttribute(int id) throws SQLException {
        ArrayList<ConceptV> result = new ArrayList<ConceptV>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_REC_BY_BASEATTR);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                ConceptV rec = new ConceptV();
                this.loadRec(rec);
                result.add(rec);
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return result;
    }

    public ConceptV find(Integer id) throws SQLException {
        if (id == null) {
            return null;
        }
        return this.find((int)id);
    }

    public Map getNameIdMapByCase(int id) throws SQLException {
        return this.getNameIdMapById((String)DBBeanBase.getEnv(DB_REF), SELECT_ALL_IDS_BY_CASE, id);
    }

    public Map getNameIdMapByCase(Integer id) throws SQLException {
        if (id == null) {
            return null;
        }
        return this.getNameIdMapByCase((int)id);
    }

    public void addProjection(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            int id = this.getNewId();
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(ADD_PROJECTION);
            this.setInt(1, id);
            this.setInt(2, id1);
            this.setInt(3, id2);
            this.execU();
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void removeProjection(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(REM_PROJECTION);
            this.setInt(1, id1);
            this.setInt(2, id2);
            this.execU();
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void addChildConcept(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            int id = this.getNewId();
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(ADD_CHILD_CONCEPT);
            this.setInt(1, id);
            this.setInt(2, id1);
            this.setInt(3, id2);
            this.execU();
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void removeChildConcept(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(REM_CHILD_CONCEPT);
            this.setInt(1, id1);
            this.setInt(2, id2);
            this.execU();
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void addBaseAttribute(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            int id = this.getNewId();
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(ADD_BASE_ATTRIBUTE);
            this.setInt(1, id);
            this.setInt(2, id1);
            this.setInt(3, id2);
            this.execU();
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void removeBaseAttribute(int id1, int id2) throws SQLException {
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(REM_BASE_ATTRIBUTE);
            this.setInt(1, id1);
            this.setInt(2, id2);
            this.execU();
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public Integer getIdByCaseAndName(int id, String name) throws SQLException {
        if (name == null) {
            return null;
        }
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_NAME_AND_CASE);
            this.setInt(1, id);
            this.setString(2, name);
            this.execQ();
            if (this.nextRow()) {
                Integer n = new Integer(this.getInt(1));
                Object var5_4 = null;
                this.cleanup();
                return n;
            }
            Object var5_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanup();
            throw throwable;
        }
        return null;
    }

    public Integer getIdByCaseAndName(Integer id, String name) throws SQLException {
        if (id == null) {
            return null;
        }
        return this.getIdByCaseAndName((int)id, name);
    }

    public Collection getIdByBaseAttribute(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_BASEATTRIB);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdByBaseAttribute(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdByBaseAttribute((int)id);
    }

    public Collection getIdBySubConcept(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_SUBCON);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdBySubConcept(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdBySubConcept((int)id);
    }

    public Integer getIdByFromProjectionAndName(int id, String name) throws SQLException {
        if (name == null) {
            return null;
        }
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_FROMCON_AND_NAME);
            this.setInt(1, id);
            this.setString(2, name);
            this.execQ();
            if (this.nextRow()) {
                Integer n = new Integer(this.getInt(1));
                Object var5_4 = null;
                this.cleanup();
                return n;
            }
            Object var5_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanup();
            throw throwable;
        }
        return null;
    }

    public Integer getIdByFromProjectionAndName(Integer id, String name) throws SQLException {
        if (id == null) {
            return null;
        }
        return this.getIdByFromProjectionAndName((int)id, name);
    }

    public Collection getIdByFromProjection(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_FROMCON);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdByFromProjection(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdByFromProjection((int)id);
    }

    public Collection getIdByToProjection(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_TOCON);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdByToProjection(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdByToProjection((int)id);
    }

    public Collection getIdBySuperConcept(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_PARENTCON);
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdBySuperConcept(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdBySuperConcept((int)id);
    }

    public Integer getIdBySuperConceptAndName(int id, String name) throws SQLException {
        if (name == null) {
            return null;
        }
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep(SELECT_ID_BY_PARENT_AND_NAME);
            this.setInt(1, id);
            this.setString(2, name);
            this.execQ();
            if (this.nextRow()) {
                Integer n = new Integer(this.getInt(1));
                Object var5_4 = null;
                this.cleanup();
                return n;
            }
            Object var5_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanup();
            throw throwable;
        }
        return null;
    }

    public Integer getIdBySuperConceptAndName(Integer id, String name) throws SQLException {
        if (id == null) {
            return null;
        }
        return this.getIdBySuperConceptAndName((int)id, name);
    }

    public Collection getIdByCase(int id) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep("SELECT con_id FROM concept_t WHERE con_caid=?");
            this.setInt(1, id);
            this.execQ();
            while (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var4_3 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdByCase(Integer id) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdByCase((int)id);
    }

    public Collection getIdByCaseAndType(int id, String type) throws SQLException {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            this.open((String)DBBeanBase.getEnv(DB_REF));
            this.prep("SELECT con_id FROM concept_t WHERE con_caid=?");
            this.setInt(1, id);
            this.setString(2, type);
            this.execQ();
            if (this.nextRow()) {
                aList.add(new Integer(this.getInt(1)));
            }
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getIdByCaseAndType(Integer id, String type) throws SQLException {
        if (id == null) {
            return new ArrayList();
        }
        return this.getIdByCaseAndType((int)id, type);
    }
}

