/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.j2ee.ejb;

import com.syllogic.db.QueryManager;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DBBeanBase
implements QueryManager {
    private Connection db = null;
    private PreparedStatement preparedStat = null;
    private Statement stat = null;
    private ResultSet resultSet = null;
    private int numRows;

    private static Connection getDb(String theRef) {
        try {
            InitialContext aContext = new InitialContext();
            DataSource aSource = (DataSource)aContext.lookup(theRef);
            if (aSource != null) {
                // empty if block
            }
            return aSource.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getEnv(String theRef) {
        return "java:/MiningMartDB";
    }

    private void start(String theRef) {
        this.cleanup();
        this.db = DBBeanBase.getDb(theRef);
        if (this.db != null) {
            // empty if block
        }
    }

    public void prep(String theSQL) throws SQLException {
        if (this.preparedStat != null) {
            this.preparedStat.close();
            this.preparedStat = null;
        }
        this.preparedStat = this.db.prepareStatement(theSQL);
        if (this.preparedStat == null) {
            // empty if block
        }
    }

    public void setBlob(int index, Blob data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setClob(int index, Clob data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setDate(int index, Date data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setTime(int index, Date data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setTimestamp(int index, Date data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setFloat(int index, Float data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setFloat(int index, float data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setFloatIf(int index, float data, boolean isNull) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setDouble(int index, Double data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setDouble(int index, double data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setDoubleIf(int index, double data, boolean isNull) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setByte(int index, Byte data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setByte(int index, byte data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setByteIf(int index, byte data, boolean isNull) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setShort(int index, Short data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setShort(int index, short data) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setShortIf(int index, short data, boolean isNull) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setInt(int theParm, int theInt) throws SQLException {
        if (this.preparedStat == null) {
            // empty if block
        }
        this.preparedStat.setInt(theParm, theInt);
    }

    public void setInt(int theParm, Integer theInt) throws SQLException {
        if (this.preparedStat == null) {
            // empty if block
        }
        if (theInt == null) {
            this.preparedStat.setNull(theParm, 4);
        } else {
            this.preparedStat.setInt(theParm, theInt);
        }
    }

    public void setIntIf(int theParm, int theInt, boolean nonNull) throws SQLException {
        if (nonNull) {
            this.preparedStat.setInt(theParm, theInt);
        } else {
            this.preparedStat.setNull(theParm, 4);
        }
    }

    public void setLong(int theParm, long theLong) throws SQLException {
        this.preparedStat.setLong(theParm, theLong);
    }

    public void setLong(int theParm, Long theLong) throws SQLException {
        if (theLong == null) {
            this.preparedStat.setNull(theParm, 4);
        } else {
            this.preparedStat.setLong(theParm, theLong);
        }
    }

    public void setLongIf(int theParm, long theLong, boolean nonNull) throws SQLException {
        if (nonNull) {
            this.preparedStat.setLong(theParm, theLong);
        } else {
            this.preparedStat.setNull(theParm, 4);
        }
    }

    public void setString(int theParm, String theString) throws SQLException {
        if (theString == null) {
            this.preparedStat.setNull(theParm, 12);
        } else {
            this.preparedStat.setString(theParm, theString);
        }
    }

    public void setCString(int theParm, String theString) throws SQLException {
        if (theString == null) {
            this.preparedStat.setNull(theParm, 1);
        } else {
            this.preparedStat.setString(theParm, theString);
        }
    }

    public void setTimestamp(int theParm, Timestamp theTimestamp) throws SQLException {
        if (theTimestamp == null) {
            this.preparedStat.setNull(theParm, 93);
        } else {
            this.preparedStat.setTimestamp(theParm, theTimestamp);
        }
    }

    public void execQ() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.resultSet = this.preparedStat.executeQuery();
    }

    public void execU() throws SQLException {
        this.numRows = this.preparedStat.executeUpdate();
    }

    public void execQ(String theSQL) throws SQLException {
        if (this.stat != null) {
            this.stat.close();
            this.stat = null;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.stat = this.db.createStatement();
        this.resultSet = this.stat.executeQuery(theSQL);
    }

    public void execU(String theSQL) throws SQLException {
        if (this.stat != null) {
            this.stat.close();
            this.stat = null;
        }
        this.stat = this.db.createStatement();
        this.numRows = this.stat.executeUpdate(theSQL);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getColumnCount() throws SQLException {
        int numCols = 0;
        ResultSetMetaData rsmd = this.resultSet.getMetaData();
        numCols = rsmd.getColumnCount();
        return numCols;
    }

    public String getColumnName(int i) throws SQLException {
        String columnName = "";
        ResultSetMetaData rsmd = this.resultSet.getMetaData();
        columnName = rsmd.getColumnName(i);
        return columnName;
    }

    public boolean nextRow() throws SQLException {
        return this.resultSet.next();
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public boolean isNull(int theCol) throws SQLException {
        this.resultSet.getObject(theCol);
        return this.wasNull();
    }

    public int getInt(int theCol) throws SQLException {
        return this.resultSet.getInt(theCol);
    }

    public Integer getIntO(int theCol) throws SQLException {
        Object anObj = this.resultSet.getObject(theCol);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Integer(this.resultSet.getInt(theCol));
    }

    public long getLong(int theCol) throws SQLException {
        return this.resultSet.getLong(theCol);
    }

    public Long getLongO(int theCol) throws SQLException {
        Object anObj = this.resultSet.getObject(theCol);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Long(this.resultSet.getLong(theCol));
    }

    public String getString(int theCol) throws SQLException {
        return this.resultSet.getString(theCol);
    }

    public Object getObject(int theCol) throws SQLException {
        return this.resultSet.getObject(theCol);
    }

    public Date getTimestamp(int theCol) throws SQLException {
        return this.resultSet.getTimestamp(theCol);
    }

    public void cleanup() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.resultSet = null;
        }
        if (this.stat != null) {
            try {
                this.stat.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.stat = null;
        }
        if (this.preparedStat != null) {
            try {
                this.preparedStat.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.preparedStat = null;
        }
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.db = null;
        }
    }

    public Collection getNameList(String theDbRef, String theQuery) {
        ArrayList<String> aList = new ArrayList<String>();
        try {
            try {
                this.start(theDbRef);
                this.execQ(theQuery);
                while (this.nextRow()) {
                    aList.add(this.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var6_5 = null;
                this.cleanup();
            }
            Object var6_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Collection getNameListById(String theDbRef, String theQuery, long theId) {
        ArrayList<String> aList = new ArrayList<String>();
        try {
            try {
                this.start(theDbRef);
                this.prep(theQuery);
                this.setLong(1, theId);
                this.execQ();
                while (this.nextRow()) {
                    aList.add(this.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var8_6 = null;
                this.cleanup();
            }
            Object var8_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.cleanup();
            throw throwable;
        }
        return aList;
    }

    public Map getNameIdMap(String theDbRef, String theQuery) {
        HashMap<String, Long> aMap = new HashMap<String, Long>();
        try {
            try {
                this.start(theDbRef);
                this.execQ(theQuery);
                while (this.nextRow()) {
                    aMap.put(this.getString(2), new Long(this.getLong(1)));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var6_5 = null;
                this.cleanup();
            }
            Object var6_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
        return aMap;
    }

    public Map getIdNameMap(String theDbRef, String theQuery) {
        HashMap<Long, String> aMap = new HashMap<Long, String>();
        try {
            try {
                this.start(theDbRef);
                this.execQ(theQuery);
                while (this.nextRow()) {
                    aMap.put(new Long(this.getLong(1)), this.getString(2));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var6_5 = null;
                this.cleanup();
            }
            Object var6_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
        return aMap;
    }

    public Map getNameIdMapById(String theDbRef, String theQuery, long theId) {
        HashMap<String, Long> aMap = new HashMap<String, Long>();
        try {
            try {
                this.start(theDbRef);
                this.prep(theQuery);
                this.setLong(1, theId);
                this.execQ();
                while (this.nextRow()) {
                    aMap.put(this.getString(2), new Long(this.getLong(1)));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var8_6 = null;
                this.cleanup();
            }
            Object var8_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.cleanup();
            throw throwable;
        }
        return aMap;
    }

    public Map getIdNameMapById(String theDbRef, String theQuery, long theId) {
        HashMap<Long, String> aMap = new HashMap<Long, String>();
        try {
            try {
                this.start(theDbRef);
                this.prep(theQuery);
                this.setLong(1, theId);
                this.execQ();
                while (this.nextRow()) {
                    aMap.put(new Long(this.getLong(1)), this.getString(2));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                Object var8_6 = null;
                this.cleanup();
            }
            Object var8_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.cleanup();
            throw throwable;
        }
        return aMap;
    }

    public QueryManager open(String dbRef) throws SQLException {
        this.start(dbRef);
        return this;
    }

    public QueryManager open() throws SQLException {
        return this;
    }

    public QueryManager close() throws SQLException {
        return this;
    }

    public void commit() throws SQLException {
        this.db.commit();
    }

    public void rollback() throws SQLException {
        this.db.rollback();
    }

    public Blob getBlob(int index) throws SQLException {
        return this.resultSet.getBlob(index);
    }

    public Clob getClob(int index) throws SQLException {
        return this.resultSet.getClob(index);
    }

    public Date getDate(int index) throws SQLException {
        return this.resultSet.getDate(index);
    }

    public Date getTime(int index) throws SQLException {
        return this.resultSet.getTime(index);
    }

    public Float getFloatO(int index) throws SQLException {
        float r = this.resultSet.getFloat(index);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Float(r);
    }

    public float getFloat(int index) throws SQLException {
        return this.resultSet.getFloat(index);
    }

    public Double getDoubleO(int index) throws SQLException {
        double r = this.resultSet.getDouble(index);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Double(r);
    }

    public double getDouble(int index) throws SQLException {
        return this.resultSet.getDouble(index);
    }

    public Byte getByteO(int index) throws SQLException {
        byte r = this.resultSet.getByte(index);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Byte(r);
    }

    public byte getByte(int index) throws SQLException {
        return this.resultSet.getByte(index);
    }

    public Short getShortO(int index) throws SQLException {
        short r = this.resultSet.getShort(index);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return new Short(r);
    }

    public short getShort(int index) throws SQLException {
        return this.resultSet.getShort(index);
    }
}

