/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.figures.SpinTextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.SpinConnectionTool;
import CH.ifa.draw.standard.SpinCreationTool;
import CH.ifa.draw.standard.SpinDeleteCommand;
import CH.ifa.draw.standard.SpinSelectionTool;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.FigureVector;
import cocon.CoConnection;
import cocon.CoFolder;
import cocon.CoFolderConnection;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectHotdrawView;
import cocon.CoObjectTreeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import miningmart.hci.gui.main.Application;

public class SpinDrawingView
extends StandardDrawingView {
    private int objectCount;
    private final int FIGURE_SIZE = 20;
    private final int SPACE_SIZE = 15;
    private Point insertPoint = null;
    private Dimension fViewSize = new Dimension(600, 600);
    private FigureVector figures;

    public SpinDrawingView(DrawingEditor editor, int width, int height) {
        super(editor, width, height);
        this.setBackground(Color.white);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.tool() instanceof SpinSelectionTool) {
            ((SpinSelectionTool)this.tool()).mouseClickedInView(e);
            this.repaint();
            Application.updateMenuEdit();
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.tool() instanceof SpinSelectionTool && this.selectionCount() < 2) {
            ((SpinSelectionTool)this.tool()).mousePressedInView(e);
            this.repaint();
            Application.updateMenuEdit();
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.tool() instanceof SpinSelectionTool) {
            ((SpinSelectionTool)this.tool()).mouseReleasedInView(e);
        }
    }

    public void setDrawingViewSize(int x, int y) {
        this.fViewSize = new Dimension(x, y);
    }

    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    public void drawFolder(CoFolder folder) {
        int j;
        int outConnectionCount;
        CoObject object;
        ((CoObjectHotdrawView)Application.graphDocumentView).setShownFolder(folder);
        this.setDrawing((Drawing)new StandardDrawing());
        this.objectCount = 0;
        Vector<Object> objectVector = new Vector<Object>();
        this.figures = new FigureVector();
        int i = 0;
        while (folder != null && folder.getChildAt(i) != null) {
            object = (CoObject)folder.getChildAt(i++);
            objectVector.add(object);
        }
        CoModelConnection c = new CoModelConnection();
        Vector<CoObject> connectedObjects = new Vector<CoObject>();
        for (i = 0; i < objectVector.size(); ++i) {
            object = (CoObject)objectVector.get(i);
            CoFolderConnection fc = new CoFolderConnection();
            outConnectionCount = object.getOutConnectionCount(fc.getClass());
            int inConnectionCount = object.getInConnectionCount(fc.getClass());
            for (j = 0; j < outConnectionCount || j < inConnectionCount; ++j) {
                CoObject connectedFolder;
                if (j < outConnectionCount && (connectedFolder = (CoObject)object.getOutConnection(fc.getClass(), j).getDestination()) instanceof CoFolder && !folder.equals(connectedFolder) && !connectedObjects.contains(connectedFolder) && !folder.equals(connectedFolder.getParent())) {
                    connectedObjects.add(connectedFolder);
                }
                if (j >= inConnectionCount || !((connectedFolder = (CoObject)object.getInConnection(fc.getClass(), j).getSource()) instanceof CoFolder) || folder.equals(connectedFolder) || connectedObjects.contains(connectedFolder) || folder.equals(connectedFolder.getParent())) continue;
                connectedObjects.add(connectedFolder);
            }
            if (object instanceof CoObjectTreeView) continue;
            this.createAndInsertObjectFigure(object, folder);
        }
        for (i = 0; i < connectedObjects.size(); ++i) {
            object = (CoObject)connectedObjects.get(i);
            if (object instanceof CoObjectTreeView) continue;
            this.createAndInsertObjectFigure(object, folder);
        }
        objectVector.addAll(connectedObjects);
        SpinConnectionTool connectionTool = new SpinConnectionTool((DrawingView)this, (ConnectionFigure)new SpinLineConnection());
        for (i = 0; i < objectVector.size(); ++i) {
            CoObject destination;
            object = (CoObject)objectVector.get(i);
            ComponentFigure startFigure = (ComponentFigure)this.figures.getFigureWithObject(object);
            ComponentFigure endFigure = null;
            if (startFigure == null) continue;
            outConnectionCount = object.getOutConnectionCount(c.getClass());
            for (j = 0; j < outConnectionCount; ++j) {
                CoModelConnection modelConnection = (CoModelConnection)object.getOutConnection(c.getClass(), j);
                destination = (CoObject)modelConnection.getDestination();
                endFigure = (ComponentFigure)this.figures.getFigureWithObject(destination);
                if (endFigure == null) continue;
                connectionTool.createFigureConnection((Figure)startFigure, startFigure.center(), (Figure)endFigure, endFigure.center(), (CoConnection)modelConnection);
            }
            outConnectionCount = object.getOutConnectionCount(new CoFolderConnection().getClass());
            for (j = 0; j < outConnectionCount; ++j) {
                CoFolderConnection folderConnection = (CoFolderConnection)object.getOutConnection(new CoFolderConnection().getClass(), j);
                destination = (CoObject)folderConnection.getDestination();
                endFigure = (ComponentFigure)this.figures.getFigureWithObject(destination);
                if (endFigure == null) {
                    endFigure = (ComponentFigure)this.figures.getFigureWithObject((CoObject)Application.graphDocumentView.getFolder(destination));
                }
                if (endFigure == null) continue;
                connectionTool.createFigureConnection((Figure)startFigure, startFigure.center(), (Figure)endFigure, endFigure.center(), (CoConnection)folderConnection);
            }
        }
    }

    public ComponentFigure createAndInsertObjectFigure(CoObject o, CoFolder f) {
        String iconName = " ";
        String s = o.getClass().toString();
        iconName = o instanceof CoFolder ? "coFolder" : s.substring(s.lastIndexOf(".") + 1);
        SpinCreationTool ct = null;
        ComponentFigure figure = null;
        ct = new SpinCreationTool((DrawingView)this, (Figure)new ComponentFigure(null, String.valueOf(String.valueOf("images/").concat(String.valueOf(iconName))).concat(String.valueOf(".gif")), new Point(0, 0), f));
        Point p = null;
        if (o.getPosition() != null) {
            p = o.getPosition().getLocation(f);
        }
        if (p != null && !p.equals(new Point(0, 0))) {
            ct.addFigure(p);
        } else if (this.getInsertPoint() != null) {
            ct.addFigure(this.getInsertPoint());
            o.getPosition().setLocation(this.getInsertPoint(), f);
        } else {
            p = new Point(35 * (++this.objectCount % 7), 20 * this.objectCount);
            ct.addFigure(p);
            o.getPosition().setLocation(p, f);
        }
        figure = (ComponentFigure)ct.createdFigure();
        if (figure != null) {
            figure.setObject(o);
            if (o.getName() != null) {
                figure.setAttribute("Name", o.getName());
            } else {
                figure.setAttribute("Name", iconName);
            }
        }
        SpinTextFigure textFigure = new SpinTextFigure();
        textFigure.connect((Figure)figure);
        textFigure.setText(figure.getObject().getName());
        textFigure.connectorVisibility(true);
        this.add((Figure)textFigure);
        return figure;
    }

    public void addModelConnection(Object source, Object destination, CoConnection connection) {
        ComponentFigure startFigure = (ComponentFigure)this.figures.getFigureWithObject((CoObject)source);
        ComponentFigure endFigure = (ComponentFigure)this.figures.getFigureWithObject((CoObject)destination);
        if (startFigure != null && endFigure != null) {
            SpinConnectionTool connectionTool = new SpinConnectionTool((DrawingView)this, (ConnectionFigure)new SpinLineConnection());
            connectionTool.createFigureConnection((Figure)startFigure, startFigure.center(), (Figure)endFigure, endFigure.center(), connection);
        }
    }

    public Figure add(Figure f) {
        if (f instanceof ComponentFigure) {
            this.figures.add(f);
            AbstractAction action = ((ComponentFigure)f).getAction();
            if (action != null) {
                Application.setSelectedNode((CoObject)Application.graphDocumentView.getShownFolder());
                action.actionPerformed(new ActionEvent(f, 0, ""));
                return f;
            }
        }
        return super.add(f);
    }

    public void setFigures(FigureVector newFigures) {
        this.figures = newFigures;
    }

    public FigureVector getFigures() {
        return this.figures;
    }

    public void setInsertPoint(Point p) {
        this.insertPoint = p;
    }

    public Point getInsertPoint() {
        return this.insertPoint;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            SpinDeleteCommand cmd = new SpinDeleteCommand("Delete", (DrawingView)this);
            cmd.execute();
        } else if (code == 40 || code == 38 || code == 39 || code == 37) {
            this.handleCursorKey(code);
        } else {
            this.tool().keyDown(e, code);
        }
        this.checkDamage();
    }
}

