/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.SpinTool;
import cocon.CiConnectable;
import cocon.CoConnection;
import cocon.CoModelConnection;
import cocon.CoObject;
import java.awt.Point;
import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.chInterface.ToolI;

public class SpinConnectionTool
extends ConnectionTool
implements SpinTool,
ToolI {
    public SpinConnectionTool(DrawingView view, ConnectionFigure prototype) {
        super(view, prototype);
    }

    public SpinConnectionTool(FigureI prototype) {
        super(null, (ConnectionFigure)prototype);
    }

    public SpinConnectionTool() {
        super(null, null);
    }

    public void setView(DrawingView view) {
        ((AbstractTool)this).fView = view;
    }

    public void createFigureConnection(Figure startTarget, Point startPoint, Figure endTarget, Point endPoint, CoConnection modelConnection) {
        block1: {
            int y;
            int x;
            Connector startConnector;
            if (startTarget == null || endTarget == null || (startConnector = this.findConnector(x = startPoint.x, y = startPoint.y, startTarget)) == null) break block1;
            ConnectionFigure connection = this.createConnection();
            connection.startPoint(x, y);
            x = endPoint.x;
            y = endPoint.y;
            Connector endConnector = this.findConnector(x, y, endTarget);
            if (endConnector != null) {
                ((SpinLineConnection)connection).setConnection(modelConnection);
                connection.endPoint(x, y);
                connection.connectStart(startConnector);
                connection.connectEnd(endConnector);
                this.view().add((Figure)connection);
                connection.updateConnection();
            }
        }
    }

    public void doAdditionalWork() {
        ConnectionFigure fConnection = this.createdFigure();
        Figure start = ((SpinLineConnection)fConnection).startFigure();
        Figure end = ((SpinLineConnection)fConnection).endFigure();
        if (start instanceof ComponentFigure && end instanceof ComponentFigure) {
            if (fConnection != null) {
                this.view().remove((Figure)fConnection);
            }
            CoObject startObject = ((ComponentFigure)start).getObject();
            startObject.addConnection((CoConnection)new CoModelConnection(), (CiConnectable)((ComponentFigure)end).getObject());
        }
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void setPrototype(FigureI f) {
        this.fPrototype = (ConnectionFigure)f;
    }
}

