/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.internal;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.internal.DrawPanel;
import CH.ifa.draw.standard.SpinDrawingView;
import CH.ifa.draw.standard.SpinSelectionTool;
import CH.ifa.draw.standard.SpinTool;
import CH.ifa.draw.standard.SpinToolButton;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.PaletteListener;
import cocon.CoComponent;
import cocon.CoComponentList;
import cocon.CoObject;
import cocon.CoObjectHotdrawView;
import cocon.util.SpinTree;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import miningmart.hci.gui.chInterface.SpinPanelI;
import miningmart.hci.gui.main.Application;

public class SpinPanel
extends DrawPanel
implements SpinPanelI {
    private SpinDrawingView fView = (SpinDrawingView)this.createDrawingView();
    private SpinTree viewTree;
    private JScrollPane sp = null;
    JPanel palette = null;

    public SpinPanel() {
        this.initSpinPanel();
    }

    private void initSpinPanel() {
        this.viewTree = new SpinTree();
        this.add((Component)this.viewTree, "East");
    }

    public StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        this.fView = new SpinDrawingView((DrawingEditor)this, d.width, d.height);
        return this.fView;
    }

    public void destroy() {
        super.destroy();
    }

    protected void createTools(JPanel palette) {
        this.palette = palette;
        Object tool = null;
        CoComponentList componentList = Application.componentList;
        Enumeration componentEnumeration = componentList.depthFirstEnumeration();
        while (componentEnumeration.hasMoreElements()) {
            CoComponent compItem;
            CoObject comp = (CoObject)componentEnumeration.nextElement();
            if (!(comp instanceof CoComponent) || (compItem = (CoComponent)comp).getComponentClass() == null || compItem.toString().equalsIgnoreCase("folder")) continue;
            SpinToolButton button = (SpinToolButton)((Object)compItem.getInsertButton());
            button.setPaletteListener((PaletteListener)this);
            ((SpinTool)button.tool()).setView(this.view());
        }
        this.setDefaultToolButton((JButton)Application.getDefaultToolButton());
    }

    protected Tool createSelectionTool() {
        return new SpinSelectionTool(this.view());
    }

    public StandardDrawingView getView() {
        return this.fView;
    }

    public JPanel getPalette() {
        return this.palette;
    }

    protected JComponent createContents(StandardDrawingView view) {
        this.sp = new JScrollPane((Component)view);
        JScrollBar vadjust = this.sp.getVerticalScrollBar();
        JScrollBar hadjust = this.sp.getHorizontalScrollBar();
        hadjust.setUnitIncrement(16);
        vadjust.setUnitIncrement(16);
        return this.sp;
    }

    public void setScrollPaneView(SpinDrawingView view) {
        this.sp.setViewportView((Component)((Object)view));
    }

    public CoObject getSelectedNode() {
        SpinDrawingView view = (SpinDrawingView)this.getView();
        Vector v = view.selection();
        if (v.size() == 1 && v.elementAt(0) instanceof ComponentFigure) {
            ComponentFigure figure = (ComponentFigure)((Object)v.elementAt(0));
            return figure.getObject();
        }
        if (this.getTree().getSelectionModel().getLeadSelectionPath() != null && v.size() == 0) {
            return (CoObject)this.getTree().getSelectionModel().getLeadSelectionPath().getLastPathComponent();
        }
        return null;
    }

    public void setSelectedNode(CoObject node) {
        SpinDrawingView view = (SpinDrawingView)this.getView();
        view.clearSelection();
        if (node != null) {
            FigureEnumeration figures = view.drawing().figures();
            while (figures.hasMoreElements()) {
                Object figure = figures.nextElement();
                if (!figure.getClass().isInstance((Object)new ComponentFigure()) || !node.equals(((ComponentFigure)((Object)figure)).getObject())) continue;
                view.addToSelection((Figure)((ComponentFigure)((Object)figure)));
                ((SpinTree)this.getTree()).setSelectedNode(node);
                return;
            }
        }
        ((SpinTree)this.getTree()).setSelectedNode(node);
    }

    public int getSelectionCount() {
        return this.getView().selectionCount();
    }

    public void setModel(TreeModel newTreeModel) {
        this.viewTree.setModel(newTreeModel);
    }

    public TreeModel getModel() {
        return this.viewTree.getModel();
    }

    public JTree getTree() {
        return this.viewTree;
    }

    public ComponentFigure insertObject(CoObject o) {
        ((CoObject)this.getModel().getRoot()).add((MutableTreeNode)o);
        return ((SpinDrawingView)this.view()).createAndInsertObjectFigure(o, ((CoObjectHotdrawView)this.view()).getShownFolder());
    }

    public void setDrawingViewSize(int x, int y) {
        ((SpinDrawingView)this.getView()).setDrawingViewSize(x, y);
    }
}

