/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.Figure;
import cocon.CiConnectable;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoConnectionDescriptor;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectHotdrawView;
import cocon.CoObjectTreeView;
import java.awt.Color;
import java.awt.event.MouseEvent;
import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.main.Application;

public class SpinLineConnection
extends LineConnection
implements FigureI {
    private CoConnection connection = null;
    private boolean isConnected = true;
    private boolean isDisconnected = false;

    public SpinLineConnection() {
        this.setStartDecoration(null);
        this.setEndDecoration((LineDecoration)new ArrowTip());
        this.setFrameColor(Color.gray);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            CoObject start = ((ComponentFigure)this.startFigure()).getObject();
            CoObject end = ((ComponentFigure)this.endFigure()).getObject();
            CoObjectHotdrawView view = (CoObjectHotdrawView)Application.graphDocumentView;
            CoObject toSelect = view.getShownFolder().equals(view.getFolder(start)) ? start : end;
            Application.setSelectedNode((CoObject)toSelect);
            Application.dispatcher.editConnections();
        }
    }

    public void mousePressed(MouseEvent e) {
        ((CoObjectTreeView)Application.documentView).setSelectedNode(null);
    }

    protected void handleDisconnect(Figure start, Figure end) {
        if (this.isConnected && start != null && end != null) {
            this.isConnected = false;
            this.isDisconnected = true;
        }
    }

    protected void handleConnect(Figure start, Figure end) {
        if (this.isDisconnected && start != null && end != null) {
            ((ComponentFigure)start).getObject().removeConnection(this.getConnection());
            ((ComponentFigure)start).getObject().addConnection((CoConnection)new CoModelConnection(), (CiConnectable)((ComponentFigure)end).getObject());
            this.isConnected = true;
            this.isDisconnected = false;
        }
    }

    public boolean canConnect(Figure start, Figure end) {
        if (!super.canConnect(start, end)) {
            return false;
        }
        if (start instanceof ComponentFigure && end instanceof ComponentFigure) {
            int connectionCount;
            int i;
            CoObject source = ((ComponentFigure)start).getObject();
            CoObject destination = ((ComponentFigure)end).getObject();
            CoModelConnection connection = new CoModelConnection();
            CoConnectionDescriptor[] srcCD = source.getConnectionDescriptors();
            for (i = 0; i < srcCD.length; ++i) {
                if (srcCD[i].direction != 1 || !srcCD[i].connectionClass.isAssignableFrom(connection.getClass()) || !srcCD[i].destinationClass.isAssignableFrom(destination.getClass())) continue;
                connectionCount = source.getOutConnectionCount(srcCD[i].connectionClass, srcCD[i].destinationClass);
                if (srcCD[i].maxConnections < 0 || srcCD[i].maxConnections > connectionCount) break;
            }
            if (i == srcCD.length) {
                this.setFrameColor(Color.gray);
                return false;
            }
            CoConnectionDescriptor[] dstCD = destination.getConnectionDescriptors();
            for (i = 0; i < dstCD.length; ++i) {
                if (dstCD[i].direction != 2 || !dstCD[i].connectionClass.isAssignableFrom(connection.getClass()) || !dstCD[i].sourceClass.isAssignableFrom(source.getClass())) continue;
                connectionCount = destination.getInConnectionCount(dstCD[i].connectionClass, dstCD[i].sourceClass);
                if (dstCD[i].maxConnections < 0 || dstCD[i].maxConnections > connectionCount) break;
            }
            if (i == dstCD.length) {
                this.setFrameColor(Color.gray);
                return false;
            }
            CoConnectionChangeEvent cce = new CoConnectionChangeEvent((Object)this, (CoConnection)connection, (Object)source, (Object)destination);
            source.canAddConnection(cce);
            if (cce.getError() < 0) {
                this.setFrameColor(Color.gray);
                return false;
            }
            destination.canAddConnection(cce);
            if (cce.getError() < 0) {
                this.setFrameColor(Color.gray);
                return false;
            }
            this.setFrameColor(Color.black);
            return true;
        }
        this.setFrameColor(Color.gray);
        return false;
    }

    public void setConnection(CoConnection connection) {
        this.connection = connection;
    }

    public CoConnection getConnection() {
        return this.connection;
    }
}

